/*
 * Decompiled with CFR 0.152.
 */
package de.tsl2.nano.collection;

import de.tsl2.nano.core.log.LogFactory;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.Map;
import org.apache.commons.logging.Log;

public class TimedReferences<T> {
    Log LOG = LogFactory.getLog(TimedReferences.class);
    static final long TIMEOUT = 60000L;
    long periodToBeOld = 60000L;
    Map<Long, T> tempHardRefs = new LinkedHashMap<Long, T>();
    long lastRemove = 0L;

    public void add(T value) {
        if (this.isLongPeriod(this.lastRemove)) {
            this.removeOldTemporaries();
        }
        this.tempHardRefs.put(System.currentTimeMillis(), value);
    }

    public void removeOldTemporaries() {
        Long storageTime;
        this.lastRemove = System.currentTimeMillis();
        int removedElements = 0;
        int elements = this.tempHardRefs.size();
        HashSet<Long> storageTimes = new HashSet<Long>(this.tempHardRefs.keySet());
        Iterator iterator = storageTimes.iterator();
        while (iterator.hasNext() && this.isLongPeriod(storageTime = (Long)iterator.next())) {
            this.tempHardRefs.remove(storageTime);
            ++removedElements;
        }
        this.LOG.debug((Object)("removed " + removedElements + " of " + elements + " temporary elements"));
    }

    public void clear() {
        this.tempHardRefs.clear();
    }

    private boolean isLongPeriod(long time) {
        return System.currentTimeMillis() - time > this.periodToBeOld;
    }

    public long getTimeout() {
        return this.periodToBeOld;
    }

    public void setTimeout(long periodToBeOld) {
        this.periodToBeOld = periodToBeOld;
    }
}

