/*
 * Decompiled with CFR 0.152.
 */
package de.tsl2.nano.collection;

import de.tsl2.nano.core.ITransformer;
import de.tsl2.nano.core.cls.BeanClass;
import java.lang.reflect.InvocationHandler;
import java.lang.reflect.Method;
import java.lang.reflect.Proxy;
import java.util.Iterator;
import java.util.Queue;

public class TransformingIterator<S, T>
implements Iterator<T> {
    Iterable<S> parent;
    Queue<S> previewItems;
    Iterator<S> parentIt;
    ITransformer<S, T> transformer;
    int i = 0;

    public TransformingIterator(Iterable<S> parent, ITransformer<S, T> transformer) {
        this.parent = parent;
        this.transformer = transformer;
        this.parentIt = parent.iterator();
    }

    @Override
    public boolean hasNext() {
        return this.parentIt.hasNext();
    }

    @Override
    public T next() {
        return (T)this.transformer.transform(this.parentIt.next());
    }

    @Override
    public void remove() {
        this.parentIt.remove();
    }

    public static <I extends Iterable<T>, S, T> I getTransformingIterable(final Iterable<S> iterable, final ITransformer<S, T> transformer) {
        return (I)((Iterable)Proxy.newProxyInstance(Thread.currentThread().getContextClassLoader(), BeanClass.getBeanClass(iterable.getClass()).getInterfaces(), new InvocationHandler(){

            @Override
            public Object invoke(Object proxy, Method method, Object[] args) throws Throwable {
                TransformingIterator result = method.invoke((Object)iterable, args);
                if (Iterator.class.isAssignableFrom(method.getReturnType())) {
                    result = new TransformingIterator(iterable, transformer);
                }
                return result;
            }
        }));
    }
}

