/*
 * Decompiled with CFR 0.152.
 */
package de.tsl2.nano.historize;

import de.tsl2.nano.core.ManagedException;
import de.tsl2.nano.core.util.FileUtil;
import java.io.File;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.Writer;
import java.util.Collection;
import java.util.LinkedHashSet;
import java.util.Properties;

public class HistorizedInput<T>
extends Properties {
    private static final long serialVersionUID = -7825644997402507863L;
    File file;
    Class<T> itemType;
    int maxCount;
    LinkedHashSet<T> list;
    private static final String KEY_NAME_PREFIX = "entry";

    HistorizedInput(String path, String name, int maxCount, Class<T> itemType) {
        this.file = new File(path + FileUtil.getValidFileName((String)name) + ".hist");
        this.itemType = itemType;
        this.maxCount = maxCount;
        if (this.file.exists()) {
            try {
                this.load(new FileReader(this.file));
            }
            catch (Exception e) {
                ManagedException.forward((Throwable)e);
            }
        }
    }

    public Collection<Object> getPropertyValues() {
        return this.values();
    }

    public Collection<T> getAsInstanceList() {
        if (this.list == null) {
            String value;
            this.list = new LinkedHashSet(this.size());
            for (int i = 0; i < this.maxCount && (value = this.getProperty(KEY_NAME_PREFIX + i)) != null; ++i) {
                try {
                    this.list.add(this.itemType.getConstructor(String.class).newInstance(value));
                    continue;
                }
                catch (Exception e) {
                    ManagedException.forward((Throwable)e);
                }
            }
        }
        return this.list;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addAndSave(String newEntry) {
        if (newEntry == null || newEntry.length() == 0) {
            return;
        }
        if (this.values().contains(newEntry)) {
            return;
        }
        for (int i = 0; i < this.maxCount; ++i) {
            String value = this.getProperty(KEY_NAME_PREFIX + i);
            if (value != null) {
                if (i != this.maxCount - 1) continue;
                for (int j = 0; j < this.maxCount - 1; ++j) {
                    this.setProperty(KEY_NAME_PREFIX + j, this.getProperty(KEY_NAME_PREFIX + (j + 1)));
                }
            }
            this.setProperty(KEY_NAME_PREFIX + i, newEntry);
            break;
        }
        FileWriter writer = null;
        try {
            this.list = null;
            if (!this.file.exists()) {
                FileUtil.createPath((String)this.file.getPath());
            }
            writer = new FileWriter(this.file);
            this.store(writer, "Created by class HistorizedInput (NanoFix)");
            FileUtil.close((Writer)writer, (boolean)false);
        }
        catch (Exception e) {
            ManagedException.forward((Throwable)e);
        }
        finally {
            FileUtil.close(writer, (boolean)false);
        }
    }

    public boolean delete() {
        return this.file.delete();
    }
}

