/*
 * Decompiled with CFR 0.152.
 */
package de.tsl2.nano.historize;

import de.tsl2.nano.core.ENV;
import de.tsl2.nano.core.ManagedException;
import de.tsl2.nano.historize.HistorizedInput;
import java.util.Hashtable;
import java.util.Map;
import java.util.Properties;
import java.util.Set;

public class HistorizedInputFactory
extends Properties {
    private static final long serialVersionUID = -5485485250948235886L;
    private static Map<String, HistorizedInput> factoryMap = new Hashtable<String, HistorizedInput>();
    private static String path = ENV.getConfigPath() + "temp/";

    public static void setPath(String path) {
        HistorizedInputFactory.path = path;
    }

    public static final HistorizedInput instance(String name) {
        HistorizedInput historizedInput = factoryMap.get(name);
        if (historizedInput == null) {
            throw new ManagedException("please call the create-method before instance()", new Object[0]);
        }
        return historizedInput;
    }

    public static final boolean exists(String name) {
        return factoryMap.get(name) != null;
    }

    public static final HistorizedInput<String> create(String name) {
        return HistorizedInputFactory.create(name, 500, String.class);
    }

    public static final <T> HistorizedInput<T> create(String name, int maxCount, Class<T> type) {
        HistorizedInput<T> historizedInput = factoryMap.get(name);
        if (historizedInput == null) {
            historizedInput = new HistorizedInput<T>(path, name, maxCount, type);
            factoryMap.put(name, historizedInput);
        }
        return historizedInput;
    }

    public static final boolean delete(String name) {
        HistorizedInput historizedInput = factoryMap.remove(name);
        if (historizedInput == null) {
            throw new ManagedException("tsl2nano.implementationerror", new Object[]{name});
        }
        return historizedInput.delete();
    }

    public static final boolean deleteAll() {
        Set<String> histories = factoryMap.keySet();
        boolean result = true;
        for (String name : histories) {
            result &= HistorizedInputFactory.delete(name);
        }
        return result;
    }
}

