/*
 * Decompiled with CFR 0.152.
 */
package de.tsl2.nano.historize;

import de.tsl2.nano.core.util.Util;

public class Volatile<T> {
    long start;
    long period;
    T value;

    public Volatile(long period) {
        this(period, null);
    }

    public Volatile(long period, T value) {
        this.period = period;
        if (value != null) {
            this.set(value);
        }
    }

    public boolean expired() {
        boolean expired;
        boolean bl = expired = System.currentTimeMillis() > this.start + this.period;
        if (expired) {
            this.value = null;
        }
        return expired;
    }

    public T get() {
        return this.expired() ? null : (T)this.value;
    }

    public T invalidate() {
        T last = this.get();
        this.value = null;
        this.start = 0L;
        return last;
    }

    public T set(T value) {
        this.value = value;
        this.activate();
        return value;
    }

    protected void activate() {
        this.start = System.currentTimeMillis();
    }

    public String toString() {
        return Util.toString(this.getClass(), (Object[])new Object[]{"timeout", this.period});
    }
}

