/*
 * Decompiled with CFR 0.152.
 */
package de.tsl2.nano.structure;

import de.tsl2.nano.collection.CollectionUtil;
import de.tsl2.nano.core.ITransformer;
import de.tsl2.nano.core.messaging.EventController;
import de.tsl2.nano.core.messaging.IListener;
import de.tsl2.nano.core.util.StringUtil;
import de.tsl2.nano.structure.AConnection;
import de.tsl2.nano.structure.IConnection;
import de.tsl2.nano.structure.INode;
import java.util.LinkedList;
import java.util.List;

public class ANode<T, D>
implements INode<T, D> {
    protected T core;
    protected List<IConnection<T, D>> connections;
    protected EventController controller;

    public ANode() {
    }

    public ANode(T core) {
        this(core, null);
    }

    public ANode(T core, List<IConnection<T, D>> connections) {
        this(core, connections, null);
    }

    public ANode(T core, List<IConnection<T, D>> connections, EventController controller) {
        this.core = core;
        this.connections = connections;
        this.controller = controller;
    }

    @Override
    public T getCore() {
        return this.core;
    }

    public EventController getController() {
        if (this.controller == null) {
            this.controller = new EventController();
        }
        return this.controller;
    }

    @Override
    public List<IConnection<T, D>> getConnections() {
        if (this.connections == null) {
            this.connections = new LinkedList<IConnection<T, D>>();
        }
        return this.connections;
    }

    public IConnection<T, D> getConnection(INode<T, D> destination) {
        for (IConnection<T, D> c : this.getConnections()) {
            if (!c.getDestination().equals(destination)) continue;
            return c;
        }
        return null;
    }

    public IConnection<T, D> add(ANode<T, D> destination) {
        return this.connect(destination, (D)null);
    }

    @Override
    public IConnection<T, D> connect(ANode<T, D> destination, D descriptor) {
        IConnection<T, D> connection = this.createConnection(destination, descriptor);
        this.getConnections().add(connection);
        if (connection instanceof IListener) {
            this.getController().addListener((IListener)connection);
        }
        return connection;
    }

    protected IConnection<T, D> createConnection(ANode<T, D> destination, D descriptor) {
        return new AConnection<T, D>(destination, descriptor);
    }

    protected List<T> getConnectionItems() {
        return (List)CollectionUtil.getTransforming(this.getConnections(), new ITransformer<IConnection<T, D>, T>(){

            public T transform(IConnection<T, D> toTransform) {
                return toTransform.getDestination().getCore();
            }
        });
    }

    protected INode<T, D> getConnection(T item) {
        for (IConnection<T, D> c : this.getConnections()) {
            if (!item.equals(c.getDestination().getCore())) continue;
            return c.getDestination();
        }
        return null;
    }

    @Override
    public INode<T, D> path(String ... nodeFilters) {
        List<T> filter = CollectionUtil.getFiltering(this.getConnectionItems(), new StringBuilder(nodeFilters[0]));
        if (filter.size() == 0) {
            return null;
        }
        if (filter.size() > 1) {
            throw new IllegalArgumentException("node filter " + nodeFilters[0] + " was not unique for tree-children " + StringUtil.toString(this.getConnections(), (int)100));
        }
        return this.getConnection(filter.iterator().next()).path((String[])CollectionUtil.copyOfRange((Object[])nodeFilters, (int)1, (int)nodeFilters.length));
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.core == null ? 0 : this.core.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        return this.hashCode() == obj.hashCode();
    }
}

