/*
 * Decompiled with CFR 0.152.
 */
package org.xmldb.api;

import java.util.Properties;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import org.xmldb.api.base.Collection;
import org.xmldb.api.base.Database;
import org.xmldb.api.base.XMLDBException;

public class DatabaseManager {
    protected static final String URI_PREFIX = "xmldb:";
    static final Properties properties = new Properties();
    static final ConcurrentMap<String, Database> databases = new ConcurrentHashMap<String, Database>();

    public static Database[] getDatabases() {
        return databases.values().toArray(new Database[0]);
    }

    public static void registerDatabase(Database database) throws XMLDBException {
        String name = database.getName();
        if (name == null || name.equals("")) {
            throw new XMLDBException(401);
        }
        String[] databaseNames = database.getNames();
        if (databaseNames == null || databaseNames.length == 0 || databaseNames[0].equals("")) {
            throw new XMLDBException(401);
        }
        DatabaseManager.updateDatabases(name, database);
        for (String databaseName : databaseNames) {
            DatabaseManager.updateDatabases(databaseName, database);
        }
    }

    private static void updateDatabases(String databaseName, Database database) throws XMLDBException {
        Database existing = databases.putIfAbsent(databaseName, database);
        if (existing != null && existing != database) {
            throw new XMLDBException(401);
        }
    }

    public static void deregisterDatabase(Database database) throws XMLDBException {
        String[] databaseNames;
        String name = database.getName();
        if (name != null) {
            databases.remove(name);
        }
        if ((databaseNames = database.getNames()) != null) {
            for (String databaseName : databaseNames) {
                databases.remove(databaseName);
            }
        }
    }

    public static Collection getCollection(String uri) throws XMLDBException {
        return DatabaseManager.getCollection(uri, null, null);
    }

    public static Collection getCollection(String uri, String username, String password) throws XMLDBException {
        Database db = DatabaseManager.getDatabase(uri);
        return db.getCollection(DatabaseManager.stripURIPrefix(uri), username, password);
    }

    public static String getConformanceLevel(String uri) throws XMLDBException {
        Database database = DatabaseManager.getDatabase(uri);
        return database.getConformanceLevel();
    }

    public static String getProperty(String name) {
        return properties.getProperty(name);
    }

    public static void setProperty(String name, String value) {
        properties.put(name, value);
    }

    protected static Database getDatabase(String uri) throws XMLDBException {
        if (!uri.startsWith(URI_PREFIX)) {
            throw new XMLDBException(5);
        }
        int end = uri.indexOf(":", URI_PREFIX.length());
        if (end == -1) {
            throw new XMLDBException(5);
        }
        String databaseName = uri.substring(URI_PREFIX.length(), end);
        Database db = (Database)databases.get(databaseName);
        if (db == null) {
            throw new XMLDBException(400);
        }
        return db;
    }

    protected static String stripURIPrefix(String uri) throws XMLDBException {
        if (!uri.startsWith(URI_PREFIX)) {
            throw new XMLDBException(5);
        }
        return uri.substring(URI_PREFIX.length(), uri.length());
    }
}

