package net.sf.xmlform.spring.impl;

import java.util.Collections;
import java.util.List;

import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Condition;
import org.springframework.context.annotation.ConditionContext;
import org.springframework.context.annotation.Conditional;
import org.springframework.context.annotation.Configuration;
import org.springframework.core.type.AnnotatedTypeMetadata;

import net.sf.xmlform.XMLFormPort;
import net.sf.xmlform.config.annotation.FormSetter;
import net.sf.xmlform.impl.DefaultConfigurationProvider;
import net.sf.xmlform.impl.XMLFormPortImpl;
import net.sf.xmlform.spring.support.DynamicFormPort;

@Configuration
public class FormPortConfiguration {
	@Autowired(required = false)
	private List<FormSetter> formSetters = Collections.emptyList();
	@Bean
	@Conditional(FormPortConditional.class)
	public XMLFormPortImpl defaultXMLFormPortImpl(){
		XMLFormPortImpl impl=new XMLFormPortImpl();
		DefaultConfigurationProvider provider=new DefaultConfigurationProvider();
		provider.getConfigurationFactory().setFormSetters(formSetters);
		impl.setConfigurationProvider(provider);
		impl.setCacheable(true);
		return impl;
	}
	public static class FormPortConditional implements Condition{

		@Override
		public boolean matches(ConditionContext cc, AnnotatedTypeMetadata meta) {
			String[] names = cc.getBeanFactory().getBeanNamesForType(XMLFormPort.class);
			return names.length==0;
		}
		
	}
	
	@Bean
	@Conditional(DynamicFormPortConditional.class)
	public DynamicFormPort defaultDynamicFormPort(XMLFormPortImpl impl){
		DynamicFormPort port=new DynamicFormPort();
		port.setXmlFormPort(impl);
		return port;
	}
	public static class DynamicFormPortConditional implements Condition{

		@Override
		public boolean matches(ConditionContext cc, AnnotatedTypeMetadata meta) {
			String[] names = cc.getBeanFactory().getBeanNamesForType(DynamicFormPort.class);
			return names.length==0;
		}
		
	}
}
