package net.sf.xmlform.spring.support;

import java.util.ArrayList;
import java.util.Collections;

import net.sf.xmlform.XMLFormException;
import net.sf.xmlform.XMLFormPastport;
import net.sf.xmlform.action.Action;
import net.sf.xmlform.config.ConfigParseResult;
import net.sf.xmlform.config.ConfigurationFactory;
import net.sf.xmlform.config.ConfigurationProvider;
import net.sf.xmlform.config.FormDefinition;
import net.sf.xmlform.data.DataFormat;
import net.sf.xmlform.data.DataSource;
import net.sf.xmlform.data.ResultData;
import net.sf.xmlform.data.SourceData;
import net.sf.xmlform.data.SourceType;
import net.sf.xmlform.form.XMLForm;
import net.sf.xmlform.impl.DefaultConfigurationProvider;
import net.sf.xmlform.impl.XMLFormPortImpl;

public class DynamicFormPort {
	private XMLFormPortImpl xmlFormPort;
	private DefaultConfigurationProvider configurationProvider;
	private String shorthandFieldsPrefix="!";
	private ConfigurationFactory configurationFactory;

	public XMLFormPortImpl getXmlFormPort() {
		return xmlFormPort;
	}

	public void setXmlFormPort(XMLFormPortImpl xmlFormPort) {
		ConfigurationProvider provider = xmlFormPort.getConfigurationProvider();
		if(!(provider instanceof DefaultConfigurationProvider)) {
			throw new IllegalArgumentException("XMLFormPortImpl ConfigurationProvider must be DefaultConfigurationProvider");
		}
		configurationProvider=(DefaultConfigurationProvider)provider;
		configurationFactory=configurationProvider.getConfigurationFactory();
		this.xmlFormPort = xmlFormPort;
	}
	
	public String getShorthandFieldsPrefix() {
		return shorthandFieldsPrefix;
	}

	public void setShorthandFieldsPrefix(String shorthandFieldsPrefix) {
		this.shorthandFieldsPrefix = shorthandFieldsPrefix;
	}
	
	public XMLForm getForm(XMLFormPastport pastport,String formName,Class cls) {
		return doGetForm(pastport,formName,cls);
	}
	public <T> T  parseData(XMLFormPastport pastport,XMLForm sourceForm,SourceType sourceType,DataSource<T> dataSource)throws XMLFormException{
		return xmlFormPort.parseData(pastport, sourceForm, sourceType, dataSource);
	}
	public <T> T formatData(XMLFormPastport pastport,DataFormat<T> format) {
		return xmlFormPort.formatData(pastport, format);
	}
	public ResultData submit(XMLFormPastport pastport,Action action,DataSource<? extends SourceData> dataSource)throws XMLFormException{
		return xmlFormPort.submit(pastport, action, dataSource);
	}
	
	private XMLForm doGetForm(XMLFormPastport pastport,String formName,Class cls){
		XMLFormPortImpl impl=xmlFormPort;
		if(formName.startsWith(shorthandFieldsPrefix)){
			FormDefinition def = impl.getConfigurationProvider().getForm(pastport, formName);
			if(def==null){
				FormDefinition form=new FormDefinition();
				form.setName(formName);
				form.getFields().putAll(configurationFactory.parseShorthandFields(formName.substring(1)));
				configurationProvider.addFormInstances(Collections.singletonList(form));
			}
		}else if(cls!=null){
			FormDefinition def = impl.getConfigurationProvider().getForm(pastport, formName);
			if(def==null){
				ConfigParseResult res = configurationFactory.parseAnnotatedClasses(new Class[] {cls});
				configurationProvider.addFormInstances(new ArrayList(res.getForms().values()));
				configurationProvider.addTypeInstances(new ArrayList(res.getTypes().values()));
			}
		}
		return xmlFormPort.getForm(pastport, formName);
	}
	
}
