package net.sf.xmlform.spring.web;

import java.lang.annotation.ElementType;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;
import java.lang.annotation.Target;

import org.springframework.context.annotation.Import;

import net.sf.xmlform.spring.web.config.SpringMvcConfigurerAdapter;

/**
 * @author Liu Zhikun
 */
@Retention(RetentionPolicy.RUNTIME)
@Target(ElementType.TYPE)
@Import(SpringMvcConfigurerAdapter.class)
public @interface EnableWebXmlForm {
	/*
	 * 0 auto
	 * data count equal or great then compact
	 */
	int compact() default 0;
	String shorthandFieldsPrefix() default "!";
}
