package net.sf.xmlform.spring.web.config;

import java.util.Collections;
import java.util.List;
import java.util.Map;

import org.springframework.beans.factory.SmartInitializingSingleton;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.context.annotation.Import;
import org.springframework.context.annotation.ImportAware;
import org.springframework.core.type.AnnotationMetadata;
import org.springframework.http.converter.HttpMessageConverter;
import org.springframework.web.client.RestTemplate;
import org.springframework.web.method.support.HandlerMethodArgumentResolver;
import org.springframework.web.method.support.HandlerMethodReturnValueHandler;
import org.springframework.web.servlet.HandlerExceptionResolver;
import org.springframework.web.servlet.config.annotation.WebMvcConfigurerAdapter;

import net.sf.xmlform.spring.config.PastportCreator;
import net.sf.xmlform.spring.config.ResultDataPostProcessor;
import net.sf.xmlform.spring.config.TypeSupporter;
import net.sf.xmlform.spring.impl.FormPortConfiguration;
import net.sf.xmlform.spring.support.DynamicFormPort;
import net.sf.xmlform.spring.web.EnableWebXmlForm;
import net.sf.xmlform.spring.web.impl.FormDataWebProcessor;

/**
 * @author Liu Zhikun
 */
@Configuration
@Import(FormPortConfiguration.class)
public class SpringMvcConfigurerAdapter extends WebMvcConfigurerAdapter implements ImportAware {
	@Autowired(required=false)
	private PastportCreator contextPastportCreator;
	@Autowired(required=true)
	private DynamicFormPort xmlFormPort;
	@Autowired(required = false)
	private List<RestTemplate> restTemplates = Collections.emptyList();
	@Autowired(required = false)
	private List<TypeSupporter> typeSupporters = Collections.emptyList();
	@Autowired(required = false)
	private List<ResultDataPostProcessor> resultDataPostProcessors=Collections.emptyList();;
	
	private int defaultCompact=0;
	private String shorthandFieldsPrefix="!";
	
	@Bean
	public FormDataWebProcessor formDataMethodProcessor(){
		FormDataWebProcessor processor=new FormDataWebProcessor();
		if(contextPastportCreator!=null)
			processor.setContextPastportCreator(contextPastportCreator);
		processor.setFormPort(xmlFormPort);
		processor.setDataCompact(defaultCompact);
		processor.setTypeSupporters(typeSupporters);
		processor.setResultDataPostProcessors(resultDataPostProcessors);
		xmlFormPort.setShorthandFieldsPrefix(shorthandFieldsPrefix);
		return processor;
	}
	
	@Override
	public void addArgumentResolvers(List<HandlerMethodArgumentResolver> argumentResolvers) {
		argumentResolvers.add(0,formDataMethodProcessor());
	}

	@Override
	public void addReturnValueHandlers(List<HandlerMethodReturnValueHandler> returnValueHandlers) {
		returnValueHandlers.add(0,formDataMethodProcessor());
	}

	//@Override
	public void extendHandlerExceptionResolvers(List<HandlerExceptionResolver> exceptionResolvers) {
		exceptionResolvers.add(0,formDataMethodProcessor());
	}

	@Override
	public void extendMessageConverters(List<HttpMessageConverter<?>> converters) {
		converters.add(0,formDataMethodProcessor());
		super.extendMessageConverters(converters);
	}

	@Override
	public void setImportMetadata(AnnotationMetadata meta) {
		Map<String, Object> attrs = meta.getAnnotationAttributes(EnableWebXmlForm.class.getName());
		Integer com=(Integer)attrs.get("compact");
		if(com!=null)
			defaultCompact=com;
		String pre=(String)attrs.get("shorthandFieldsPrefix");
		if(pre!=null){
			shorthandFieldsPrefix=pre;
		}
	}
	
	@Bean
	public SmartInitializingSingleton addConverterToRestTemplateInitializer() {
		return new SmartInitializingSingleton() {
			@Override
			public void afterSingletonsInstantiated() {
				for (RestTemplate restTemplate : SpringMvcConfigurerAdapter.this.restTemplates) {
					restTemplate.getMessageConverters().add(0, formDataMethodProcessor());
				}
			}
		};
	}
}
