package net.sf.xmlform.spring.web.impl;

import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.PrintWriter;
import java.io.UnsupportedEncodingException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

import org.springframework.beans.BeanUtils;
import org.springframework.core.MethodParameter;
import org.springframework.core.Ordered;
import org.springframework.http.HttpInputMessage;
import org.springframework.http.HttpOutputMessage;
import org.springframework.http.MediaType;
import org.springframework.http.converter.HttpMessageConverter;
import org.springframework.http.converter.HttpMessageNotReadableException;
import org.springframework.http.converter.HttpMessageNotWritableException;
import org.springframework.web.bind.support.WebDataBinderFactory;
import org.springframework.web.context.request.NativeWebRequest;
import org.springframework.web.context.request.RequestAttributes;
import org.springframework.web.method.support.HandlerMethodArgumentResolver;
import org.springframework.web.method.support.HandlerMethodReturnValueHandler;
import org.springframework.web.method.support.ModelAndViewContainer;
import org.springframework.web.servlet.HandlerExceptionResolver;
import org.springframework.web.servlet.ModelAndView;

import net.sf.xmlform.XMLFormException;
import net.sf.xmlform.XMLFormPastport;
import net.sf.xmlform.action.ActionException;
import net.sf.xmlform.config.annotation.Form;
import net.sf.xmlform.config.annotation.FormFactory;
import net.sf.xmlform.data.InvalidForm;
import net.sf.xmlform.data.ResultData;
import net.sf.xmlform.data.ResultInfos;
import net.sf.xmlform.data.SourceData;
import net.sf.xmlform.data.SourceInfos;
import net.sf.xmlform.data.SourceType;
import net.sf.xmlform.data.format.DataJSONFormat;
import net.sf.xmlform.data.source.FormlessJSONDataSource;
import net.sf.xmlform.data.source.JSONDataSource;
import net.sf.xmlform.form.XMLForm;
import net.sf.xmlform.format.JSONConstants;
import net.sf.xmlform.spring.annotation.Query;
import net.sf.xmlform.spring.annotation.Result;
import net.sf.xmlform.spring.annotation.Source;
import net.sf.xmlform.spring.config.PastportCreator;
import net.sf.xmlform.spring.config.ResultDataPostProcessor;
import net.sf.xmlform.spring.config.TypeSupporter;
import net.sf.xmlform.spring.impl.DefaultContextPastportCreator;
import net.sf.xmlform.spring.support.DynamicFormPort;
import net.sf.xmlform.spring.support.SourceDataHolder;

/**
 * @author Liu Zhikun
 * 
 * spring mvc 优先级的问题,参数和结果类型不能是Map , 可是 List&lt;Map&gt;
 */

public class FormDataWebProcessor implements Ordered,HandlerMethodArgumentResolver,HandlerMethodReturnValueHandler,HandlerExceptionResolver,HttpMessageConverter {
	private final static String SOURCEDATA_KEY=FormDataWebProcessor.class.getName()+"_sourcedata";
	private final static String RESULTDATA_KEY=FormDataWebProcessor.class.getName()+"_resultdata";
	private final static String XMLFORMS_KEY=FormDataWebProcessor.class.getName()+"_xmlforms";
	private final static String JSON_UTF8= "application/json;charset=UTF-8";
	private final static MediaType MIMETYPE_COMPACT=MediaType.valueOf(JSONConstants.MIME_COMPACT);
	private final static MediaType MIMETYPE_FLAT=MediaType.valueOf(JSONConstants.MIME_FLAT);
	private List<MediaType> supportedMediaTypes = new ArrayList<MediaType>(){{
		add(MediaType.APPLICATION_JSON);
		add(MediaType.valueOf(JSON_UTF8));
		add(MIMETYPE_COMPACT);
		add(MIMETYPE_FLAT);
		//add(MediaType.valueOf(JSONConstants.MIME_QUERY));
	}};
	private int defaultCompact=0;
	private PastportCreator contextPastportCreator=new DefaultContextPastportCreator();
	private DynamicFormPort xmlFormPort;
	private List<TypeSupporter> typeSupporters = Collections.emptyList();
	private List<ResultDataPostProcessor> resultDataPostProcessors=Collections.emptyList();
	
	public PastportCreator getContextPastportCreator() {
		return contextPastportCreator;
	}

	public void setContextPastportCreator(PastportCreator pastportCreator) {
		this.contextPastportCreator = pastportCreator;
	}

	public List<TypeSupporter> getTypeSupporters() {
		return typeSupporters;
	}

	public void setTypeSupporters(List<TypeSupporter> typeSupporters) {
		this.typeSupporters = typeSupporters;
	}

	public List<ResultDataPostProcessor> getResultDataPostProcessors() {
		return resultDataPostProcessors;
	}

	public void setResultDataPostProcessors(List<ResultDataPostProcessor> resultDataPostProcessors) {
		this.resultDataPostProcessors = resultDataPostProcessors;
	}

	public DynamicFormPort getFormPort() {
		return xmlFormPort;
	}

	public void setFormPort(DynamicFormPort xmlformPort) {
		this.xmlFormPort = xmlformPort;
	}
	
	public int getDataCompact() {
		return defaultCompact;
	}

	public void setDataCompact(int defaultCompact) {
		this.defaultCompact = defaultCompact;
	}

	/*
	 * HandlerMethodArgumentResolver
	 */
	@Override
	public boolean supportsParameter(MethodParameter parameter) {
		Class paramType=parameter.getParameterType();
		//参数类型自己用Form注解
		net.sf.xmlform.config.annotation.Form sourceAnno=( net.sf.xmlform.config.annotation.Form)paramType.getAnnotation(net.sf.xmlform.config.annotation.Form.class);
		//参数用Form注解
		net.sf.xmlform.spring.annotation.Form formAnno=( net.sf.xmlform.spring.annotation.Form)parameter.getParameterAnnotation(net.sf.xmlform.spring.annotation.Form.class);
		//参数用Source注解
		Source sourceForm=parameter.getParameterAnnotation(Source.class);
		return paramType.isAssignableFrom(XMLFormPastport.class)
				||(sourceForm!=null)
				||(formAnno!=null&&paramType.isAssignableFrom(XMLForm.class))
				||paramType.isAssignableFrom(SourceInfos.class)
				||paramType.isAssignableFrom(ResultData.class)
				||paramType.isAssignableFrom(ResultInfos.class)
				||sourceAnno!=null
				||isSupport(paramType)
				;
	}

	@Override
	public Object resolveArgument(MethodParameter parameter, ModelAndViewContainer mavContainer,
			NativeWebRequest webRequest, WebDataBinderFactory binderFactory) throws Exception {
		if(xmlFormPort==null)
			throw new IllegalStateException("Must set XMLFormPort");
		XMLFormPastport pastport=contextPastportCreator.createPastport();
		Class paramType=parameter.getParameterType();
		if(paramType.isAssignableFrom(XMLFormPastport.class)){
			return pastport;
		}
		if(paramType.isAssignableFrom(ResultData.class)){
			return getResultData(webRequest);
		}
		if(paramType.isAssignableFrom(ResultInfos.class)){
			return getResultData(webRequest).getResultInfos();
		}
		
		
		SourceData sourceData=parseSourceData(parameter,mavContainer,webRequest,pastport);
		if(paramType.isAssignableFrom(SourceData.class)){
			return sourceData;
		}else if(paramType.isAssignableFrom(List.class)){
			return sourceData.getData();
		}else if(paramType.isAssignableFrom(SourceInfos.class)){
			return sourceData.getSourceInfos();
		}else if(paramType.isAssignableFrom(XMLForm.class)){
			String sourceFormName=null;
			Class sourceClass=null;
			net.sf.xmlform.spring.annotation.Form formAnno=( net.sf.xmlform.spring.annotation.Form)parameter.getParameterAnnotation(net.sf.xmlform.spring.annotation.Form.class);
			if(formAnno.name().length()>0){
				sourceFormName=formAnno.name();
			}
			if(!formAnno.value().equals(Class.class)){
				sourceClass=formAnno.value();
			}
			return getForm(webRequest,pastport, sourceFormName,sourceClass);
		}else{
			List data=sourceData.getData();
			if(data.size()>0)
				return data.get(0);
		}
		return null;
	}
	private SourceData parseSourceData(MethodParameter parameter,ModelAndViewContainer mavContainer,NativeWebRequest webRequest,
			XMLFormPastport pastport)throws Exception{
		SourceData sourceData=(SourceData)webRequest.getAttribute(SOURCEDATA_KEY, RequestAttributes.SCOPE_REQUEST);
		if(sourceData==null){
			Query query=parameter.getParameterAnnotation(Query.class);
			if(query==null){
				query=parameter.getContainingClass().getAnnotation(Query.class);
			}
			SourceType sourceType=SourceType.FORM;
			if(query!=null)
				sourceType=query.value()?SourceType.QUERY:SourceType.FORM;
			
			Class paramType=parameter.getParameterType();	
			int min=1,max=Integer.MAX_VALUE;
			String sourceFormName=null;
			Class sourceClass=null;
			boolean emptyFormName=false;
			
			if(paramType.isAssignableFrom(SourceData.class)){
				;
			}else if(paramType.isAssignableFrom(List.class)){
				;
			}else if(paramType.isAssignableFrom(SourceInfos.class)){
				min=0;
			}else{
				if(!paramType.equals(Class.class)){
					sourceClass=paramType;
				}
			}
			
			Source sourceFormAnno=parameter.getParameterAnnotation(Source.class);
			if(sourceFormAnno!=null){
				min=sourceFormAnno.min();
				max=sourceFormAnno.max();
				if(sourceFormAnno.form().length()>0){
					sourceFormName=sourceFormAnno.form();
				}else {
					emptyFormName=true;
				}
				if(!sourceFormAnno.value().equals(Class.class)){
					sourceClass=sourceFormAnno.value();
				}
			}
			
			if(sourceFormName==null&&sourceClass!=null)
				sourceFormName=FormFactory.parseFormName(sourceClass);
			
			HttpServletRequest req=webRequest.getNativeRequest(HttpServletRequest.class);
			String encoding = req.getCharacterEncoding();
			if (encoding == null)
				encoding = "UTF-8";
			String requestString=readRequestString(encoding,req.getInputStream());
			
			if((emptyFormName&&Map.class.equals(sourceClass))
//					||AnyForm.NAME.equals(sourceFormName)
				) {
				FormlessJSONDataSource dataSource=new FormlessJSONDataSource(requestString);
				sourceData=xmlFormPort.parseData(pastport,null , sourceType, dataSource);
			}else {
				JSONDataSource dataSource=new JSONDataSource(requestString);
				XMLForm xmlform=sourceFormName==null?null:getForm(webRequest,pastport, sourceFormName,sourceClass);
				sourceData=xmlFormPort.parseData(pastport,xmlform , sourceType, dataSource);
			}
			
			int size=sourceData.getData().size();
			if(size<min||size>max){
				throw new XMLFormException(XMLFormException.CE_FORM_DATA,"Form occurs must between "+min+" and "+max+" .");
			}
			
			webRequest.setAttribute(SOURCEDATA_KEY, sourceData,RequestAttributes.SCOPE_REQUEST);
			
		}
		return sourceData;
	}
	/*
	 * HandlerMethodReturnValueHandler
	 */
	@Override
	public boolean supportsReturnType(MethodParameter returnType) {
		Result form=returnType.getMethodAnnotation(Result.class);
		return form!=null
				||returnType.getParameterType().isAssignableFrom(ResultData.class)
				||returnType.getParameterType().isAssignableFrom(ResultInfos.class)
				||isSupport(returnType.getParameterType());
	}

	@Override
	public void handleReturnValue(Object returnValue, MethodParameter returnType, ModelAndViewContainer mavContainer,
			NativeWebRequest webRequest) throws Exception {
		doHandleReturnValue(returnValue,returnType,mavContainer,webRequest);
	}
	private void doHandleReturnValue(Object returnValue, MethodParameter returnType, ModelAndViewContainer mavContainer,
			NativeWebRequest webRequest) throws Exception {
		if(xmlFormPort==null)
			throw new IllegalStateException("Must set XMLFormPort");
		
		SourceData sourceData=(SourceData)webRequest.getAttribute(SOURCEDATA_KEY, RequestAttributes.SCOPE_REQUEST);
		if(sourceData!=null&&sourceData.getSourceInfos().hasError()) {
			throw new XMLFormException(XMLFormException.CE_FORM_DATA,"",sourceData.getSourceInfos().getInvalidForms());
		}
		
		boolean emptyFormName=false;
		Class resultClass=null;
		String resultFormName=null;		
		Result resultFormAnno=returnType.getMethodAnnotation(Result.class);
		if(resultFormAnno!=null){
			if(resultFormAnno.form().length()>0){
				resultFormName=resultFormAnno.form();
			}else {
				emptyFormName=true;
			}
			if(!resultFormAnno.value().equals(Class.class)){
				resultClass=resultFormAnno.value();
			}
		}
		
		ResultData resultData=null;
		if(returnValue==null){
			resultData=getResultData(webRequest);
			resultData.setData(new ArrayList(0));
		}else if(returnValue instanceof ResultInfos){
			resultData=getResultData(webRequest);
			resultData.setResultInfos((ResultInfos)returnValue);
		}else if(returnValue instanceof ResultData){
			resultData=(ResultData)returnValue;
		}else if(returnValue instanceof List){
			resultData=getResultData(webRequest);
			resultData.setData((List)returnValue);
			if(resultClass==null)
				resultClass=getClassFromList(resultData.getData());
		}else if(returnValue instanceof ResultData){
			resultData=(ResultData)returnValue;
			if(resultClass==null)
				resultClass=getClassFromList(resultData.getData());
		}else{
			resultData=getResultData(webRequest);
			List data=new ArrayList(1);
			data.add(returnValue);
			resultData.setData(data);
			if(resultClass==null)
				resultClass=getClassFromList(resultData.getData());
		}
		if(resultFormName==null&&resultClass!=null)
			resultFormName=FormFactory.parseFormName(resultClass);
		
		boolean any=false;
		if((emptyFormName&&Map.class.equals(resultClass))
//				||AnyForm.NAME.equals(resultFormName)
			) {
			any=true;
		}
		
		XMLFormPastport pastport=contextPastportCreator.createPastport();
		if(resultData.getForm()==null&&any==false)
			resultData.setForm(resultFormName==null?null:getForm(webRequest,pastport, resultFormName,resultClass));
		
		for(int i=0;i<resultDataPostProcessors.size();i++){
			ResultData newData=resultDataPostProcessors.get(i).postProcessResultData(pastport, resultData);
			if(newData!=null){
				resultData=newData;
			}
		}
		
		boolean isCompact=true;
		if(resultFormAnno!=null&&resultFormAnno.compact()==0&&defaultCompact==0){
			String accept=webRequest.getHeader("Accept");
			if(accept!=null&&(accept.contains(JSONConstants.MIME_FLAT)))
				isCompact=false;
		}else if(resultFormAnno!=null&&resultFormAnno.compact()!=0){
			isCompact=resultData.getData().size()>=resultFormAnno.compact();
		}else{
			isCompact=resultData.getData().size()>=defaultCompact;
		}
		
		String result=null;
		if(any) {
			result=DataJSONFormat.resultToJson(resultData, isCompact);
		}else {
			DataJSONFormat jsonResult = new DataJSONFormat(resultData,isCompact);
			result=xmlFormPort.formatData(pastport, jsonResult);
		}
		
		HttpServletResponse response=webRequest.getNativeResponse(HttpServletResponse.class);
		response.setContentType(JSON_UTF8);
		PrintWriter writer = response.getWriter();
		writer.write(result);
		writer.flush();
		mavContainer.setRequestHandled(true);
	}
	private Class getClassFromList(List list){
		if(list.size()==0)
			return null;
		return list.get(0).getClass();
	}
	private ResultData getResultData(NativeWebRequest webRequest){
		ResultData resultData=(ResultData)webRequest.getAttribute(RESULTDATA_KEY, RequestAttributes.SCOPE_REQUEST);
		if(resultData==null){
			resultData=new ResultData();
			webRequest.setAttribute(RESULTDATA_KEY, resultData,RequestAttributes.SCOPE_REQUEST);
		}
		return resultData;
	}
	/*
	 * HandlerExceptionResolver
	 */
	@Override
	public ModelAndView resolveException(HttpServletRequest request, HttpServletResponse response,
			Object handler, Exception ex) {
		XMLFormPastport pastport=contextPastportCreator.createPastport();
		XMLFormException exception=null;
		if(ex instanceof XMLFormException){
			exception=(XMLFormException)ex;
		}else if(ex instanceof ActionException){
			ActionException aex=(ActionException)ex;
			SourceData sourceData=(SourceData)request.getAttribute(SOURCEDATA_KEY);
			if(sourceData!=null){
				exception=new XMLFormException(aex.getFaultCode(),aex.getFaultString(),sourceData.getSourceInfos().getInvalidForms());
			}else{
				exception=new XMLFormException(aex.getFaultCode(),aex.getFaultString());
			}
		}
		if(exception==null)
			return null;
		DataJSONFormat jsonResult = new DataJSONFormat(exception);
		String result=xmlFormPort.formatData(pastport, jsonResult);
		ExceptionView view=new ExceptionView(JSON_UTF8,result);
		ModelAndView mv=new ModelAndView();
		mv.setView(view);
		return mv;
	}
	private String readRequestString(String encoding,InputStream in)
			throws UnsupportedEncodingException, IOException {
		InputStreamReader reader = new InputStreamReader(in,encoding);
		int len;
		char buffer[] = new char[1024];
		len = reader.read(buffer);
		StringBuffer sb = new StringBuffer();
		while (len != -1) {
			sb.append(buffer, 0, len);
			len = reader.read(buffer);
		}
		return sb.toString();
	}
	private XMLForm getForm(NativeWebRequest webRequest,XMLFormPastport pastport,String formName,Class cls){
		Map formMap=(Map)webRequest.getAttribute(XMLFORMS_KEY, RequestAttributes.SCOPE_REQUEST);
		if(formMap==null){
			formMap=new HashMap();
			webRequest.setAttribute(XMLFORMS_KEY, formMap,RequestAttributes.SCOPE_REQUEST);				
		}
		XMLForm xmlform=(XMLForm)formMap.get(formName);
		if(xmlform==null){
			xmlform=xmlFormPort.getForm(pastport,formName,cls);
			formMap.put(xmlform.getName(), xmlform);
		}
		return xmlform;
	}
	
	/*
	 * HttpMessageConverter
	 */
	
	@Override
	public boolean canRead(Class cls, MediaType mediaType) {
		Form form=(Form)cls.getAnnotation(Form.class);
		if(form!=null||SourceDataHolder.class.isAssignableFrom(cls)||isSupport(cls)){
			return true;
		}
		return false;
	}

	@Override
	public boolean canWrite(Class cls, MediaType mediaType) {
		Form form=(Form)cls.getAnnotation(Form.class);
		if(form!=null||ResultData.class.isAssignableFrom(cls)
				||cls.equals(XMLFormException.class)
				||cls.equals(ActionException.class)
				||isSupport(cls)){
			return true;
		}
		return false;
	}

	@Override
	public List getSupportedMediaTypes() {
		return supportedMediaTypes;
	}

	@Override
	public Object read(Class cls, HttpInputMessage input) throws IOException, HttpMessageNotReadableException {
		XMLFormPastport pastport=contextPastportCreator.createPastport();
		String formName=FormFactory.parseFormName(cls);
		String requestString=readRequestString("UTF-8",input.getBody());
		JSONDataSource dataSource=new JSONDataSource(requestString);
		SourceType sourceType=SourceType.FORM;
		Query query=(Query)cls.getAnnotation(Query.class);
		if(query!=null){
			sourceType=query.value()?SourceType.QUERY:SourceType.FORM;
		}
		SourceData sourceData=xmlFormPort.parseData(pastport, xmlFormPort.getForm(pastport, formName,cls), sourceType, dataSource);
		if(sourceData.getSourceInfos().hasError()){
			throw new XMLFormException(XMLFormException.CE_FORM_DATA,"",sourceData.getSourceInfos().getInvalidForms());
		}
		if(SourceDataHolder.class.isAssignableFrom(cls)){
			SourceDataHolder holder=(SourceDataHolder)BeanUtils.instantiate(cls);
			holder.setSourceData(sourceData);
			return holder;
		}else{
			SourceInfos infos = sourceData.getSourceInfos();
			InvalidForm[] invalidForms=null;
			Object readResult=null;
			if(sourceData.getData().size()>0){
				readResult=sourceData.getData().get(0);
				if(readResult instanceof InvalidForm||!XMLFormException.OK.equals(infos.getFaultCode())){
					invalidForms=(InvalidForm[])sourceData.getData().toArray(new InvalidForm[sourceData.getData().size()]);
				}
			}
			if(!XMLFormException.OK.equals(infos.getFaultCode())){
				if(invalidForms==null)
					invalidForms=new InvalidForm[0];
				throw new XMLFormException(infos.getFaultCode(),infos.getFaultString(),invalidForms);
			}
			return readResult;
		}
	}

	@Override
	public void write(Object obj, MediaType mediaType, HttpOutputMessage output) throws IOException, HttpMessageNotWritableException {
		XMLFormPastport pastport=contextPastportCreator.createPastport();
		DataJSONFormat jsonResult=null;
		if(obj instanceof XMLFormException){
			jsonResult=new DataJSONFormat((XMLFormException)obj);
		}else if(obj instanceof ActionException){
			ActionException aex=(ActionException)obj;
			jsonResult=new DataJSONFormat(new XMLFormException(aex.getFaultCode(),aex.getFaultString()));
		}else{
			ResultData resultData=null;
			if(obj==null){
				resultData=new ResultData();
				resultData.setData(new ArrayList(0));
			}else if(obj instanceof ResultData){
				resultData=(ResultData)obj;
				List dataList=resultData.getData();
				int dataSize=dataList.size();
				if(dataSize>0){
					obj=dataList.get(0);
					if(resultData.getResultInfos().getTotalResults()==0){
						resultData.getResultInfos().setTotalResults(dataSize);
					}
				}else{
					obj=null;
				}
			}else{
				resultData=new ResultData();
				resultData.getResultInfos().setTotalResults(1);
				List data=new ArrayList(1);
				data.add(obj);
				resultData.setData(data);
			}
			
			if(resultData.getForm()==null&&obj!=null){
				String formName=FormFactory.parseFormName(obj.getClass());
				resultData.setForm(xmlFormPort.getForm(pastport, formName,obj.getClass()));
			}
			
			boolean isCompact=resultData.getData().size()>=defaultCompact;
			if(mediaType.compareTo(MIMETYPE_COMPACT)==0){
				isCompact=true;
			}else if(mediaType.compareTo(MIMETYPE_FLAT)==0){
				isCompact=false;
			}
			jsonResult = new DataJSONFormat(resultData,isCompact);
		}
		
		String result=xmlFormPort.formatData(pastport, jsonResult);
		output.getHeaders().setContentType(mediaType);
		output.getBody().write(result.getBytes());
	}
	private boolean isSupport(Class cls){
		for(int i=0;i<typeSupporters.size();i++){
			if(typeSupporters.get(i).isSupport(cls))
				return true;
		}
		return false;
	}

	@Override
	public int getOrder() {
		return Ordered.HIGHEST_PRECEDENCE;
	}
}
