/*
 * Decompiled with CFR 0.152.
 */
package net.sf.xmlform.spring.web.impl;

import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.PrintWriter;
import java.io.UnsupportedEncodingException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import net.sf.xmlform.XMLFormException;
import net.sf.xmlform.XMLFormPastport;
import net.sf.xmlform.action.ActionException;
import net.sf.xmlform.config.annotation.Form;
import net.sf.xmlform.config.annotation.FormFactory;
import net.sf.xmlform.data.InvalidForm;
import net.sf.xmlform.data.ResultData;
import net.sf.xmlform.data.ResultInfos;
import net.sf.xmlform.data.SourceData;
import net.sf.xmlform.data.SourceInfos;
import net.sf.xmlform.data.SourceType;
import net.sf.xmlform.data.format.DataJSONFormat;
import net.sf.xmlform.data.source.FormlessJSONDataSource;
import net.sf.xmlform.data.source.JSONDataSource;
import net.sf.xmlform.form.XMLForm;
import net.sf.xmlform.spring.annotation.Query;
import net.sf.xmlform.spring.annotation.Result;
import net.sf.xmlform.spring.annotation.Source;
import net.sf.xmlform.spring.config.PastportCreator;
import net.sf.xmlform.spring.config.ResultDataPostProcessor;
import net.sf.xmlform.spring.config.TypeSupporter;
import net.sf.xmlform.spring.impl.DefaultContextPastportCreator;
import net.sf.xmlform.spring.support.DynamicFormPort;
import net.sf.xmlform.spring.support.SourceDataHolder;
import net.sf.xmlform.spring.web.impl.ExceptionView;
import org.springframework.beans.BeanUtils;
import org.springframework.core.MethodParameter;
import org.springframework.core.Ordered;
import org.springframework.http.HttpInputMessage;
import org.springframework.http.HttpOutputMessage;
import org.springframework.http.MediaType;
import org.springframework.http.converter.HttpMessageConverter;
import org.springframework.http.converter.HttpMessageNotReadableException;
import org.springframework.http.converter.HttpMessageNotWritableException;
import org.springframework.util.MimeType;
import org.springframework.web.bind.support.WebDataBinderFactory;
import org.springframework.web.context.request.NativeWebRequest;
import org.springframework.web.method.support.HandlerMethodArgumentResolver;
import org.springframework.web.method.support.HandlerMethodReturnValueHandler;
import org.springframework.web.method.support.ModelAndViewContainer;
import org.springframework.web.servlet.HandlerExceptionResolver;
import org.springframework.web.servlet.ModelAndView;
import org.springframework.web.servlet.View;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class FormDataWebProcessor
implements Ordered,
HandlerMethodArgumentResolver,
HandlerMethodReturnValueHandler,
HandlerExceptionResolver,
HttpMessageConverter {
    private static final String SOURCEDATA_KEY = FormDataWebProcessor.class.getName() + "_sourcedata";
    private static final String RESULTDATA_KEY = FormDataWebProcessor.class.getName() + "_resultdata";
    private static final String XMLFORMS_KEY = FormDataWebProcessor.class.getName() + "_xmlforms";
    private static final String JSON_UTF8 = "application/json;charset=UTF-8";
    private static final MediaType MIMETYPE_COMPACT = MediaType.valueOf((String)"application/xmlform-compact+json");
    private static final MediaType MIMETYPE_FLAT = MediaType.valueOf((String)"application/xmlform-flat+json");
    private List<MediaType> supportedMediaTypes = new ArrayList<MediaType>(){
        {
            this.add(MediaType.APPLICATION_JSON);
            this.add(MediaType.valueOf((String)FormDataWebProcessor.JSON_UTF8));
            this.add(MIMETYPE_COMPACT);
            this.add(MIMETYPE_FLAT);
        }
    };
    private int defaultCompact = 0;
    private PastportCreator contextPastportCreator = new DefaultContextPastportCreator();
    private DynamicFormPort xmlFormPort;
    private List<TypeSupporter> typeSupporters = Collections.emptyList();
    private List<ResultDataPostProcessor> resultDataPostProcessors = Collections.emptyList();

    public PastportCreator getContextPastportCreator() {
        return this.contextPastportCreator;
    }

    public void setContextPastportCreator(PastportCreator pastportCreator) {
        this.contextPastportCreator = pastportCreator;
    }

    public List<TypeSupporter> getTypeSupporters() {
        return this.typeSupporters;
    }

    public void setTypeSupporters(List<TypeSupporter> typeSupporters) {
        this.typeSupporters = typeSupporters;
    }

    public List<ResultDataPostProcessor> getResultDataPostProcessors() {
        return this.resultDataPostProcessors;
    }

    public void setResultDataPostProcessors(List<ResultDataPostProcessor> resultDataPostProcessors) {
        this.resultDataPostProcessors = resultDataPostProcessors;
    }

    public DynamicFormPort getFormPort() {
        return this.xmlFormPort;
    }

    public void setFormPort(DynamicFormPort xmlformPort) {
        this.xmlFormPort = xmlformPort;
    }

    public int getDataCompact() {
        return this.defaultCompact;
    }

    public void setDataCompact(int defaultCompact) {
        this.defaultCompact = defaultCompact;
    }

    public boolean supportsParameter(MethodParameter parameter) {
        Class paramType = parameter.getParameterType();
        Form sourceAnno = paramType.getAnnotation(Form.class);
        net.sf.xmlform.spring.annotation.Form formAnno = (net.sf.xmlform.spring.annotation.Form)parameter.getParameterAnnotation(net.sf.xmlform.spring.annotation.Form.class);
        Source sourceForm = (Source)parameter.getParameterAnnotation(Source.class);
        return paramType.isAssignableFrom(XMLFormPastport.class) || sourceForm != null || formAnno != null && paramType.isAssignableFrom(XMLForm.class) || paramType.isAssignableFrom(SourceInfos.class) || paramType.isAssignableFrom(ResultData.class) || paramType.isAssignableFrom(ResultInfos.class) || sourceAnno != null || this.isSupport(paramType);
    }

    public Object resolveArgument(MethodParameter parameter, ModelAndViewContainer mavContainer, NativeWebRequest webRequest, WebDataBinderFactory binderFactory) throws Exception {
        if (this.xmlFormPort == null) {
            throw new IllegalStateException("Must set XMLFormPort");
        }
        XMLFormPastport pastport = this.contextPastportCreator.createPastport();
        Class paramType = parameter.getParameterType();
        if (paramType.isAssignableFrom(XMLFormPastport.class)) {
            return pastport;
        }
        if (paramType.isAssignableFrom(ResultData.class)) {
            return this.getResultData(webRequest);
        }
        if (paramType.isAssignableFrom(ResultInfos.class)) {
            return this.getResultData(webRequest).getResultInfos();
        }
        SourceData sourceData = this.parseSourceData(parameter, mavContainer, webRequest, pastport);
        if (paramType.isAssignableFrom(SourceData.class)) {
            return sourceData;
        }
        if (paramType.isAssignableFrom(List.class)) {
            return sourceData.getData();
        }
        if (paramType.isAssignableFrom(SourceInfos.class)) {
            return sourceData.getSourceInfos();
        }
        if (paramType.isAssignableFrom(XMLForm.class)) {
            String sourceFormName = null;
            Class sourceClass = null;
            net.sf.xmlform.spring.annotation.Form formAnno = (net.sf.xmlform.spring.annotation.Form)parameter.getParameterAnnotation(net.sf.xmlform.spring.annotation.Form.class);
            if (formAnno.name().length() > 0) {
                sourceFormName = formAnno.name();
            }
            if (!formAnno.value().equals(Class.class)) {
                sourceClass = formAnno.value();
            }
            return this.getForm(webRequest, pastport, sourceFormName, sourceClass);
        }
        List data = sourceData.getData();
        if (data.size() > 0) {
            return data.get(0);
        }
        return null;
    }

    private SourceData parseSourceData(MethodParameter parameter, ModelAndViewContainer mavContainer, NativeWebRequest webRequest, XMLFormPastport pastport) throws Exception {
        SourceData sourceData = (SourceData)webRequest.getAttribute(SOURCEDATA_KEY, 0);
        if (sourceData == null) {
            JSONDataSource dataSource;
            HttpServletRequest req;
            String encoding;
            Source sourceFormAnno;
            Query query = (Query)parameter.getParameterAnnotation(Query.class);
            if (query == null) {
                query = parameter.getContainingClass().getAnnotation(Query.class);
            }
            SourceType sourceType = SourceType.FORM;
            if (query != null) {
                sourceType = query.value() ? SourceType.QUERY : SourceType.FORM;
            }
            Class paramType = parameter.getParameterType();
            int min = 1;
            int max = Integer.MAX_VALUE;
            String sourceFormName = null;
            Class sourceClass = null;
            boolean emptyFormName = false;
            if (!paramType.isAssignableFrom(SourceData.class) && !paramType.isAssignableFrom(List.class)) {
                if (paramType.isAssignableFrom(SourceInfos.class)) {
                    min = 0;
                } else if (!paramType.equals(Class.class)) {
                    sourceClass = paramType;
                }
            }
            if ((sourceFormAnno = (Source)parameter.getParameterAnnotation(Source.class)) != null) {
                min = sourceFormAnno.min();
                max = sourceFormAnno.max();
                if (sourceFormAnno.form().length() > 0) {
                    sourceFormName = sourceFormAnno.form();
                } else {
                    emptyFormName = true;
                }
                if (!sourceFormAnno.value().equals(Class.class)) {
                    sourceClass = sourceFormAnno.value();
                }
            }
            if (sourceFormName == null && sourceClass != null) {
                sourceFormName = FormFactory.parseFormName(sourceClass);
            }
            if ((encoding = (req = (HttpServletRequest)webRequest.getNativeRequest(HttpServletRequest.class)).getCharacterEncoding()) == null) {
                encoding = "UTF-8";
            }
            String requestString = this.readRequestString(encoding, (InputStream)req.getInputStream());
            if (emptyFormName && Map.class.equals((Object)sourceClass)) {
                dataSource = new FormlessJSONDataSource(requestString);
                sourceData = (SourceData)this.xmlFormPort.parseData(pastport, (XMLForm)null, sourceType, dataSource);
            } else {
                dataSource = new JSONDataSource(requestString);
                XMLForm xmlform = sourceFormName == null ? null : this.getForm(webRequest, pastport, sourceFormName, sourceClass);
                sourceData = (SourceData)this.xmlFormPort.parseData(pastport, xmlform, sourceType, dataSource);
            }
            int size = sourceData.getData().size();
            if (size < min || size > max) {
                throw new XMLFormException("c.form.data", "Form occurs must between " + min + " and " + max + " .");
            }
            webRequest.setAttribute(SOURCEDATA_KEY, (Object)sourceData, 0);
        }
        return sourceData;
    }

    public boolean supportsReturnType(MethodParameter returnType) {
        Result form = (Result)returnType.getMethodAnnotation(Result.class);
        return form != null || returnType.getParameterType().isAssignableFrom(ResultData.class) || returnType.getParameterType().isAssignableFrom(ResultInfos.class) || this.isSupport(returnType.getParameterType());
    }

    public void handleReturnValue(Object returnValue, MethodParameter returnType, ModelAndViewContainer mavContainer, NativeWebRequest webRequest) throws Exception {
        this.doHandleReturnValue(returnValue, returnType, mavContainer, webRequest);
    }

    private void doHandleReturnValue(Object returnValue, MethodParameter returnType, ModelAndViewContainer mavContainer, NativeWebRequest webRequest) throws Exception {
        if (this.xmlFormPort == null) {
            throw new IllegalStateException("Must set XMLFormPort");
        }
        SourceData sourceData = (SourceData)webRequest.getAttribute(SOURCEDATA_KEY, 0);
        if (sourceData != null && sourceData.getSourceInfos().hasError()) {
            throw new XMLFormException("c.form.data", "", sourceData.getSourceInfos().getInvalidForms());
        }
        boolean emptyFormName = false;
        Class resultClass = null;
        String resultFormName = null;
        Result resultFormAnno = (Result)returnType.getMethodAnnotation(Result.class);
        if (resultFormAnno != null) {
            if (resultFormAnno.form().length() > 0) {
                resultFormName = resultFormAnno.form();
            } else {
                emptyFormName = true;
            }
            if (!resultFormAnno.value().equals(Class.class)) {
                resultClass = resultFormAnno.value();
            }
        }
        ResultData resultData = null;
        if (returnValue == null) {
            resultData = this.getResultData(webRequest);
            resultData.setData(new ArrayList(0));
        } else if (returnValue instanceof ResultInfos) {
            resultData = this.getResultData(webRequest);
            resultData.setResultInfos((ResultInfos)returnValue);
        } else if (returnValue instanceof ResultData) {
            resultData = (ResultData)returnValue;
        } else if (returnValue instanceof List) {
            resultData = this.getResultData(webRequest);
            resultData.setData((List)returnValue);
            if (resultClass == null) {
                resultClass = this.getClassFromList(resultData.getData());
            }
        } else if (returnValue instanceof ResultData) {
            resultData = (ResultData)returnValue;
            if (resultClass == null) {
                resultClass = this.getClassFromList(resultData.getData());
            }
        } else {
            resultData = this.getResultData(webRequest);
            ArrayList<Object> data = new ArrayList<Object>(1);
            data.add(returnValue);
            resultData.setData(data);
            if (resultClass == null) {
                resultClass = this.getClassFromList(resultData.getData());
            }
        }
        if (resultFormName == null && resultClass != null) {
            resultFormName = FormFactory.parseFormName((Class)resultClass);
        }
        boolean any = false;
        if (emptyFormName && Map.class.equals((Object)resultClass)) {
            any = true;
        }
        XMLFormPastport pastport = this.contextPastportCreator.createPastport();
        if (resultData.getForm() == null && !any) {
            resultData.setForm(resultFormName == null ? null : this.getForm(webRequest, pastport, resultFormName, resultClass));
        }
        for (int i = 0; i < this.resultDataPostProcessors.size(); ++i) {
            ResultData newData = this.resultDataPostProcessors.get(i).postProcessResultData(pastport, resultData);
            if (newData == null) continue;
            resultData = newData;
        }
        boolean isCompact = true;
        if (resultFormAnno != null && resultFormAnno.compact() == 0 && this.defaultCompact == 0) {
            String accept = webRequest.getHeader("Accept");
            if (accept != null && accept.contains("application/xmlform-flat+json")) {
                isCompact = false;
            }
        } else {
            isCompact = resultFormAnno != null && resultFormAnno.compact() != 0 ? resultData.getData().size() >= resultFormAnno.compact() : resultData.getData().size() >= this.defaultCompact;
        }
        String result = null;
        if (any) {
            result = DataJSONFormat.resultToJson((ResultData)resultData, (boolean)isCompact);
        } else {
            DataJSONFormat jsonResult = new DataJSONFormat(resultData, isCompact);
            result = (String)this.xmlFormPort.formatData(pastport, jsonResult);
        }
        HttpServletResponse response = (HttpServletResponse)webRequest.getNativeResponse(HttpServletResponse.class);
        response.setContentType(JSON_UTF8);
        PrintWriter writer = response.getWriter();
        writer.write(result);
        writer.flush();
        mavContainer.setRequestHandled(true);
    }

    private Class getClassFromList(List list) {
        if (list.size() == 0) {
            return null;
        }
        return list.get(0).getClass();
    }

    private ResultData getResultData(NativeWebRequest webRequest) {
        ResultData resultData = (ResultData)webRequest.getAttribute(RESULTDATA_KEY, 0);
        if (resultData == null) {
            resultData = new ResultData();
            webRequest.setAttribute(RESULTDATA_KEY, (Object)resultData, 0);
        }
        return resultData;
    }

    public ModelAndView resolveException(HttpServletRequest request, HttpServletResponse response, Object handler, Exception ex) {
        XMLFormPastport pastport = this.contextPastportCreator.createPastport();
        XMLFormException exception = null;
        if (ex instanceof XMLFormException) {
            exception = (XMLFormException)ex;
        } else if (ex instanceof ActionException) {
            ActionException aex = (ActionException)ex;
            SourceData sourceData = (SourceData)request.getAttribute(SOURCEDATA_KEY);
            exception = sourceData != null ? new XMLFormException(aex.getFaultCode(), aex.getFaultString(), sourceData.getSourceInfos().getInvalidForms()) : new XMLFormException(aex.getFaultCode(), aex.getFaultString());
        }
        if (exception == null) {
            return null;
        }
        DataJSONFormat jsonResult = new DataJSONFormat(exception);
        String result = (String)this.xmlFormPort.formatData(pastport, jsonResult);
        ExceptionView view = new ExceptionView(JSON_UTF8, result);
        ModelAndView mv = new ModelAndView();
        mv.setView((View)view);
        return mv;
    }

    private String readRequestString(String encoding, InputStream in) throws UnsupportedEncodingException, IOException {
        InputStreamReader reader = new InputStreamReader(in, encoding);
        char[] buffer = new char[1024];
        int len = reader.read(buffer);
        StringBuffer sb = new StringBuffer();
        while (len != -1) {
            sb.append(buffer, 0, len);
            len = reader.read(buffer);
        }
        return sb.toString();
    }

    private XMLForm getForm(NativeWebRequest webRequest, XMLFormPastport pastport, String formName, Class cls) {
        XMLForm xmlform;
        HashMap<String, XMLForm> formMap = (HashMap<String, XMLForm>)webRequest.getAttribute(XMLFORMS_KEY, 0);
        if (formMap == null) {
            formMap = new HashMap<String, XMLForm>();
            webRequest.setAttribute(XMLFORMS_KEY, formMap, 0);
        }
        if ((xmlform = (XMLForm)formMap.get(formName)) == null) {
            xmlform = this.xmlFormPort.getForm(pastport, formName, cls);
            formMap.put(xmlform.getName(), xmlform);
        }
        return xmlform;
    }

    public boolean canRead(Class cls, MediaType mediaType) {
        Form form = cls.getAnnotation(Form.class);
        return form != null || SourceDataHolder.class.isAssignableFrom(cls) || this.isSupport(cls);
    }

    public boolean canWrite(Class cls, MediaType mediaType) {
        Form form = cls.getAnnotation(Form.class);
        return form != null || ResultData.class.isAssignableFrom(cls) || cls.equals(XMLFormException.class) || cls.equals(ActionException.class) || this.isSupport(cls);
    }

    public List getSupportedMediaTypes() {
        return this.supportedMediaTypes;
    }

    public Object read(Class cls, HttpInputMessage input) throws IOException, HttpMessageNotReadableException {
        SourceData sourceData;
        XMLFormPastport pastport = this.contextPastportCreator.createPastport();
        String formName = FormFactory.parseFormName((Class)cls);
        String requestString = this.readRequestString("UTF-8", input.getBody());
        JSONDataSource dataSource = new JSONDataSource(requestString);
        SourceType sourceType = SourceType.FORM;
        Query query = cls.getAnnotation(Query.class);
        if (query != null) {
            SourceType sourceType2 = sourceType = query.value() ? SourceType.QUERY : SourceType.FORM;
        }
        if ((sourceData = (SourceData)this.xmlFormPort.parseData(pastport, this.xmlFormPort.getForm(pastport, formName, cls), sourceType, dataSource)).getSourceInfos().hasError()) {
            throw new XMLFormException("c.form.data", "", sourceData.getSourceInfos().getInvalidForms());
        }
        if (SourceDataHolder.class.isAssignableFrom(cls)) {
            SourceDataHolder holder = (SourceDataHolder)BeanUtils.instantiate((Class)cls);
            holder.setSourceData(sourceData);
            return holder;
        }
        SourceInfos infos = sourceData.getSourceInfos();
        InvalidForm[] invalidForms = null;
        Object readResult = null;
        if (sourceData.getData().size() > 0 && ((readResult = sourceData.getData().get(0)) instanceof InvalidForm || !"ok".equals(infos.getFaultCode()))) {
            invalidForms = sourceData.getData().toArray(new InvalidForm[sourceData.getData().size()]);
        }
        if (!"ok".equals(infos.getFaultCode())) {
            if (invalidForms == null) {
                invalidForms = new InvalidForm[]{};
            }
            throw new XMLFormException(infos.getFaultCode(), infos.getFaultString(), invalidForms);
        }
        return readResult;
    }

    public void write(Object obj, MediaType mediaType, HttpOutputMessage output) throws IOException, HttpMessageNotWritableException {
        XMLFormPastport pastport = this.contextPastportCreator.createPastport();
        DataJSONFormat jsonResult = null;
        if (obj instanceof XMLFormException) {
            jsonResult = new DataJSONFormat((XMLFormException)obj);
        } else if (obj instanceof ActionException) {
            ActionException aex = (ActionException)obj;
            jsonResult = new DataJSONFormat(new XMLFormException(aex.getFaultCode(), aex.getFaultString()));
        } else {
            boolean isCompact;
            ResultData resultData = null;
            if (obj == null) {
                resultData = new ResultData();
                resultData.setData(new ArrayList(0));
            } else if (obj instanceof ResultData) {
                resultData = (ResultData)obj;
                List dataList = resultData.getData();
                int dataSize = dataList.size();
                if (dataSize > 0) {
                    obj = dataList.get(0);
                    if (resultData.getResultInfos().getTotalResults() == 0L) {
                        resultData.getResultInfos().setTotalResults((long)dataSize);
                    }
                } else {
                    obj = null;
                }
            } else {
                resultData = new ResultData();
                resultData.getResultInfos().setTotalResults(1L);
                ArrayList<Object> data = new ArrayList<Object>(1);
                data.add(obj);
                resultData.setData(data);
            }
            if (resultData.getForm() == null && obj != null) {
                String formName = FormFactory.parseFormName(obj.getClass());
                resultData.setForm(this.xmlFormPort.getForm(pastport, formName, obj.getClass()));
            }
            boolean bl = isCompact = resultData.getData().size() >= this.defaultCompact;
            if (mediaType.compareTo((MimeType)MIMETYPE_COMPACT) == 0) {
                isCompact = true;
            } else if (mediaType.compareTo((MimeType)MIMETYPE_FLAT) == 0) {
                isCompact = false;
            }
            jsonResult = new DataJSONFormat(resultData, isCompact);
        }
        String result = (String)this.xmlFormPort.formatData(pastport, jsonResult);
        output.getHeaders().setContentType(mediaType);
        output.getBody().write(result.getBytes());
    }

    private boolean isSupport(Class cls) {
        for (int i = 0; i < this.typeSupporters.size(); ++i) {
            if (!this.typeSupporters.get(i).isSupport(cls)) continue;
            return true;
        }
        return false;
    }

    public int getOrder() {
        return Integer.MIN_VALUE;
    }
}

