/*
 * Decompiled with CFR 0.152.
 */
package net.sf.xmlform.spring.web.config;

import java.util.Collections;
import java.util.List;
import java.util.Map;
import net.sf.xmlform.spring.config.PastportCreator;
import net.sf.xmlform.spring.config.ResultDataPostProcessor;
import net.sf.xmlform.spring.config.TypeSupporter;
import net.sf.xmlform.spring.impl.FormPortConfiguration;
import net.sf.xmlform.spring.support.DynamicFormPort;
import net.sf.xmlform.spring.web.EnableWebXmlForm;
import net.sf.xmlform.spring.web.impl.FormDataWebProcessor;
import org.springframework.beans.BeansException;
import org.springframework.beans.factory.SmartInitializingSingleton;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.ApplicationContext;
import org.springframework.context.ApplicationContextAware;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.context.annotation.Import;
import org.springframework.context.annotation.ImportAware;
import org.springframework.core.type.AnnotationMetadata;
import org.springframework.http.converter.HttpMessageConverter;
import org.springframework.web.accept.ContentNegotiationManager;
import org.springframework.web.client.RestTemplate;
import org.springframework.web.method.support.HandlerMethodArgumentResolver;
import org.springframework.web.method.support.HandlerMethodReturnValueHandler;
import org.springframework.web.servlet.HandlerExceptionResolver;
import org.springframework.web.servlet.config.annotation.WebMvcConfigurerAdapter;

@Configuration
@Import(value={FormPortConfiguration.class})
public class SpringMvcConfigurerAdapter
extends WebMvcConfigurerAdapter
implements ImportAware,
ApplicationContextAware {
    @Autowired(required=false)
    private PastportCreator contextPastportCreator;
    @Autowired(required=true)
    private DynamicFormPort xmlFormPort;
    @Autowired(required=false)
    private List<RestTemplate> restTemplates = Collections.emptyList();
    @Autowired(required=false)
    private List<TypeSupporter> typeSupporters = Collections.emptyList();
    @Autowired(required=false)
    private List<ResultDataPostProcessor> resultDataPostProcessors = Collections.emptyList();
    private ApplicationContext applicationContext;
    private int defaultCompact = -1;
    private String shorthandFieldsPrefix = "!";
    private String defaultVersion = "2.0";

    @Bean
    public FormDataWebProcessor formDataMethodProcessor() {
        FormDataWebProcessor processor = new FormDataWebProcessor();
        if (this.contextPastportCreator != null) {
            processor.setContextPastportCreator(this.contextPastportCreator);
        }
        processor.setFormPort(this.xmlFormPort);
        processor.setDataCompact(this.defaultCompact);
        processor.setDefaultVersion(this.defaultVersion);
        processor.setTypeSupporters(this.typeSupporters);
        processor.setResultDataPostProcessors(this.resultDataPostProcessors);
        this.xmlFormPort.setShorthandFieldsPrefix(this.shorthandFieldsPrefix);
        return processor;
    }

    public void addArgumentResolvers(List<HandlerMethodArgumentResolver> argumentResolvers) {
        argumentResolvers.add(0, this.formDataMethodProcessor());
    }

    public void addReturnValueHandlers(List<HandlerMethodReturnValueHandler> returnValueHandlers) {
        returnValueHandlers.add(0, this.formDataMethodProcessor());
    }

    public void extendHandlerExceptionResolvers(List<HandlerExceptionResolver> exceptionResolvers) {
        exceptionResolvers.add(0, this.formDataMethodProcessor());
    }

    public void extendMessageConverters(List<HttpMessageConverter<?>> converters) {
        converters.add(0, this.formDataMethodProcessor());
    }

    public void setImportMetadata(AnnotationMetadata meta) {
        String pre;
        Map attrs = meta.getAnnotationAttributes(EnableWebXmlForm.class.getName());
        this.defaultVersion = (String)attrs.get("version");
        Integer com = (Integer)attrs.get("compact");
        if (com != null) {
            this.defaultCompact = com;
        }
        if ((pre = (String)attrs.get("shorthandFieldsPrefix")) != null) {
            this.shorthandFieldsPrefix = pre;
        }
    }

    @Bean
    public SmartInitializingSingleton addConverterToRestTemplateInitializer() {
        return new SmartInitializingSingleton(){

            public void afterSingletonsInstantiated() {
                ContentNegotiationManager manager = (ContentNegotiationManager)SpringMvcConfigurerAdapter.this.applicationContext.getBean(ContentNegotiationManager.class);
                SpringMvcConfigurerAdapter.this.formDataMethodProcessor().setContentNegotiationManager(manager);
                for (RestTemplate restTemplate : SpringMvcConfigurerAdapter.this.restTemplates) {
                    restTemplate.getMessageConverters().add(0, SpringMvcConfigurerAdapter.this.formDataMethodProcessor());
                }
            }
        };
    }

    public void setApplicationContext(ApplicationContext ac) throws BeansException {
        this.applicationContext = ac;
    }
}

