/*
 * Decompiled with CFR 0.152.
 */
package net.sf.xmlform.spring.web.impl;

import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.PrintWriter;
import java.io.UnsupportedEncodingException;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import net.sf.xmlform.XMLFormException;
import net.sf.xmlform.XMLFormPastport;
import net.sf.xmlform.action.ActionException;
import net.sf.xmlform.config.annotation.Form;
import net.sf.xmlform.config.annotation.FormFactory;
import net.sf.xmlform.data.InvalidForm;
import net.sf.xmlform.data.ResultData;
import net.sf.xmlform.data.ResultInfos;
import net.sf.xmlform.data.SourceData;
import net.sf.xmlform.data.SourceInfos;
import net.sf.xmlform.data.SourceType;
import net.sf.xmlform.data.format.DataJSONFormat;
import net.sf.xmlform.data.format.DataXMLFormat;
import net.sf.xmlform.data.source.FormlessJSONDataSource;
import net.sf.xmlform.data.source.FormlessXMLDataSource;
import net.sf.xmlform.data.source.JSONDataSource;
import net.sf.xmlform.data.source.XMLDataSource;
import net.sf.xmlform.form.XMLForm;
import net.sf.xmlform.spring.annotation.Query;
import net.sf.xmlform.spring.annotation.Result;
import net.sf.xmlform.spring.annotation.Source;
import net.sf.xmlform.spring.config.PastportCreator;
import net.sf.xmlform.spring.config.ResultDataPostProcessor;
import net.sf.xmlform.spring.config.TypeSupporter;
import net.sf.xmlform.spring.impl.DefaultContextPastportCreator;
import net.sf.xmlform.spring.support.DynamicFormPort;
import net.sf.xmlform.spring.web.impl.ExceptionView;
import net.sf.xmlform.util.FormUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.context.i18n.LocaleContextHolder;
import org.springframework.core.MethodParameter;
import org.springframework.core.Ordered;
import org.springframework.http.HttpInputMessage;
import org.springframework.http.HttpOutputMessage;
import org.springframework.http.MediaType;
import org.springframework.http.converter.HttpMessageConverter;
import org.springframework.http.converter.HttpMessageNotReadableException;
import org.springframework.http.converter.HttpMessageNotWritableException;
import org.springframework.web.HttpMediaTypeNotAcceptableException;
import org.springframework.web.accept.ContentNegotiationManager;
import org.springframework.web.accept.HeaderContentNegotiationStrategy;
import org.springframework.web.bind.support.WebDataBinderFactory;
import org.springframework.web.context.request.NativeWebRequest;
import org.springframework.web.context.request.ServletWebRequest;
import org.springframework.web.method.support.HandlerMethodArgumentResolver;
import org.springframework.web.method.support.HandlerMethodReturnValueHandler;
import org.springframework.web.method.support.ModelAndViewContainer;
import org.springframework.web.servlet.HandlerExceptionResolver;
import org.springframework.web.servlet.ModelAndView;
import org.springframework.web.servlet.View;

public class FormDataWebProcessor
implements Ordered,
HandlerMethodArgumentResolver,
HandlerMethodReturnValueHandler,
HandlerExceptionResolver,
HttpMessageConverter {
    private static final String SOURCEDATA_KEY = FormDataWebProcessor.class.getName() + "_sourcedata";
    private static final String RESULTDATA_KEY = FormDataWebProcessor.class.getName() + "_resultdata";
    private static final String XMLFORMS_KEY = FormDataWebProcessor.class.getName() + "_xmlforms";
    private static final String SOURCEFORM_KEY = FormDataWebProcessor.class.getName() + "_sourceform";
    private static final String JSON_UTF8 = "application/json;charset=UTF-8";
    private static final String GET_KEY_VERSION = "_xfversion";
    private static final String GET_KEY_FORMAT = "_xfformat";
    private static final String GET_KEY_BODYTYPE = "_xfbodytype";
    private static Logger logger = LoggerFactory.getLogger(FormFactory.class);
    private List<MediaType> supportedMediaTypes = new ArrayList<MediaType>(){
        {
            this.add(MediaType.APPLICATION_JSON);
            this.add(MediaType.valueOf((String)FormDataWebProcessor.JSON_UTF8));
        }
    };
    private int defaultCompact = -1;
    private String defaultVersion = "2.0";
    private PastportCreator contextPastportCreator = new DefaultContextPastportCreator();
    private DynamicFormPort xmlFormPort;
    private List<TypeSupporter> typeSupporters = Collections.emptyList();
    private List<ResultDataPostProcessor> resultDataPostProcessors = Collections.emptyList();
    private ContentNegotiationManager contentNegotiationManager;
    private HeaderContentNegotiationStrategy headerContentNegotiationStrategy = new HeaderContentNegotiationStrategy();

    public ContentNegotiationManager getContentNegotiationManager() {
        return this.contentNegotiationManager;
    }

    public void setContentNegotiationManager(ContentNegotiationManager contentNegotiationManager) {
        this.contentNegotiationManager = contentNegotiationManager;
    }

    public PastportCreator getContextPastportCreator() {
        return this.contextPastportCreator;
    }

    public void setContextPastportCreator(PastportCreator pastportCreator) {
        this.contextPastportCreator = pastportCreator;
    }

    public List<TypeSupporter> getTypeSupporters() {
        return this.typeSupporters;
    }

    public void setTypeSupporters(List<TypeSupporter> typeSupporters) {
        this.typeSupporters = typeSupporters;
    }

    public List<ResultDataPostProcessor> getResultDataPostProcessors() {
        return this.resultDataPostProcessors;
    }

    public void setResultDataPostProcessors(List<ResultDataPostProcessor> resultDataPostProcessors) {
        this.resultDataPostProcessors = resultDataPostProcessors;
    }

    public DynamicFormPort getFormPort() {
        return this.xmlFormPort;
    }

    public void setFormPort(DynamicFormPort xmlformPort) {
        this.xmlFormPort = xmlformPort;
    }

    public int getDataCompact() {
        return this.defaultCompact;
    }

    public void setDataCompact(int defaultCompact) {
        this.defaultCompact = defaultCompact;
    }

    public String getDefaultVersion() {
        return this.defaultVersion;
    }

    public void setDefaultVersion(String defaultVersion) {
        this.defaultVersion = defaultVersion;
    }

    public boolean supportsParameter(MethodParameter parameter) {
        Class paramType = parameter.getParameterType();
        Form sourceAnno = paramType.getAnnotation(Form.class);
        net.sf.xmlform.spring.annotation.Form formAnno = (net.sf.xmlform.spring.annotation.Form)parameter.getParameterAnnotation(net.sf.xmlform.spring.annotation.Form.class);
        Source sourceForm = (Source)parameter.getParameterAnnotation(Source.class);
        return XMLFormPastport.class.equals((Object)paramType) || SourceInfos.class.equals((Object)paramType) || SourceData.class.equals((Object)paramType) || ResultData.class.equals((Object)paramType) || ResultInfos.class.equals((Object)paramType) || sourceForm != null || formAnno != null && XMLForm.class.equals((Object)paramType) || sourceAnno != null || this.isSupport(paramType);
    }

    public Object resolveArgument(MethodParameter parameter, ModelAndViewContainer mavContainer, NativeWebRequest webRequest, WebDataBinderFactory binderFactory) throws Exception {
        if (this.xmlFormPort == null) {
            throw new IllegalStateException("Must set XMLFormPort");
        }
        XMLFormPastport pastport = this.contextPastportCreator.createPastport();
        Class paramType = parameter.getParameterType();
        if (XMLFormPastport.class.equals((Object)paramType)) {
            return pastport;
        }
        if (ResultData.class.equals((Object)paramType)) {
            return this.getResultData(webRequest);
        }
        if (ResultInfos.class.equals((Object)paramType)) {
            return this.getResultData(webRequest).getResultInfos();
        }
        SourceData sourceData = this.parseSourceData(parameter, mavContainer, webRequest, pastport);
        if (SourceData.class.equals((Object)paramType)) {
            return sourceData;
        }
        if (List.class.equals((Object)paramType)) {
            return sourceData.getData();
        }
        if (SourceInfos.class.equals((Object)paramType)) {
            return sourceData.getSourceInfos();
        }
        if (XMLForm.class.equals((Object)paramType)) {
            String sourceFormName = null;
            Class sourceClass = null;
            net.sf.xmlform.spring.annotation.Form formAnno = (net.sf.xmlform.spring.annotation.Form)parameter.getParameterAnnotation(net.sf.xmlform.spring.annotation.Form.class);
            if (formAnno.name().length() > 0) {
                sourceFormName = formAnno.name();
            }
            if (!formAnno.value().equals(Class.class)) {
                sourceClass = formAnno.value();
            }
            if (sourceFormName == null && sourceClass == null) {
                return webRequest.getAttribute(SOURCEFORM_KEY, 0);
            }
            return this.getForm(webRequest, pastport, sourceFormName, sourceClass);
        }
        List data = sourceData.getData();
        if (data.size() > 0) {
            return data.get(0);
        }
        return null;
    }

    private SourceData parseSourceData(MethodParameter parameter, ModelAndViewContainer mavContainer, NativeWebRequest webRequest, XMLFormPastport pastport) throws Exception {
        SourceData sourceData = (SourceData)webRequest.getAttribute(SOURCEDATA_KEY, 0);
        if (sourceData == null) {
            XMLDataSource dataSource;
            HttpServletRequest req;
            String encoding;
            Query query = (Query)parameter.getParameterAnnotation(Query.class);
            if (query == null) {
                query = parameter.getContainingClass().getAnnotation(Query.class);
            }
            SourceType sourceType = SourceType.FORM;
            if (query != null) {
                sourceType = query.value() ? SourceType.QUERY : SourceType.FORM;
            }
            Class paramType = parameter.getParameterType();
            int min = 1;
            int max = Integer.MAX_VALUE;
            String sourceFormName = null;
            Class sourceClass = null;
            boolean emptyFormName = false;
            Source sourceFormAnno = (Source)parameter.getParameterAnnotation(Source.class);
            if (sourceFormAnno != null) {
                min = sourceFormAnno.min();
                max = sourceFormAnno.max();
            }
            if (!SourceData.class.equals((Object)paramType)) {
                if (List.class.equals((Object)paramType)) {
                    Type genericType = parameter.getGenericParameterType();
                    if (genericType instanceof ParameterizedType) {
                        sourceClass = (Class)((ParameterizedType)genericType).getActualTypeArguments()[0];
                    }
                } else if (SourceInfos.class.equals((Object)paramType)) {
                    min = 0;
                } else if (!paramType.equals(Class.class)) {
                    sourceClass = paramType;
                    max = 1;
                }
            }
            if (sourceFormAnno != null) {
                if (sourceFormAnno.form().length() > 0) {
                    sourceFormName = sourceFormAnno.form();
                } else {
                    emptyFormName = true;
                }
                if (!sourceFormAnno.value().equals(Class.class)) {
                    sourceClass = sourceFormAnno.value();
                }
            }
            if ((encoding = (req = (HttpServletRequest)webRequest.getNativeRequest(HttpServletRequest.class)).getCharacterEncoding()) == null) {
                encoding = "UTF-8";
            }
            String requestString = this.readRequestString(encoding, (InputStream)req.getInputStream());
            if (this.isXmlMediaType(req)) {
                if (emptyFormName && Map.class.equals((Object)sourceClass)) {
                    dataSource = new FormlessXMLDataSource(requestString);
                    sourceData = (SourceData)this.xmlFormPort.parseData(pastport, (XMLForm)null, sourceType, dataSource);
                } else {
                    dataSource = new XMLDataSource(requestString);
                    XMLForm xmlform = sourceFormName == null && sourceClass == null ? null : this.getForm(webRequest, pastport, sourceFormName, sourceClass);
                    sourceData = (SourceData)this.xmlFormPort.parseData(pastport, xmlform, sourceType, dataSource);
                    webRequest.setAttribute(SOURCEFORM_KEY, (Object)xmlform, 0);
                }
            } else if (emptyFormName && Map.class.equals((Object)sourceClass)) {
                dataSource = new FormlessJSONDataSource(requestString);
                sourceData = (SourceData)this.xmlFormPort.parseData(pastport, (XMLForm)null, sourceType, dataSource);
            } else {
                dataSource = new JSONDataSource(requestString);
                XMLForm xmlform = sourceFormName == null && sourceClass == null ? null : this.getForm(webRequest, pastport, sourceFormName, sourceClass);
                sourceData = (SourceData)this.xmlFormPort.parseData(pastport, xmlform, sourceType, dataSource);
                webRequest.setAttribute(SOURCEFORM_KEY, (Object)xmlform, 0);
            }
            int size = sourceData.getData().size();
            if (size < min || size > max) {
                throw new XMLFormException("c.form.data", "Form occurs must between " + min + " and " + max + " .");
            }
            webRequest.setAttribute(SOURCEDATA_KEY, (Object)sourceData, 0);
        }
        return sourceData;
    }

    public boolean supportsReturnType(MethodParameter returnType) {
        Result form = (Result)returnType.getMethodAnnotation(Result.class);
        return form != null || ResultData.class.isAssignableFrom(returnType.getParameterType()) || ResultInfos.class.isAssignableFrom(returnType.getParameterType()) || this.isSupport(returnType.getParameterType());
    }

    public void handleReturnValue(Object returnValue, MethodParameter returnType, ModelAndViewContainer mavContainer, NativeWebRequest webRequest) throws Exception {
        this.doHandleReturnValue(returnValue, returnType, mavContainer, webRequest);
    }

    private void doHandleReturnValue(Object returnValue, MethodParameter returnType, ModelAndViewContainer mavContainer, NativeWebRequest webRequest) throws Exception {
        if (this.xmlFormPort == null) {
            throw new IllegalStateException("Must set XMLFormPort");
        }
        HttpServletRequest servletRequest = (HttpServletRequest)webRequest.getNativeRequest(HttpServletRequest.class);
        MediaType mediaType = this.getFormatMediaType(webRequest);
        String formatVersion = null;
        SourceData sourceData = (SourceData)webRequest.getAttribute(SOURCEDATA_KEY, 0);
        String getVersion = this.getGetParam(servletRequest, GET_KEY_VERSION);
        if (!FormUtils.isEmpty((String)getVersion)) {
            formatVersion = getVersion;
        } else if (sourceData != null) {
            if (sourceData.getSourceInfos().hasError()) {
                throw new XMLFormException("c.form.data", "", sourceData.getSourceInfos().getInvalidForms());
            }
            formatVersion = sourceData.getSourceInfos().getVersion();
        } else {
            formatVersion = this.getVersionParameter(mediaType);
        }
        boolean emptyFormName = false;
        Class resultClass = null;
        String resultFormName = null;
        Result resultFormAnno = (Result)returnType.getMethodAnnotation(Result.class);
        if (resultFormAnno != null) {
            if (resultFormAnno.form().length() > 0) {
                resultFormName = resultFormAnno.form();
            } else {
                emptyFormName = true;
            }
            if (!resultFormAnno.value().equals(Class.class)) {
                resultClass = resultFormAnno.value();
            }
        }
        if (resultClass != null && (List.class.isAssignableFrom(resultClass) || ResultInfos.class.isAssignableFrom(resultClass) || ResultData.class.isAssignableFrom(resultClass))) {
            resultClass = null;
        }
        ResultData resultData = null;
        if (returnValue == null) {
            resultData = this.getResultData(webRequest);
            resultData.setData(new ArrayList(0));
        } else if (returnValue instanceof ResultInfos) {
            resultData = this.getResultData(webRequest);
            resultData.setResultInfos((ResultInfos)returnValue);
        } else if (returnValue instanceof List) {
            resultData = this.getResultData(webRequest);
            resultData.setData((List)returnValue);
            if (resultClass == null) {
                resultClass = this.getClassFromList(resultData.getData());
            }
        } else if (returnValue instanceof ResultData) {
            resultData = (ResultData)returnValue;
            if (resultClass == null) {
                resultClass = this.getClassFromList(resultData.getData());
            }
        } else {
            resultData = this.getResultData(webRequest);
            ArrayList<Object> data = new ArrayList<Object>(1);
            data.add(returnValue);
            resultData.setData(data);
            resultData.getResultInfos().setSingle(true);
            if (resultClass == null) {
                resultClass = this.getClassFromList(resultData.getData());
            }
        }
        boolean any = false;
        if (emptyFormName && resultClass != null && Map.class.isAssignableFrom(resultClass)) {
            any = true;
        }
        XMLFormPastport pastport = this.contextPastportCreator.createPastport();
        if (resultData.getForm() == null && !any) {
            resultData.setForm(resultFormName == null && resultClass == null ? null : this.getForm(webRequest, pastport, resultFormName, resultClass));
        }
        for (int i = 0; i < this.resultDataPostProcessors.size(); ++i) {
            ResultData newData = this.resultDataPostProcessors.get(i).postProcessResultData(pastport, resultData);
            if (newData == null) continue;
            resultData = newData;
        }
        long totalResult = resultData.getResultInfos().getTotalResults();
        int dataSize = resultData.getData().size();
        if (totalResult == 0L && dataSize > 0) {
            resultData.getResultInfos().setTotalResults((long)dataSize);
        }
        String result = null;
        boolean isXml = false;
        isXml = "xml".equals(this.getGetParam(servletRequest, GET_KEY_FORMAT)) ? true : this.isXmlMediaType(mediaType);
        if (isXml) {
            if (any) {
                result = DataXMLFormat.resultToXML((ResultData)resultData, (String)formatVersion);
            } else {
                DataXMLFormat xmlFormat = new DataXMLFormat(resultData);
                xmlFormat.setVersion(formatVersion);
                result = (String)this.xmlFormPort.formatData(pastport, xmlFormat);
            }
        } else {
            boolean isCompact = false;
            String bodyType = this.getGetParam(servletRequest, GET_KEY_BODYTYPE);
            if ("compact".equals(bodyType)) {
                isCompact = true;
            } else if ("compact".equals(this.getBodyTypeParameter(mediaType))) {
                isCompact = true;
            } else if (resultFormAnno != null && resultFormAnno.compact() != -1) {
                isCompact = resultData.getData().size() >= resultFormAnno.compact();
            } else if (this.defaultCompact != -1) {
                boolean bl = isCompact = resultData.getData().size() >= this.defaultCompact;
            }
            if (any) {
                result = DataJSONFormat.resultToJson((ResultData)resultData, (boolean)isCompact, (String)formatVersion);
            } else {
                DataJSONFormat jsonResult = new DataJSONFormat(resultData, isCompact);
                jsonResult.setVersion(formatVersion);
                result = (String)this.xmlFormPort.formatData(pastport, jsonResult);
            }
        }
        if (logger.isDebugEnabled()) {
            logger.debug("Response data", (Object)result);
        }
        HttpServletResponse response = (HttpServletResponse)webRequest.getNativeResponse(HttpServletResponse.class);
        response.setContentType(JSON_UTF8);
        PrintWriter writer = response.getWriter();
        writer.write(result);
        writer.flush();
        mavContainer.setRequestHandled(true);
    }

    private Class getClassFromList(List list) {
        if (list.size() == 0) {
            return null;
        }
        return list.get(0).getClass();
    }

    private ResultData getResultData(NativeWebRequest webRequest) {
        ResultData resultData = (ResultData)webRequest.getAttribute(RESULTDATA_KEY, 0);
        if (resultData == null) {
            resultData = new ResultData();
            webRequest.setAttribute(RESULTDATA_KEY, (Object)resultData, 0);
        }
        return resultData;
    }

    public ModelAndView resolveException(HttpServletRequest request, HttpServletResponse response, Object handler, Exception ex) {
        SourceData sourceData = (SourceData)request.getAttribute(SOURCEDATA_KEY);
        XMLFormException exception = null;
        if (ex instanceof XMLFormException) {
            exception = (XMLFormException)ex;
        } else if (ex instanceof ActionException) {
            ActionException aex = (ActionException)ex;
            exception = sourceData != null ? new XMLFormException(aex.getFaultCode(), aex.getFaultString(), sourceData.getSourceInfos().getInvalidForms()) : new XMLFormException(aex.getFaultCode(), aex.getFaultString());
        }
        if (exception == null) {
            return null;
        }
        final Locale locale = LocaleContextHolder.getLocale();
        XMLFormPastport pastport = new XMLFormPastport(){

            public Locale getLocale() {
                return locale;
            }
        };
        MediaType mediaType = this.getFormatMediaType((NativeWebRequest)new ServletWebRequest(request));
        String result = null;
        String formatVersion = null;
        formatVersion = sourceData != null ? sourceData.getSourceInfos().getVersion() : this.getVersionParameter(mediaType);
        if (this.isXmlMediaType(mediaType)) {
            DataXMLFormat xmlFormat = new DataXMLFormat(exception);
            xmlFormat.setVersion(formatVersion);
            result = (String)this.xmlFormPort.formatData(pastport, xmlFormat);
        } else {
            DataJSONFormat jsonResult = new DataJSONFormat(exception);
            jsonResult.setVersion(formatVersion);
            result = (String)this.xmlFormPort.formatData(pastport, jsonResult);
        }
        if (logger.isDebugEnabled()) {
            logger.debug("Response exception", (Object)result);
        }
        ExceptionView view = new ExceptionView(JSON_UTF8, result);
        ModelAndView mv = new ModelAndView();
        mv.setView((View)view);
        return mv;
    }

    private String readRequestString(String encoding, InputStream in) throws UnsupportedEncodingException, IOException {
        InputStreamReader reader = new InputStreamReader(in, encoding);
        char[] buffer = new char[1024];
        int len = reader.read(buffer);
        StringBuffer sb = new StringBuffer();
        while (len != -1) {
            sb.append(buffer, 0, len);
            len = reader.read(buffer);
        }
        String result = sb.toString();
        if (logger.isDebugEnabled()) {
            logger.debug("Request data", (Object)result);
        }
        return result;
    }

    private XMLForm getForm(NativeWebRequest webRequest, XMLFormPastport pastport, String formName, Class cls) {
        XMLForm xmlform;
        String key = formName != null ? formName : FormFactory.parseFormName((Class)cls);
        HashMap<String, XMLForm> formMap = (HashMap<String, XMLForm>)webRequest.getAttribute(XMLFORMS_KEY, 0);
        if (formMap == null) {
            formMap = new HashMap<String, XMLForm>();
            webRequest.setAttribute(XMLFORMS_KEY, formMap, 0);
        }
        if ((xmlform = (XMLForm)formMap.get(key)) == null) {
            xmlform = formName != null ? this.xmlFormPort.getForm(pastport, formName) : this.xmlFormPort.getForm(pastport, cls);
            formMap.put(key, xmlform);
        }
        return xmlform;
    }

    public boolean canRead(Class cls, MediaType mediaType) {
        Form form = cls.getAnnotation(Form.class);
        return form != null || SourceData.class.isAssignableFrom(cls) || this.isSupport(cls);
    }

    public boolean canWrite(Class cls, MediaType mediaType) {
        Form form = cls.getAnnotation(Form.class);
        return form != null || ResultData.class.isAssignableFrom(cls) || XMLFormException.class.isAssignableFrom(cls) || ActionException.class.isAssignableFrom(cls) || this.isSupport(cls);
    }

    public List getSupportedMediaTypes() {
        return this.supportedMediaTypes;
    }

    public Object read(Class cls, HttpInputMessage input) throws IOException, HttpMessageNotReadableException {
        SourceData sourceData;
        XMLFormPastport pastport = this.contextPastportCreator.createPastport();
        String requestString = this.readRequestString("UTF-8", input.getBody());
        Object dataSource = null;
        dataSource = this.isXmlMediaType(input.getHeaders().getContentType()) ? new XMLDataSource(requestString) : new JSONDataSource(requestString);
        SourceType sourceType = SourceType.FORM;
        Query query = cls.getAnnotation(Query.class);
        if (query != null) {
            SourceType sourceType2 = sourceType = query.value() ? SourceType.QUERY : SourceType.FORM;
        }
        if ((sourceData = (SourceData)this.xmlFormPort.parseData(pastport, this.xmlFormPort.getForm(pastport, cls), sourceType, dataSource)).getSourceInfos().hasError()) {
            throw new XMLFormException("c.form.data", "", sourceData.getSourceInfos().getInvalidForms());
        }
        if (SourceData.class.isAssignableFrom(cls)) {
            return sourceData;
        }
        SourceInfos infos = sourceData.getSourceInfos();
        InvalidForm[] invalidForms = null;
        Object readResult = null;
        if (sourceData.getData().size() > 0 && ((readResult = sourceData.getData().get(0)) instanceof InvalidForm || !"ok".equals(infos.getFaultCode()))) {
            invalidForms = sourceData.getData().toArray(new InvalidForm[sourceData.getData().size()]);
        }
        if (!"ok".equals(infos.getFaultCode())) {
            if (invalidForms == null) {
                invalidForms = new InvalidForm[]{};
            }
            throw new XMLFormException(infos.getFaultCode(), infos.getFaultString(), invalidForms);
        }
        return readResult;
    }

    public void write(Object obj, MediaType mediaType, HttpOutputMessage output) throws IOException, HttpMessageNotWritableException {
        XMLFormPastport pastport = this.contextPastportCreator.createPastport();
        DataJSONFormat dataFormat = null;
        if (obj instanceof XMLFormException) {
            dataFormat = new DataJSONFormat((XMLFormException)obj);
        } else if (obj instanceof ActionException) {
            ActionException aex = (ActionException)obj;
            dataFormat = new DataJSONFormat(new XMLFormException(aex.getFaultCode(), aex.getFaultString()));
        } else {
            ResultData resultData = null;
            if (obj == null) {
                resultData = new ResultData();
                resultData.setData(new ArrayList(0));
            } else if (obj instanceof ResultData) {
                resultData = (ResultData)obj;
                List dataList = resultData.getData();
                int dataSize = dataList.size();
                if (dataSize > 0) {
                    obj = dataList.get(0);
                    if (resultData.getResultInfos().getTotalResults() == 0L) {
                        resultData.getResultInfos().setTotalResults((long)dataSize);
                    }
                } else {
                    obj = null;
                }
            } else {
                resultData = new ResultData();
                resultData.getResultInfos().setTotalResults(1L);
                ArrayList<Object> data = new ArrayList<Object>(1);
                data.add(obj);
                resultData.setData(data);
            }
            if (resultData.getForm() == null && obj != null) {
                resultData.setForm(this.xmlFormPort.getForm(pastport, obj.getClass()));
            }
            String formatVersion = this.getVersionParameter(mediaType);
            if (this.isXmlMediaType(mediaType)) {
                DataXMLFormat xmlFormat = new DataXMLFormat(resultData);
                xmlFormat.setVersion(formatVersion);
                dataFormat = xmlFormat;
            } else {
                boolean isCompact = false;
                if ("compact".equals(this.getBodyTypeParameter(mediaType)) || "compact".equals(this.getBodyTypeParameter(mediaType))) {
                    isCompact = true;
                } else if (this.defaultCompact != -1) {
                    isCompact = resultData.getData().size() >= this.defaultCompact;
                }
                DataJSONFormat jsonResult = new DataJSONFormat(resultData, isCompact);
                jsonResult.setVersion(formatVersion);
                dataFormat = jsonResult;
            }
        }
        String result = (String)this.xmlFormPort.formatData(pastport, dataFormat);
        output.getHeaders().setContentType(mediaType);
        output.getBody().write(result.getBytes());
    }

    private MediaType getFormatMediaType(NativeWebRequest webRequest) {
        if (this.contentNegotiationManager != null) {
            try {
                List types = this.contentNegotiationManager.resolveMediaTypes(webRequest);
                if (types.size() == 0) {
                    return MediaType.APPLICATION_JSON;
                }
                return (MediaType)types.get(0);
            }
            catch (HttpMediaTypeNotAcceptableException e) {
                e.printStackTrace();
            }
        }
        List types = null;
        try {
            types = this.headerContentNegotiationStrategy.resolveMediaTypes(webRequest);
        }
        catch (HttpMediaTypeNotAcceptableException e) {
            e.printStackTrace();
        }
        if (types == null || types.size() == 0) {
            return MediaType.APPLICATION_JSON;
        }
        return (MediaType)types.get(0);
    }

    private boolean isXmlMediaType(MediaType mediaType) {
        return mediaType.getType().equals(MediaType.TEXT_XML.getType()) && mediaType.getSubtype().equals(MediaType.TEXT_XML.getSubtype()) || mediaType.getType().equals(MediaType.APPLICATION_XML.getType()) && mediaType.getSubtype().equals(MediaType.APPLICATION_XML.getSubtype());
    }

    private boolean isJsonMediaType(MediaType mediaType) {
        return mediaType.getType().equals(MediaType.APPLICATION_JSON.getType()) && mediaType.getSubtype().equals(MediaType.APPLICATION_JSON.getSubtype());
    }

    private boolean isXmlMediaType(HttpServletRequest req) {
        String type = req.getContentType();
        if (type == null) {
            return false;
        }
        return this.isXmlMediaType(MediaType.valueOf((String)type));
    }

    private String getVersionParameter(MediaType mediaType) {
        String ver = mediaType.getParameter("version");
        if (!FormUtils.isEmpty((String)ver)) {
            return ver;
        }
        return this.defaultVersion;
    }

    private String getBodyTypeParameter(MediaType mediaType) {
        String ver = mediaType.getParameter("bodytype");
        if (!FormUtils.isEmpty((String)ver)) {
            return ver;
        }
        return null;
    }

    private String getGetParam(HttpServletRequest servletRequest, String key) {
        if (servletRequest == null) {
            return null;
        }
        if ("GET".equals(servletRequest.getMethod())) {
            String value = servletRequest.getParameter(key);
            if (FormUtils.isEmpty((String)value)) {
                return null;
            }
            return value.toLowerCase();
        }
        return null;
    }

    private boolean isSupport(Class cls) {
        for (int i = 0; i < this.typeSupporters.size(); ++i) {
            if (!this.typeSupporters.get(i).isSupport(cls)) continue;
            return true;
        }
        return false;
    }

    public int getOrder() {
        return Integer.MIN_VALUE;
    }
}

