package net.sf.xmlform.spring.impl;

import java.util.Locale;

import org.springframework.context.i18n.LocaleContextHolder;

import net.sf.xmlform.XMLFormPastport;
import net.sf.xmlform.spring.config.PastportCreator;

public class DefaultContextPastportCreator implements PastportCreator {

	@Override
	public XMLFormPastport createPastport() {
		return new XMLFormPastport(){
			@Override
			public Locale getLocale() {
				final Locale locale=LocaleContextHolder.getLocale();
				return locale!=null?locale:Locale.ENGLISH;
			}
		};
	}

}
