package net.sf.xmlform.spring.web.impl;

import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.PrintWriter;
import java.io.UnsupportedEncodingException;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;

import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.context.i18n.LocaleContextHolder;
import org.springframework.core.MethodParameter;
import org.springframework.core.Ordered;
import org.springframework.http.HttpInputMessage;
import org.springframework.http.HttpOutputMessage;
import org.springframework.http.MediaType;
import org.springframework.http.converter.HttpMessageConverter;
import org.springframework.http.converter.HttpMessageNotReadableException;
import org.springframework.http.converter.HttpMessageNotWritableException;
import org.springframework.web.HttpMediaTypeNotAcceptableException;
import org.springframework.web.accept.ContentNegotiationManager;
import org.springframework.web.accept.HeaderContentNegotiationStrategy;
import org.springframework.web.bind.support.WebDataBinderFactory;
import org.springframework.web.context.request.NativeWebRequest;
import org.springframework.web.context.request.RequestAttributes;
import org.springframework.web.context.request.ServletWebRequest;
import org.springframework.web.method.support.HandlerMethodArgumentResolver;
import org.springframework.web.method.support.HandlerMethodReturnValueHandler;
import org.springframework.web.method.support.ModelAndViewContainer;
import org.springframework.web.servlet.HandlerExceptionResolver;
import org.springframework.web.servlet.ModelAndView;

import net.sf.xmlform.XMLFormException;
import net.sf.xmlform.XMLFormPastport;
import net.sf.xmlform.action.ActionException;
import net.sf.xmlform.config.annotation.Form;
import net.sf.xmlform.config.annotation.FormFactory;
import net.sf.xmlform.data.DataFormat;
import net.sf.xmlform.data.DataSource;
import net.sf.xmlform.data.InvalidForm;
import net.sf.xmlform.data.ResultData;
import net.sf.xmlform.data.ResultInfos;
import net.sf.xmlform.data.SourceData;
import net.sf.xmlform.data.SourceInfos;
import net.sf.xmlform.data.SourceType;
import net.sf.xmlform.data.VersionConstants;
import net.sf.xmlform.data.format.DataJSONFormat;
import net.sf.xmlform.data.format.DataXMLFormat;
import net.sf.xmlform.data.format.JSONConstants;
import net.sf.xmlform.data.source.FormlessJSONDataSource;
import net.sf.xmlform.data.source.FormlessXMLDataSource;
import net.sf.xmlform.data.source.JSONDataSource;
import net.sf.xmlform.data.source.XMLDataSource;
import net.sf.xmlform.form.XMLForm;
import net.sf.xmlform.spring.annotation.Query;
import net.sf.xmlform.spring.annotation.Result;
import net.sf.xmlform.spring.annotation.Source;
import net.sf.xmlform.spring.config.PastportCreator;
import net.sf.xmlform.spring.config.ResultDataPostProcessor;
import net.sf.xmlform.spring.config.TypeSupporter;
import net.sf.xmlform.spring.impl.DefaultContextPastportCreator;
import net.sf.xmlform.spring.support.DynamicFormPort;
import net.sf.xmlform.util.FormUtils;

/**
 * @author Liu Zhikun
 * 
 * spring mvc 优先级的问题,参数和结果类型不能是Map , 可是 List&lt;Map&gt;
 */

public class FormDataWebProcessor implements Ordered,HandlerMethodArgumentResolver,HandlerMethodReturnValueHandler,HandlerExceptionResolver,HttpMessageConverter {
	private final static String SOURCEDATA_KEY=FormDataWebProcessor.class.getName()+"_sourcedata";
	private final static String RESULTDATA_KEY=FormDataWebProcessor.class.getName()+"_resultdata";
	private final static String XMLFORMS_KEY=FormDataWebProcessor.class.getName()+"_xmlforms";
	private final static String SOURCEFORM_KEY=FormDataWebProcessor.class.getName()+"_sourceform";
	private final static String JSON_UTF8= "application/json;charset=UTF-8";
//	private final static MediaType MIMETYPE_COMPACT=MediaType.valueOf(JSONConstants.MIME_COMPACT);
//	private final static MediaType MIMETYPE_FLAT=MediaType.valueOf(JSONConstants.MIME_FLAT);
	private final static String GET_KEY_VERSION="_xfversion";
	private final static String GET_KEY_FORMAT="_xfformat";
	private final static String GET_KEY_BODYTYPE="_xfbodytype";
	private static Logger logger=LoggerFactory.getLogger(FormFactory.class);
	private List<MediaType> supportedMediaTypes = new ArrayList<MediaType>(){{
		add(MediaType.APPLICATION_JSON);
		add(MediaType.valueOf(JSON_UTF8));
//		add(MIMETYPE_COMPACT);
//		add(MIMETYPE_FLAT);
//		//add(MediaType.valueOf(JSONConstants.MIME_QUERY));
	}};
	private int defaultCompact=-1;
	private String defaultVersion=VersionConstants.VERSION_2_0;
	private PastportCreator contextPastportCreator=new DefaultContextPastportCreator();
	private DynamicFormPort xmlFormPort;
	private List<TypeSupporter> typeSupporters = Collections.emptyList();
	private List<ResultDataPostProcessor> resultDataPostProcessors=Collections.emptyList();
	private ContentNegotiationManager contentNegotiationManager;
	private HeaderContentNegotiationStrategy headerContentNegotiationStrategy=new HeaderContentNegotiationStrategy();
	
	
	public ContentNegotiationManager getContentNegotiationManager() {
		return contentNegotiationManager;
	}

	public void setContentNegotiationManager(ContentNegotiationManager contentNegotiationManager) {
		this.contentNegotiationManager = contentNegotiationManager;
	}

	public PastportCreator getContextPastportCreator() {
		return contextPastportCreator;
	}

	public void setContextPastportCreator(PastportCreator pastportCreator) {
		this.contextPastportCreator = pastportCreator;
	}

	public List<TypeSupporter> getTypeSupporters() {
		return typeSupporters;
	}

	public void setTypeSupporters(List<TypeSupporter> typeSupporters) {
		this.typeSupporters = typeSupporters;
	}

	public List<ResultDataPostProcessor> getResultDataPostProcessors() {
		return resultDataPostProcessors;
	}

	public void setResultDataPostProcessors(List<ResultDataPostProcessor> resultDataPostProcessors) {
		this.resultDataPostProcessors = resultDataPostProcessors;
	}

	public DynamicFormPort getFormPort() {
		return xmlFormPort;
	}

	public void setFormPort(DynamicFormPort xmlformPort) {
		this.xmlFormPort = xmlformPort;
	}
	
	public int getDataCompact() {
		return defaultCompact;
	}

	public void setDataCompact(int defaultCompact) {
		this.defaultCompact = defaultCompact;
	}

	public String getDefaultVersion() {
		return defaultVersion;
	}

	public void setDefaultVersion(String defaultVersion) {
		this.defaultVersion = defaultVersion;
	}

	/*
	 * HandlerMethodArgumentResolver
	 */
	@Override
	public boolean supportsParameter(MethodParameter parameter) {
		Class paramType=parameter.getParameterType();
		//参数类型自己用Form注解
		net.sf.xmlform.config.annotation.Form sourceAnno=( net.sf.xmlform.config.annotation.Form)paramType.getAnnotation(net.sf.xmlform.config.annotation.Form.class);
		//参数用Form注解
		//net.sf.xmlform.spring.annotation.Form formAnno=( net.sf.xmlform.spring.annotation.Form)parameter.getParameterAnnotation(net.sf.xmlform.spring.annotation.Form.class);
		//参数用Source注解
		Source sourceForm=parameter.getParameterAnnotation(Source.class);
		return XMLFormPastport.class.equals(paramType)
				||SourceInfos.class.equals(paramType)
				||SourceData.class.equals(paramType)
				||ResultData.class.equals(paramType)
				||ResultInfos.class.equals(paramType)
				||XMLForm.class.equals(paramType)
				||(sourceForm!=null)
				||sourceAnno!=null
				||isSupport(paramType)
				;
	}

	@Override
	public Object resolveArgument(MethodParameter parameter, ModelAndViewContainer mavContainer, NativeWebRequest webRequest, WebDataBinderFactory binderFactory) throws Exception {
		if(xmlFormPort==null)
			throw new IllegalStateException("Must set XMLFormPort");
		XMLFormPastport pastport=contextPastportCreator.createPastport();
		Class paramType=parameter.getParameterType();
		if(XMLFormPastport.class.equals(paramType)){
			return pastport;
		}
		if(ResultData.class.equals(paramType)){
			return getResultData(webRequest);
		}
		if(ResultInfos.class.equals(paramType)){
			return getResultData(webRequest).getResultInfos();
		}
		if(XMLForm.class.equals(paramType)){
			String sourceFormName=null;
			Class sourceClass=null;
			net.sf.xmlform.spring.annotation.Form formAnno=( net.sf.xmlform.spring.annotation.Form)parameter.getParameterAnnotation(net.sf.xmlform.spring.annotation.Form.class);
			if(formAnno!=null) {
				if(formAnno.name().length()>0){
					sourceFormName=formAnno.name();
				}
				if(!formAnno.value().equals(Class.class)){
					sourceClass=formAnno.value();
				}
			}
			if(sourceFormName==null&&sourceClass==null)
				return webRequest.getAttribute(SOURCEFORM_KEY, RequestAttributes.SCOPE_REQUEST);
			return getForm(webRequest,pastport, sourceFormName,sourceClass);
		}
		
		SourceData sourceData=parseSourceData(parameter,mavContainer,webRequest,pastport);
		if(SourceData.class.equals(paramType)){
			return sourceData;
		}else if(List.class.equals(paramType)){
			return sourceData.getData();
		}else if(SourceInfos.class.equals(paramType)){
			return sourceData.getSourceInfos();
		}else {
			List data=sourceData.getData();
			if(data.size()>0)
				return data.get(0);
		}
		return null;
	}
	private SourceData parseSourceData(MethodParameter parameter,ModelAndViewContainer mavContainer,NativeWebRequest webRequest, XMLFormPastport pastport)throws Exception{
		SourceData sourceData=(SourceData)webRequest.getAttribute(SOURCEDATA_KEY, RequestAttributes.SCOPE_REQUEST);
		if(sourceData==null){
			Query query=parameter.getParameterAnnotation(Query.class);
			if(query==null){
				query=parameter.getContainingClass().getAnnotation(Query.class);
			}
			SourceType sourceType=SourceType.FORM;
			if(query!=null)
				sourceType=query.value()?SourceType.QUERY:SourceType.FORM;
			
			Class paramType=parameter.getParameterType();	
			int min=1,max=Integer.MAX_VALUE;
			String sourceFormName=null;
			Class sourceClass=null;
			boolean emptyFormName=false;
			
			Source sourceFormAnno=parameter.getParameterAnnotation(Source.class);
			if(sourceFormAnno!=null){
				min=sourceFormAnno.min();
				max=sourceFormAnno.max();
			}
			if(SourceData.class.equals(paramType)){
				;
			}else if(List.class.equals(paramType)){
				Type genericType =parameter.getGenericParameterType();
		        if(genericType instanceof ParameterizedType){
		        	sourceClass=(Class)((ParameterizedType)genericType).getActualTypeArguments()[0];
		        }
			}else if(SourceInfos.class.equals(paramType)){
				min=0;
			}else{
				if(!paramType.equals(Class.class)){
					sourceClass=paramType;
					max=1;
				}
			}
			
			if(sourceFormAnno!=null){
				if(sourceFormAnno.form().length()>0){
					sourceFormName=sourceFormAnno.form();
				}else {
					emptyFormName=true;
				}
				if(!sourceFormAnno.value().equals(Class.class)){
					sourceClass=sourceFormAnno.value();
				}
			}
			
			HttpServletRequest req=webRequest.getNativeRequest(HttpServletRequest.class);
			String encoding = req.getCharacterEncoding();
			if (encoding == null)
				encoding = "UTF-8";
			String requestString=readRequestString(encoding,req.getInputStream());
			
			if(isXmlMediaType(req)) {
				if((emptyFormName&&Map.class.equals(sourceClass))) {
					FormlessXMLDataSource dataSource=new FormlessXMLDataSource(requestString);
					sourceData=xmlFormPort.parseData(pastport,null , sourceType, dataSource);
				}else {
					XMLDataSource dataSource=new XMLDataSource(requestString); 
					XMLForm xmlform=(sourceFormName==null&&sourceClass==null)?null:getForm(webRequest,pastport, sourceFormName,sourceClass);
					sourceData=xmlFormPort.parseData(pastport,xmlform , sourceType, dataSource);
					webRequest.setAttribute(SOURCEFORM_KEY, xmlform,RequestAttributes.SCOPE_REQUEST);
				}
			}else {
				if((emptyFormName&&Map.class.equals(sourceClass))) {
					FormlessJSONDataSource dataSource=new FormlessJSONDataSource(requestString);
					sourceData=xmlFormPort.parseData(pastport,null , sourceType, dataSource);
				}else {
					JSONDataSource dataSource=new JSONDataSource(requestString);
					XMLForm xmlform=(sourceFormName==null&&sourceClass==null)?null:getForm(webRequest,pastport, sourceFormName,sourceClass);
					sourceData=xmlFormPort.parseData(pastport,xmlform , sourceType, dataSource);
					webRequest.setAttribute(SOURCEFORM_KEY, xmlform,RequestAttributes.SCOPE_REQUEST);
				}
			}
			
			int size=sourceData.getData().size();
			if(size<min||size>max){
				throw new XMLFormException(XMLFormException.CE_FORM_DATA,"Form occurs must between "+min+" and "+max+" .");
			}
			
			webRequest.setAttribute(SOURCEDATA_KEY, sourceData,RequestAttributes.SCOPE_REQUEST);
			
		}
		return sourceData;
	}
	/*
	 * HandlerMethodReturnValueHandler
	 */
	@Override
	public boolean supportsReturnType(MethodParameter returnType) {
		Result form=returnType.getMethodAnnotation(Result.class);
		return form!=null
				||ResultData.class.isAssignableFrom(returnType.getParameterType())
				||ResultInfos.class.isAssignableFrom(returnType.getParameterType())
				||isSupport(returnType.getParameterType());
	}

	@Override
	public void handleReturnValue(Object returnValue, MethodParameter returnType, ModelAndViewContainer mavContainer, NativeWebRequest webRequest) throws Exception {
		doHandleReturnValue(returnValue,returnType,mavContainer,webRequest);
	}
	private void doHandleReturnValue(Object returnValue, MethodParameter returnType, ModelAndViewContainer mavContainer, NativeWebRequest webRequest) throws Exception {
		if(xmlFormPort==null)
			throw new IllegalStateException("Must set XMLFormPort");
		
		HttpServletRequest servletRequest=webRequest.getNativeRequest(HttpServletRequest.class);
		MediaType mediaType = getFormatMediaType(webRequest);
		String formatVersion=null;
		
		SourceData sourceData=(SourceData)webRequest.getAttribute(SOURCEDATA_KEY, RequestAttributes.SCOPE_REQUEST);
		
		String getVersion=getGetParam(servletRequest, GET_KEY_VERSION);
		if(!FormUtils.isEmpty(getVersion)) {
			formatVersion=getVersion;
		}else if(sourceData!=null) {
			if(sourceData.getSourceInfos().hasError()) {
				throw new XMLFormException(XMLFormException.CE_FORM_DATA,"",sourceData.getSourceInfos().getInvalidForms());
			}
			formatVersion=sourceData.getSourceInfos().getVersion();
		}else {
			formatVersion=getVersionParameter(mediaType);
		}
		
		boolean emptyFormName=false;
		Class resultClass=null;
		String resultFormName=null;		
		Result resultFormAnno=returnType.getMethodAnnotation(Result.class);
		if(resultFormAnno!=null){
			if(resultFormAnno.form().length()>0){
				resultFormName=resultFormAnno.form();
			}else {
				emptyFormName=true;
			}
			if(!resultFormAnno.value().equals(Class.class)){
				resultClass=resultFormAnno.value();
			}
		}
		
		if(resultClass!=null) {
			if(List.class.isAssignableFrom(resultClass)
					||ResultInfos.class.isAssignableFrom(resultClass)
					||ResultData.class.isAssignableFrom(resultClass))
				resultClass=null;
		}
		
		ResultData resultData=null;
		if(returnValue==null){
			resultData=getResultData(webRequest);
			resultData.setData(new ArrayList(0));
		}else if(returnValue instanceof ResultInfos){
			resultData=getResultData(webRequest);
			resultData.setResultInfos((ResultInfos)returnValue);
		}else if(returnValue instanceof List){
			resultData=getResultData(webRequest);
			resultData.setData((List)returnValue);
			if(resultClass==null)
				resultClass=getClassFromList(resultData.getData());
		}else if(returnValue instanceof ResultData){
			resultData=(ResultData)returnValue;
			if(resultClass==null)
				resultClass=getClassFromList(resultData.getData());
		}else{
			resultData=getResultData(webRequest);
			List data=new ArrayList(1);
			data.add(returnValue);
			resultData.setData(data);
			resultData.getResultInfos().setSingle(true);
			if(resultClass==null)
				resultClass=getClassFromList(resultData.getData());
		}
		
		boolean any=false;
		if((emptyFormName&&resultClass!=null&&Map.class.isAssignableFrom(resultClass))
//				||AnyForm.NAME.equals(resultFormName)
			) {
			any=true;
		}
		
		XMLFormPastport pastport=contextPastportCreator.createPastport();
		if(resultData.getForm()==null&&any==false)
			resultData.setForm((resultFormName==null&&resultClass==null)?null:getForm(webRequest,pastport, resultFormName,resultClass));
		
		for(int i=0;i<resultDataPostProcessors.size();i++){
			ResultData newData=resultDataPostProcessors.get(i).postProcessResultData(pastport, resultData);
			if(newData!=null){
				resultData=newData;
			}
		}
		
		long totalResult=resultData.getResultInfos().getTotalResults();
		int dataSize=resultData.getData().size();
		if(totalResult==0L&&dataSize>0) {
			resultData.getResultInfos().setTotalResults(dataSize);
		}

		String result=null;
		boolean isXml=false;
		
		if("xml".equals(this.getGetParam(servletRequest, GET_KEY_FORMAT))) {
			isXml=true;
		}else {
			isXml=isXmlMediaType(mediaType);
		}
		
		if(isXml) {
			if(any) {
				result=DataXMLFormat.resultToXML(resultData, formatVersion);
			}else {
				DataXMLFormat xmlFormat=new DataXMLFormat(resultData);
				xmlFormat.setVersion(formatVersion);
				result=xmlFormPort.formatData(pastport, xmlFormat);
			}
		}else {
			boolean isCompact=false;
			String bodyType=this.getGetParam(servletRequest, GET_KEY_BODYTYPE);
			if(JSONConstants.COMPACT.equals(bodyType)) {
				isCompact=true;
			}else if(JSONConstants.COMPACT.equals(getBodyTypeParameter(mediaType))) {
				isCompact=true;
			}else if(resultFormAnno!=null&&resultFormAnno.compact()!=-1){
				isCompact=resultData.getData().size()>=resultFormAnno.compact();
			}else if(defaultCompact!=-1){
				isCompact=resultData.getData().size()>=defaultCompact;
			}
			
			if(any) {
				result=DataJSONFormat.resultToJson(resultData, isCompact,formatVersion);
			}else {
				DataJSONFormat jsonResult = new DataJSONFormat(resultData,isCompact);
				jsonResult.setVersion(formatVersion);
				result=xmlFormPort.formatData(pastport, jsonResult);
			}
		}
		
		if(logger.isDebugEnabled()) {
			logger.debug("Response data", result);
		}
		
		HttpServletResponse response=webRequest.getNativeResponse(HttpServletResponse.class);
		response.setContentType(JSON_UTF8);
		PrintWriter writer = response.getWriter();
		writer.write(result);
		writer.flush();
		mavContainer.setRequestHandled(true);
	}
	private Class getClassFromList(List list){
		if(list.size()==0)
			return null;
		return list.get(0).getClass();
	}
	private ResultData getResultData(NativeWebRequest webRequest){
		ResultData resultData=(ResultData)webRequest.getAttribute(RESULTDATA_KEY, RequestAttributes.SCOPE_REQUEST);
		if(resultData==null){
			resultData=new ResultData();
			webRequest.setAttribute(RESULTDATA_KEY, resultData,RequestAttributes.SCOPE_REQUEST);
		}
		return resultData;
	}
	/*
	 * HandlerExceptionResolver
	 */
	@Override
	public ModelAndView resolveException(HttpServletRequest request, HttpServletResponse response, Object handler, Exception ex) {
		SourceData sourceData=(SourceData)request.getAttribute(SOURCEDATA_KEY);
		
		XMLFormException exception=null;
		if(ex instanceof XMLFormException){
			exception=(XMLFormException)ex;
		}else if(ex instanceof ActionException){
			ActionException aex=(ActionException)ex;
			if(sourceData!=null){
				exception=new XMLFormException(aex.getFaultCode(),aex.getFaultString(),sourceData.getSourceInfos().getInvalidForms());
			}else{
				exception=new XMLFormException(aex.getFaultCode(),aex.getFaultString());
			}
		}
		if(exception==null)
			return null;
		
		final Locale locale=LocaleContextHolder.getLocale();
		XMLFormPastport pastport=new XMLFormPastport() {
			@Override
			public Locale getLocale() {
				return locale;
			}
		};
		
		MediaType mediaType = getFormatMediaType(new ServletWebRequest(request));
		String result=null;
		String formatVersion=null;
		if(sourceData!=null){
			formatVersion=sourceData.getSourceInfos().getVersion();
		}else {
			formatVersion=getVersionParameter(mediaType);
		}
		if(isXmlMediaType(mediaType)) {
			DataXMLFormat xmlFormat=new DataXMLFormat(exception);
			xmlFormat.setVersion(formatVersion);
			result=xmlFormPort.formatData(pastport, xmlFormat);
		}else {
			DataJSONFormat jsonResult = new DataJSONFormat(exception);
			jsonResult.setVersion(formatVersion);
			result=xmlFormPort.formatData(pastport, jsonResult);
		}
		if(logger.isDebugEnabled()) {
			logger.debug("Response exception", result);
		}
		ExceptionView view=new ExceptionView(JSON_UTF8,result);
		ModelAndView mv=new ModelAndView();
		mv.setView(view);
		return mv;
	}
	private String readRequestString(String encoding,InputStream in) throws UnsupportedEncodingException, IOException {
		InputStreamReader reader = new InputStreamReader(in,encoding);
		int len;
		char buffer[] = new char[1024];
		len = reader.read(buffer);
		StringBuffer sb = new StringBuffer();
		while (len != -1) {
			sb.append(buffer, 0, len);
			len = reader.read(buffer);
		}
		String result=sb.toString();
		if(logger.isDebugEnabled()) {
			logger.debug("Request data", result);
		}
		return result;
	}
	private XMLForm getForm(NativeWebRequest webRequest,XMLFormPastport pastport,String formName,Class cls){
		String key=formName!=null?formName:FormFactory.parseFormName(cls);
		Map formMap=(Map)webRequest.getAttribute(XMLFORMS_KEY, RequestAttributes.SCOPE_REQUEST);
		if(formMap==null){
			formMap=new HashMap();
			webRequest.setAttribute(XMLFORMS_KEY, formMap,RequestAttributes.SCOPE_REQUEST);				
		}
		XMLForm xmlform=(XMLForm)formMap.get(key);
		if(xmlform==null){
			xmlform=formName!=null?xmlFormPort.getForm(pastport,formName):xmlFormPort.getForm(pastport,cls);
			formMap.put(key, xmlform);
		}
		return xmlform;
	}
	
	/*
	 * HttpMessageConverter
	 */
	
	@Override
	public boolean canRead(Class cls, MediaType mediaType) {
		Form form=(Form)cls.getAnnotation(Form.class);
		if(form!=null
			||SourceData.class.isAssignableFrom(cls)
//			||SourceDataHolder.class.isAssignableFrom(cls)
			||isSupport(cls)){
			return true;
		}
		return false;
	}

	@Override
	public boolean canWrite(Class cls, MediaType mediaType) {
		Form form=(Form)cls.getAnnotation(Form.class);
		if(form!=null||ResultData.class.isAssignableFrom(cls)
				||XMLFormException.class.isAssignableFrom(cls)
				||ActionException.class.isAssignableFrom(cls)
				||isSupport(cls)){
			return true;
		}
		return false;
	}

	@Override
	public List getSupportedMediaTypes() {
		return supportedMediaTypes;
	}

	@Override
	public Object read(Class cls, HttpInputMessage input) throws IOException, HttpMessageNotReadableException {
		XMLFormPastport pastport=contextPastportCreator.createPastport();
		String requestString=readRequestString("UTF-8",input.getBody());
		DataSource<SourceData> dataSource=null;
		if(this.isXmlMediaType(input.getHeaders().getContentType())) {
			 dataSource=new XMLDataSource(requestString);
		}else {
			dataSource=new JSONDataSource(requestString);			
		}
		
		SourceType sourceType=SourceType.FORM;
		Query query=(Query)cls.getAnnotation(Query.class);
		if(query!=null){
			sourceType=query.value()?SourceType.QUERY:SourceType.FORM;
		}
		SourceData sourceData=xmlFormPort.parseData(pastport, xmlFormPort.getForm(pastport, cls), sourceType, dataSource);
		if(sourceData.getSourceInfos().hasError()){
			throw new XMLFormException(XMLFormException.CE_FORM_DATA,"",sourceData.getSourceInfos().getInvalidForms());
		}
		if(SourceData.class.isAssignableFrom(cls)){
			return sourceData;
//		}else if(SourceDataHolder.class.isAssignableFrom(cls)){
//			SourceDataHolder holder=(SourceDataHolder)BeanUtils.instantiate(cls);
//			holder.setSourceData(sourceData);
//			return holder;
		}else{
			SourceInfos infos = sourceData.getSourceInfos();
			InvalidForm[] invalidForms=null;
			Object readResult=null;
			if(sourceData.getData().size()>0){
				readResult=sourceData.getData().get(0);
				if(readResult instanceof InvalidForm||!XMLFormException.OK.equals(infos.getFaultCode())){
					invalidForms=(InvalidForm[])sourceData.getData().toArray(new InvalidForm[sourceData.getData().size()]);
				}
			}
			if(!XMLFormException.OK.equals(infos.getFaultCode())){
				if(invalidForms==null)
					invalidForms=new InvalidForm[0];
				throw new XMLFormException(infos.getFaultCode(),infos.getFaultString(),invalidForms);
			}
			return readResult;
		}
	}

	@Override
	public void write(Object obj, MediaType mediaType, HttpOutputMessage output) throws IOException, HttpMessageNotWritableException {
		XMLFormPastport pastport=contextPastportCreator.createPastport();
		DataFormat<String> dataFormat=null;
		if(obj instanceof XMLFormException){
			dataFormat=new DataJSONFormat((XMLFormException)obj);
		}else if(obj instanceof ActionException){
			ActionException aex=(ActionException)obj;
			dataFormat=new DataJSONFormat(new XMLFormException(aex.getFaultCode(),aex.getFaultString()));
		}else{
			ResultData resultData=null;
			if(obj==null){
				resultData=new ResultData();
				resultData.setData(new ArrayList(0));
			}else if(obj instanceof ResultData){
				resultData=(ResultData)obj;
				List dataList=resultData.getData();
				int dataSize=dataList.size();
				if(dataSize>0){
					obj=dataList.get(0);
					if(resultData.getResultInfos().getTotalResults()==0){
						resultData.getResultInfos().setTotalResults(dataSize);
					}
				}else{
					obj=null;
				}
			}else{
				resultData=new ResultData();
				resultData.getResultInfos().setTotalResults(1);
				List data=new ArrayList(1);
				data.add(obj);
				resultData.setData(data);
			}
			
			if(resultData.getForm()==null&&obj!=null){
				resultData.setForm(xmlFormPort.getForm(pastport, obj.getClass()));
			}
			
			for(int i=0;i<resultDataPostProcessors.size();i++){
				ResultData newData=resultDataPostProcessors.get(i).postProcessResultData(pastport, resultData);
				if(newData!=null){
					resultData=newData;
				}
			}
			
			String formatVersion=getVersionParameter(mediaType);
			
			if(isXmlMediaType(mediaType)) {
				DataXMLFormat xmlFormat=new DataXMLFormat(resultData);
				xmlFormat.setVersion(formatVersion);
				dataFormat=xmlFormat;
			}else {
				boolean isCompact=false;
				if(JSONConstants.COMPACT.equals(getBodyTypeParameter(mediaType))
					||JSONConstants.COMPACT.equals(getBodyTypeParameter(mediaType))){
					isCompact=true;
				}else if(defaultCompact!=-1) {
					isCompact=resultData.getData().size()>=defaultCompact;
				}
				DataJSONFormat jsonResult = new DataJSONFormat(resultData,isCompact);
				jsonResult.setVersion(formatVersion);
				dataFormat=jsonResult;
			}
		}
		
		String result=xmlFormPort.formatData(pastport, dataFormat);
		output.getHeaders().setContentType(mediaType);
		output.getBody().write(result.getBytes());
	}
	private MediaType getFormatMediaType(NativeWebRequest webRequest) {
		if(contentNegotiationManager!=null) {
			try {
				List<MediaType> types = contentNegotiationManager.resolveMediaTypes(webRequest);
				if(types.size()==0)
					return MediaType.APPLICATION_JSON;
				return types.get(0);
			} catch (HttpMediaTypeNotAcceptableException e) {
				e.printStackTrace();
			}
		}
		List<MediaType> types=null;
		try {
			types=headerContentNegotiationStrategy.resolveMediaTypes(webRequest);
		} catch (HttpMediaTypeNotAcceptableException e) {
			e.printStackTrace();
		}
		if(types==null||types.size()==0)
			return MediaType.APPLICATION_JSON;
		return types.get(0);
	}
	private boolean isXmlMediaType(MediaType mediaType) {
		return (mediaType.getType().equals(MediaType.TEXT_XML.getType())&&mediaType.getSubtype().equals(MediaType.TEXT_XML.getSubtype()))
				||(mediaType.getType().equals(MediaType.APPLICATION_XML.getType())&&mediaType.getSubtype().equals(MediaType.APPLICATION_XML.getSubtype()))
				;
	}
	private boolean isJsonMediaType(MediaType mediaType) {
		return (mediaType.getType().equals(MediaType.APPLICATION_JSON.getType())&&mediaType.getSubtype().equals(MediaType.APPLICATION_JSON.getSubtype()))
				;
	}
	private boolean isXmlMediaType(HttpServletRequest req) {
		String type=req.getContentType();
		if(type==null)
			return false;
		return isXmlMediaType(MediaType.valueOf(type));
	}
	private String getVersionParameter(MediaType mediaType) {
		String ver=mediaType.getParameter("version");
		if(!FormUtils.isEmpty(ver))
			return ver;
		return defaultVersion;
	}
	private String getBodyTypeParameter(MediaType mediaType) {
		String ver=mediaType.getParameter("bodytype");
		if(!FormUtils.isEmpty(ver))
			return ver;
		return null;
	}
	private String getGetParam(HttpServletRequest servletRequest,String key) {
		if(servletRequest==null)
			return null;
		if("GET".equals(servletRequest.getMethod())) {
			String value=servletRequest.getParameter(key);
			if(FormUtils.isEmpty(value))
				return null;
			return value.toLowerCase();
		}
		return null;
	}
	private boolean isSupport(Class cls){
		for(int i=0;i<typeSupporters.size();i++){
			if(typeSupporters.get(i).isSupport(cls))
				return true;
		}
		return false;
	}

	@Override
	public int getOrder() {
		return Ordered.HIGHEST_PRECEDENCE;
	}
}
