/*
 * Decompiled with CFR 0.152.
 */
package net.sf.xmlform.spring.support;

import net.sf.xmlform.XMLFormException;
import net.sf.xmlform.XMLFormPastport;
import net.sf.xmlform.action.Action;
import net.sf.xmlform.config.ConfigurationProvider;
import net.sf.xmlform.config.FormDefinition;
import net.sf.xmlform.config.annotation.FormFactory;
import net.sf.xmlform.data.DataFormat;
import net.sf.xmlform.data.DataSource;
import net.sf.xmlform.data.ResultData;
import net.sf.xmlform.data.SourceData;
import net.sf.xmlform.data.SourceType;
import net.sf.xmlform.form.XMLForm;
import net.sf.xmlform.impl.DefaultConfigurationProvider;
import net.sf.xmlform.impl.XMLFormPortImpl;

public class DynamicFormPort {
    private XMLFormPortImpl xmlFormPort;
    private DefaultConfigurationProvider configurationProvider;
    private String shorthandFieldsPrefix = "!";

    public XMLFormPortImpl getXmlFormPort() {
        return this.xmlFormPort;
    }

    public void setXmlFormPort(XMLFormPortImpl xmlFormPort) {
        ConfigurationProvider provider = xmlFormPort.getConfigurationProvider();
        if (!(provider instanceof DefaultConfigurationProvider)) {
            throw new IllegalArgumentException("XMLFormPortImpl ConfigurationProvider must be DefaultConfigurationProvider");
        }
        this.configurationProvider = (DefaultConfigurationProvider)provider;
        this.xmlFormPort = xmlFormPort;
    }

    public String getShorthandFieldsPrefix() {
        return this.shorthandFieldsPrefix;
    }

    public void setShorthandFieldsPrefix(String shorthandFieldsPrefix) {
        this.shorthandFieldsPrefix = shorthandFieldsPrefix;
    }

    public XMLForm getForm(XMLFormPastport pastport, String formName) {
        return this.doGetForm(pastport, formName, null);
    }

    public XMLForm getForm(XMLFormPastport pastport, Class cls) {
        return this.doGetForm(pastport, FormFactory.parseFormName((Class)cls), cls);
    }

    public <T> T parseData(XMLFormPastport pastport, XMLForm sourceForm, SourceType sourceType, DataSource<T> dataSource) throws XMLFormException {
        return (T)this.xmlFormPort.parseData(pastport, sourceForm, sourceType, dataSource);
    }

    public <T> T formatData(XMLFormPastport pastport, DataFormat<T> format) {
        return (T)this.xmlFormPort.formatData(pastport, format);
    }

    public ResultData submit(XMLFormPastport pastport, Action action, DataSource<? extends SourceData> dataSource) throws XMLFormException {
        return this.xmlFormPort.submit(pastport, action, dataSource);
    }

    private XMLForm doGetForm(XMLFormPastport pastport, String formName, Class cls) {
        FormDefinition def;
        XMLFormPortImpl impl = this.xmlFormPort;
        if (formName.startsWith(this.shorthandFieldsPrefix)) {
            FormDefinition def2 = impl.getConfigurationProvider().getForm(pastport, formName);
            if (def2 == null) {
                this.configurationProvider.addShorthandForm(formName, formName.substring(1));
            }
        } else if (cls != null && (def = impl.getConfigurationProvider().getForm(pastport, formName)) == null) {
            this.configurationProvider.addAnnotatedClass(cls);
        }
        return this.xmlFormPort.getForm(pastport, formName);
    }
}

