package net.sf.xmlform.web;

import java.io.UnsupportedEncodingException;
import java.net.URLEncoder;
import java.util.Locale;

import javax.servlet.ServletContext;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

import net.sf.xmlform.type.BooleanType;
import net.sf.xmlform.type.ByteType;
import net.sf.xmlform.type.DateTimeType;
import net.sf.xmlform.type.DateType;
import net.sf.xmlform.type.DecimalType;
import net.sf.xmlform.type.DoubleType;
import net.sf.xmlform.type.FloatType;
import net.sf.xmlform.type.IType;
import net.sf.xmlform.type.IntType;
import net.sf.xmlform.type.IntegerType;
import net.sf.xmlform.type.LongType;
import net.sf.xmlform.type.ShortType;
import net.sf.xmlform.type.StringType;
import net.sf.xmlform.type.TimeType;
import net.sf.xmlform.type.YearMonthType;
import net.sf.xmlform.util.FormUtils;
import net.sf.xmlform.util.MessageUtil;

public class LocaleValidatorText implements ClassResource {
	public void outputResource(ServletContext servletContext,HttpServletRequest req,HttpServletResponse resp, String param)throws Exception {
		Locale local=FormUtils.parseLocale(param);
		ResourceUtil.outputString(resp,buildAMDValidatorText(local));
	}
	public String buildAMDValidatorText(Locale local){
		StringBuffer sb=new StringBuffer();
		sb.append("(function(global,factory){");
		sb.append("	if (typeof module !== 'undefined' && typeof exports === 'object' && define.cmd) {");
		sb.append("		 ");
		sb.append("		factory(validation);");
		sb.append("	} else if (typeof define === 'function' && define.amd) {");
		sb.append("		require([\"xmlform/validation\"],factory);");
		sb.append("	} else {");
		sb.append("		factory(global.xmlformValidation);");
		sb.append("	}");
		sb.append("})(typeof window!==\"undefined\" ? window:this,function(val){");
		sb.append("t=").append(buildValidatorText(local,true)).append(";");
		sb.append("for(var k in t){val.TypeTextes[k]=t[k];}");
		sb.append("});");
		return sb.toString();
	}
	public String buildValidatorText(Locale local){
		return buildValidatorText(local,false);
	}
	public String buildValidatorText(Locale local,boolean useDecode){
		StringBuffer sb=new StringBuffer("{");
		addText(local,useDecode,sb,"required",MessageUtil.getMessage(local,IType.class,IType.VALUE_REQUIRED,new String[]{}));
		addText(local,useDecode,sb,"occurs.size",MessageUtil.getMessage(local,IType.class,IType.VALUE_OCCURS_SIZE,new String[]{"{0}"}));
		addText(local,useDecode,sb,"occurs.range",MessageUtil.getMessage(local,IType.class,IType.VALUE_OCCURS_RANG,new String[]{"{0}","{1}"}));
		addText(local,useDecode,sb,"occurs.min",MessageUtil.getMessage(local,IType.class,IType.VALUE_OCCURS_MIN,new String[]{"{0}"}));
		addText(local,useDecode,sb,"occurs.max",MessageUtil.getMessage(local,IType.class,IType.VALUE_OCCURS_MAX,new String[]{"{0}"}));
		addText(local,useDecode,sb,"unique",MessageUtil.getMessage(local,IType.class,IType.VALUE_UNIQUE,new String[]{"{0}"}));

		addText(local,useDecode,sb,BooleanType.NAME,MessageUtil.getMessage(local,IType.class,IType.VALUE_ENUM,new String[]{"true,false"}));
		addText(local,useDecode,sb,ByteType.NAME,MessageUtil.getMessage(local,IType.class,IType.VALUE_INTEGER,new String[]{}));
		addText(local,useDecode,sb,DateTimeType.NAME,MessageUtil.getMessage(local,IType.class,IType.VALUE_DATETIME,new String[]{}));
		addText(local,useDecode,sb,DateType.NAME,MessageUtil.getMessage(local,IType.class,IType.VALUE_DATE,new String[]{}));
		addText(local,useDecode,sb,DecimalType.NAME,MessageUtil.getMessage(local,IType.class,IType.VALUE_DECIMAL,new String[]{}));
		addText(local,useDecode,sb,DoubleType.NAME,MessageUtil.getMessage(local,IType.class,IType.VALUE_DECIMAL,new String[]{}));
		addText(local,useDecode,sb,FloatType.NAME,MessageUtil.getMessage(local,IType.class,IType.VALUE_DECIMAL,new String[]{}));
		addText(local,useDecode,sb,IntegerType.NAME,MessageUtil.getMessage(local,IType.class,IType.VALUE_INTEGER,new String[]{}));
		addText(local,useDecode,sb,IntType.NAME,MessageUtil.getMessage(local,IType.class,IType.VALUE_INTEGER,new String[]{}));
		addText(local,useDecode,sb,LongType.NAME,MessageUtil.getMessage(local,IType.class,IType.VALUE_INTEGER,new String[]{}));
		addText(local,useDecode,sb,ShortType.NAME,MessageUtil.getMessage(local,IType.class,IType.VALUE_INTEGER,new String[]{}));
		addText(local,useDecode,sb,StringType.NAME,"");
		addText(local,useDecode,sb,TimeType.NAME,MessageUtil.getMessage(local,IType.class,IType.VALUE_TIME,new String[]{}));
		addText(local,useDecode,sb,YearMonthType.NAME,MessageUtil.getMessage(local,IType.class,IType.VALUE_YEARMONTH,new String[]{}));
		sb.append("\"author\":\"Liu Zhikun\"}");
		return sb.toString();
	}
	private void addText(Locale local,boolean useDe,StringBuffer sb,String name,String text){
		if(useDe){
			sb.append("\"").append(name).append("\":").append(encodeText(text)).append(",");
		}else{
			sb.append("\"").append(name).append("\":\"").append(text.replace("\"", "\\\"")).append("\",");
		}
	}
	protected String encodeText(String text){
		try {
			return "decodeURIComponent(\""+URLEncoder.encode(text, "UTF-8")+"\").replace(/\\+/g,\" \")";
		} catch (UnsupportedEncodingException e) {
			e.printStackTrace();
			return "\""+e.getMessage()+"\"";
		}
	}

}
