package net.sf.xmlform.web;

import java.io.ByteArrayInputStream;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Map;

import javax.servlet.ServletContext;
import javax.servlet.ServletOutputStream;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpSession;

import net.sf.xmlform.util.MapMessageParameters;
import net.sf.xmlform.util.MessageParameters;


public class ResourceUtil {
	static public void outputResource(HttpServletResponse resp,String param)throws Exception{
		StringBuffer sb=new StringBuffer();
		String parts[]=param.split(":");
		String params[]=parts[1].split(",");
		Class c=Class.forName(parts[0]);
		for(int j=0;j<params.length;j++){
			if(params[j].length()>0){
				InputStream is=c.getResourceAsStream(params[j]);
				if(is==null)
					System.out.println("Not found resource: "+params[j]+" in "+param);
				else{
					writeStream(resp,is);
					is.close();
				}
			}
		}
		outputInline(resp,sb.toString());
	}
	static public void outputFile(HttpServletResponse resp,String file)throws Exception{
		FileInputStream fis=new FileInputStream(file);
		writeStream(resp,fis);
		fis.close();
	}
	static public void outputClass(ServletContext servletContext,HttpServletRequest req,HttpServletResponse resp,String className)throws Exception{
		String clazz=className;
		String param="";
		if(clazz.indexOf(":")>0){
			param=clazz.substring(clazz.indexOf(":")+1);
			clazz=clazz.substring(0,clazz.indexOf(":"));
		}
		ClassResource cla;
		cla = (ClassResource)Class.forName(clazz).newInstance();
		cla.outputResource(servletContext,req,resp,param);
		resp.getOutputStream().flush();
	}
	static public void outputInline(HttpServletResponse resp,String script)throws Exception{
		outputString(resp,script);
	}
	static public void outputString(HttpServletResponse resp,String script)throws Exception{
		ByteArrayInputStream sb=new ByteArrayInputStream(script.getBytes("UTF-8"));
		writeStream(resp,sb);
		sb.close();
	}
	static private void writeStream(HttpServletResponse resp,InputStream is) throws IOException{
		if(is==null)
			return;
		ServletOutputStream out=resp.getOutputStream();
		byte buf[]=new byte[1024];
		int len;
		len=is.read(buf);
		while(len>0){
			out.write(buf,0,len);
			len=is.read(buf);
		}
		out.flush();
	}
	static public RequestMessageParameters getCommonParameters(ServletContext servletContext,HttpServletRequest req){
		return new RequestMessageParameters(servletContext,req);
	}
}
