(function(c, b) {
    if (typeof module !== "undefined" && typeof exports === "object" && define.cmd) {
        var a = require("./validation.js");
        var e = require("./expression.js");
        var d = require("./format.js");
        module.exports = b(e, a, d);
    } else {
        if (typeof define === "function" && define.amd) {
            define("xmlform/model", ["xmlform/expression", "xmlform/validation", "xmlform/format"], b);
        } else {
            c.xmlformModel = b(c.xmlformExpression, c.xmlformValidation, c.xmlformFormat);
        }
    }
})(typeof window !== "undefined" ? window: this,
function(f, e, c) {
    var d = {};
    d.isDebug = function() {
        return true;
    };
    var b = 0;
    var g = {
        isNull: function(h) {
            if (h == null || h.length == 0) {
                return true;
            }
            return false;
        },
        attrValue: function(j, h, i) {
            if (typeof(j[h]) == "undefined") {
                return i;
            }
            return j[h];
        },
        trimStr: function(h) {
            if (h == null) {
                return null;
            }
            return ("" + h).replace(/(^\s*)(\s*$)/g, "");
        },
        hasAttr: function(i, h) {
            if (typeof(i[h]) != "undefined") {
                return true;
            }
            return false;
        },
        isFunction: function(h) {
            return e.isFunction(h);
        },
        isString: function(h) {
            return e.isString(h);
        },
        isArray: function(h) {
            return e.isArray(h);
        },
        isObject: function(h) {
            return e.isObject(h);
        },
        isVt: function(h) {
            return h != null && e.isObject(h) && h["@type"] && h["@type"] == "vt";
        },
        _nextRecordId: function() {
            return "C" + (b++);
        }
    };
    d.Util = g;
    d.XmlformRecordSet = function(h) {
        this._form = null;
        this._records = [];
        this._recordMap = {};
        this._removedRecords = {};
        this._selectedRecords = [];
        this._envs = {};
        this._totalresults = 0;
        this._firstresult = 0;
        this._maxresults = 0;
        this._fieldDefaultValue = {};
        this._fieldLastValue = {};
        this._summary = "";
        this._parent = null;
        this._inInsert = false;
        this._isSingle = false;
        this._errorText = null;
        this._hasCheck = false;
        this._checkResult = true;
        this._events = new EventSupport();
        this.getParent = function() {
            return this._parent;
        };
        this.getData = function(j) {
            var i = this._getData(true, j);
            var k = {
                version: "2.0",
                head: {
                    firstresult: 0,
                    maxresults: 2147483647,
                    totalresults: i.data.length,
                    faultcode: "ok",
                    bodytype: "flat"
                },
                body: i.data
            };
            return k;
        };
        this.getValue = function() {
            var k = [];
            for (var j = 0; j < this._records.length; j++) {
                if (this._records[j].getStatus() != "t") {
                    k.push(this._records[j].getValue());
                }
            }
            return k;
        };
        this._getData = function(l, k) {
            var w = function(i) {
                return i.record.getStatus() != "t";
            };
            var t = this._fieldNames.slice(0);
            if (k) {
                if (k.fields) {
                    t = k.fields;
                    if (t[0] == "-") {
                        var o = t;
                        var u = {};
                        t = [];
                        for (var r = 1; r < o.length; r++) {
                            u[o[r]] = true;
                        }
                        for (var m = 0; m < this._fieldNames.length; m++) {
                            if (!u[this._fieldNames[m]]) {
                                t.push(this._fieldNames[m]);
                            }
                        }
                    }
                }
                if (k.match) {
                    w = k.match;
                }
            }
            var q = [];
            if (l == true) {
                for (var v in this._removedRecords) {
                    q.push(this._removedRecords[v]._getData(l, t));
                }
            }
            for (var p = 0; p < this._records.length; p++) {
                if (w({
                    record: this._records[p]
                })) {
                    q.push(this._records[p]._getData(l, t));
                }
            }
            var s = {
                data: q
            };
            if (this._parent && this._subform.summary) {
                s.summary = this._summary;
            }
            return s;
        };
        this.setData = function(j) {
            if (j.head.faultcode != "ok") {
                this._setDataError(j);
            } else {
                if (g.hasAttr(j.head, "totalresults")) {
                    this._totalresults = j.head.totalresults;
                }
                if (g.hasAttr(j.head, "firstresult")) {
                    this._firstresult = j.head.firstresult;
                }
                if (g.hasAttr(j.head, "maxresults")) {
                    this._maxresults = j.head.maxresults;
                }
                if (g.hasAttr(j.head, "bodytype") && j.head.bodytype != "flat") {
                    throw new Error("Only support bodytype: flat");
                }
                var i = j.body;
                if (i != null && g.isArray(i) == false) {
                    i = [i];
                }
                this._set2Value({
                    value: i,
                    attachments: j.attachments,
                    insertone: true,
                    dataopts: {
                        defaultStatus: "p"
                    }
                });
                this._setParentModified();
            }
        };
        this.setValue = function(i) {
            this._setValue({
                value: i
            });
            this._setParentModified();
        };
        this.setFieldValue = function(n, l) {
            if (!l) {
                l = "";
            } else {
                if (e.isArray(l)) {
                    for (var j = 0; j < l.length; j++) {
                        if (!l[j]) {
                            l[j] = "";
                        }
                    }
                }
            }
            this._fieldDefaultValue[n] = l;
            for (var k = 0; k < this._records.length; k++) {
                var m = this._records[k].getField(n);
                if (m != null) {
                    m.setValue(l);
                }
            }
            if (this._records.length > 0) {
                this._setParentModified();
            }
        };
        this.setEnvValue = function(i, j) {
            this._envs[i] = j;
            this._updateRefEnv(this._records, false, {
                getName: function() {
                    return "$env." + i;
                },
                getValue: function() {
                    return j;
                }
            });
        };
        this._setValue = function(i) {
            this._set2Value({
                value: i.value,
                forms: i.forms,
                attachments: i.attachments,
                insertone: false,
                dataopts: i.dataopts
            });
        };
        this._set2Value = function(l) {
            var v = l.value,
            p = l.attachments,
            t = l.insertone,
            u = l.dataopts;
            if (v == null) {
                return;
            }
            var m = {};
            if (p && p.xmlform) {
                m = p;
                this._setRootForm(p.xmlform);
                this._initFieldNames();
            }
            this._events.setPause(true);
            this._cleanRemovedRecords();
            this._removeAllRs();
            var o = [];
            if (v) {
                for (var q = 0; q < v.length; q++) {
                    var s = this._insertRecord({
                        siblingid: null,
                        dataopts: u,
                        value: {
                            values: v[q]
                        }
                    });
                    o.push(s);
                }
            }
            for (var n = 0; n < o.length; n++) {
                var i = o[n];
                if (i.getStatus() == "r") {
                    i.remove();
                }
            }
            this._selectedRecords = [];
            if (t) {
                this.insertTransient();
                this._doModified(false);
                this._hasCheck = false;
                this._checkResult = true;
            }
            this._selectFirst();
            this._events.setPause(false);
            this._sendUpdateEvent(m);
        };
        this.beginBatchUpdate = function() {
            this._inBatch = {};
            this._events.setPause(true);
        };
        this.endBatchUpdate = function() {
            for (var i in this._inBatch) {
                this._inBatch[i]();
            }
            this._inBatch = null;
            this._events.setPause(false);
            this._sendUpdateEvent({});
        };
        this._setParentModified = function() {
            if (this.getParent() != null) {
                this._parent._onFieldUpdate(this.getName(), this, this.isValid(), this.getName(), this, false);
            }
        };
        this.sortRecords = function(i) {
            this._records.sort(i);
            this._sendUpdateEvent({});
        };
        this.reset = function() {
            this._totalresults = 0;
            this._firstresult = 0;
            this._set2Value({
                value: [],
                attachments: null,
                insertone: true
            });
            this._setParentModified();
        };
        this._removeAllRs = function() {
            var k = [];
            for (var m = 0; m < this._records.length; m++) {
                k.push(this._records[m]);
            }
            for (var l = 0; l < k.length; l++) {
                k[l].destroy();
            }
            this._records = [];
            this._recordMap = {};
        };
        this._cleanRemovedRecords = function() {
            for (var j in this._removedRecords) {
                this._removedRecords[j].destroy();
            }
            this._removedRecords = {};
        };
        this._setDataError = function(i) {
            if (i.body) {
                this._setError(i.body);
            }
            this._doSetInvalid(false, i.faultstring && i.faultstring.length > 0 ? i.faultstring: null);
        };
        this._setError = function(m) {
            for (var k = 0; k < m.length; k++) {
                var l = m[k];
                var j = this.getRecord(l["@id"]);
                if (j == null) {
                    j = this._searchRecord(l["@id"]);
                }
                if (j != null) {
                    j._setError(l);
                }
            }
        };
        this._setInvalid = function(i) {
            this._doSetInvalid(i == null, i);
        };
        this._doSetInvalid = function(i, j) {
            this._errorText = j;
            this._events.dispatchEvent(this, {
                type: "valid",
                recordSet: this,
                oldValue: true,
                newValue: i,
                invalidText: j
            });
            if (this._parent) {
                this._sendTopEvent({
                    type: "fieldValid",
                    field: this,
                    oldValue: true,
                    newValue: i,
                    invalidText: j
                });
            } else {
                this._sendTopEvent({
                    type: "recordSetValid",
                    recordSet: this,
                    oldValue: true,
                    newValue: i,
                    invalidText: j
                });
            }
        };
        this._searchRecord = function(o) {
            if (g.hasAttr(this._recordMap, o)) {
                return this._recordMap[o];
            }
            for (var n = 0; n < this._records.length; n++) {
                var k = this._records[n].getFields();
                for (var m = 0; m < k.length; m++) {
                    if (k[m].getModelType() != "recordset") {
                        continue;
                    }
                    var l = k[m]._searchRecord(o);
                    if (l != null) {
                        return l;
                    }
                }
            }
            return null;
        };
        this.getModelType = function() {
            return "recordset";
        };
        this.getName = function() {
            if (this._subform) {
                return this._subform.name;
            }
            return null;
        };
        this.getLabel = function() {
            if (this._subform) {
                return this._subform.label;
            } else {
                return this.getName();
            }
        };
        this.getInvalidText = function() {
            return this._errorText;
        };
        this.getInvalidFields = function() {
            var i = [];
            this._getInvalidFields(this, i);
            return i;
        };
        this.getTotalResults = function() {
            return this._parent == null ? this._totalresults: this._records.length;
        };
        this.getFirstResult = function() {
            return this._parent == null ? this._firstresult: 0;
        };
        this.getMaxResults = function() {
            return this._parent == null ? this._maxresults: 0;
        };
        this.setMaxResults = function(i) {
            this._maxresults = i;
        };
        this.getRecords = function() {
            return [].concat(this._records);
        };
        this.getRecordCount = function() {
            return this._records.length;
        };
        this.getRecord = function(i) {
            if ((typeof i) == "number") {
                if (i >= 0 && i < (this._records.length - 1)) {
                    return this._records[i];
                }
                return null;
            }
            if (g.hasAttr(this._recordMap, i)) {
                return this._recordMap[i];
            }
            return null;
        };
        this.getRecordField = function(i) {
            var j = this.getRecordFields(i);
            if (j.length > 0) {
                return j[0];
            }
            return null;
        };
        this.getRecordFields = function(i) {
            var j = [];
            this._getRecordOrFields(this, i, j, 0);
            return j;
        };
        this.getSelectedRecords = function() {
            return [].concat(this._selectedRecords);
        };
        this.getSummary = function() {
            return this._summary;
        };
        this.getMinOccurs = function() {
            return this._min;
        };
        this.getMaxOccurs = function() {
            return this._max;
        };
        this.insertTransient = function() {
            if (this._hasTransient() == true) {
                this._selectFirst();
                return null;
            }
            var i = null;
            if (this.isInsertable() == true) {
                i = this.insert();
            }
            return i;
        };
        this._selectFirst = function() {
            if (this._selectedRecords.length == 0 && this._records.length > 0 && this._isAutoSelect()) {
                this._records[0].setSelected(false);
                this._records[0].setSelected(true);
            }
        };
        this._hasTransient = function() {
            for (var j = this._records.length - 1; j >= 0; j--) {
                if (this._records[j].getStatus() == "t") {
                    return true;
                }
            }
            return false;
        };
        this.insert = function(i) {
            return this._insertRecord({
                siblingid: i
            });
        };
        this._insertRecord = function(j) {
            var l = j.siblingid,
            n = j.value,
            r = j.dataopts;
            if (this._inInsert == true) {
                return null;
            }
            this._inInsert = true;
            var i = null;
            if (n) {
                i = n;
            } else {
                var q = {};
                for (var m in this._fieldDefaultValue) {
                    q[m] = this._fieldDefaultValue[m];
                }
                for (var m in this._fieldLastValue) {
                    q[m] = this._fieldLastValue[m];
                }
                i = {
                    values: q
                };
            }
            var o = new d.XmlformRecord({
                root: this._root,
                parent: this,
                form: this._form,
                level: this._level,
                value: i,
                dataopts: r
            });
            var p = this._records.length;
            if (l) {
                if (this._recordMap[l]) {
                    p = this._recordMap[l].getIndex();
                }
            }
            if (this.index == this._records.length) {
                this._records.push(o);
            } else {
                this._records.splice(p, 0, o);
            }
            this._recordMap[o.getId()] = o;
            this._events.dispatchEvent(this, {
                type: "insert",
                recordSet: this,
                record: o
            },
            "recordInsert");
            this._resetSummary(o);
            if (this._isSingleRecord() && o.getStatus() == "t") {
                o._doSetStatus("n");
            }
            this._inInsert = false;
            this._selectFirst();
            return o;
        };
        this.isInsertable = function() {
            if (this.isReadonly()) {
                return false;
            }
            var i = 0;
            if (this._level == 0) {
                i = g.attrValue(this._config, "max", 2147483647);
            } else {
                i = this._max;
            }
            if (this._level == 0 && this._records.length >= i) {
                return false;
            }
            return this._isInsertable;
        };
        this._isSingleRecord = function() {
            return this._isSingle;
        };
        this._isAutoSelect = function() {
            var i = this._root._config;
            return g.attrValue(i, "autoselect", true);
        };
        this.remove = function(l) {
            var j = this.getRecords();
            for (var k = 0; k < j.length; k++) {
                if (l(k, j[k])) {
                    j[k].remove();
                }
            }
        };
        this._onRemoveRecord = function(j, k) {
            this._events.dispatchEvent(this, {
                type: "remove",
                recordSet: this,
                record: j
            });
            delete this._recordMap[j.getId()];
            this._records.splice(j.getIndex(), 1);
            if (k) {
                j.destroy();
            } else {
                if (j.getStatus() == "r") {
                    this._removedRecords[j.getId()] = j;
                    if (this._parent) {
                        this._parent._onFieldUpdate(this.getName(), this, this.isValid(), this.getName(), this, false);
                    } else {
                        this._setModified();
                    }
                } else {
                    j.destroy();
                }
            }
            if (this._inBatch) {
                if (!this._inBatch.afterRemove) {
                    var i = this;
                    this._inBatch.afterRemove = function() {
                        i._afterRemoveRecord(null);
                    };
                }
            } else {
                this._afterRemoveRecord(j);
            }
        };
        this._afterRemoveRecord = function(i) {
            this._resetSummary(i);
            this.insertTransient();
        };
        this._sendTopEvent = function(i) {
            if (!i.path) {
                i.path = [];
            }
            i.path.unshift(this);
            if (this._parent) {
                this._parent._sendTopEvent(i);
            } else {
                this._events.dispatchEvent(this, i);
            }
        };
        this._sendUpdateEvent = function(i) {
            this._events.dispatchEvent(this, {
                type: "update",
                recordSet: this,
                attachments: i
            });
            if (this._parent) {
                this._sendTopEvent({
                    type: "fieldUpdate",
                    field: this
                });
            } else {
                this._sendTopEvent({
                    type: "recordSetUpdate",
                    recordSet: this,
                    attachments: i
                });
            }
        };
        this._getRecordIndex = function(j) {
            for (var k = 0; k < this._records.length; k++) {
                if (this._records[k] == j) {
                    return k;
                }
            }
        };
        this._getInvalidFields = function(k, m) {
            k = k.getRecords();
            var o = false;
            for (var l = 0; l < k.length; l++) {
                if (k[l].getStatus() != "t") {
                    var j = k[l].getFields();
                    for (var n = 0; n < j.length; n++) {
                        if (j[n].isValid() == false) {
                            if (j[n].getModelType() == "recordset") {
                                var p = this._getInvalidFields(j[n], m);
                                if (p == false && j[n].getInvalidText() != null) {
                                    m.push(j[n]);
                                    o = true;
                                }
                            } else {
                                m.push(j[n]);
                                o = true;
                            }
                        }
                    }
                }
            }
            return o;
        };
        this._getRecordOrFields = function(q, p, o, l) {
            if ((!p) || p.length == 0) {
                o.push(q);
                return;
            }
            var j = p[l];
            if (g.isFunction(j)) {
                for (var m = 0; m < q._records.length; m++) {
                    var k = q._records[m];
                    var n = j(k) ? k: null;
                    if (n != null) {
                        if (p.length - 1 == l) {
                            o.push(n);
                        } else {
                            if (l < p.length) {
                                this._getRRecordOrFields(n, p, o, l + 1);
                            }
                        }
                    }
                }
            } else {
                for (var m = 0; m < q._records.length; m++) {
                    var n = null,
                    k = q._records[m];
                    if ("*" == j) {
                        n = k;
                    } else {
                        if (">" == j) {
                            if (k.isSelected()) {
                                n = k;
                            }
                        } else {
                            if (e.isString(j)) {
                                if (k.getId() == j) {
                                    n = k;
                                }
                            } else {
                                if (k.getIndex() == j) {
                                    n = k;
                                }
                            }
                        }
                    }
                    if (n != null) {
                        if (p.length - 1 == l) {
                            o.push(n);
                        } else {
                            if (l < p.length) {
                                this._getRRecordOrFields(n, p, o, l + 1);
                            }
                        }
                    }
                }
            }
        };
        this._getRRecordOrFields = function(m, o, l, j) {
            var i = o[j],
            n = null;
            if (g.isFunction(i)) {
                var k = m.getField(o[j]);
                if (k == null) {
                    return;
                }
                n = i(k) ? k: null;
            } else {
                n = m.getField(o[j]);
            }
            if (n == null) {
                return;
            }
            if (o.length - 1 == j) {
                l.push(n);
            } else {
                if (j < o.length && n.getModelType() == "recordset") {
                    this._getRecordOrFields(n, o, l, j + 1);
                }
            }
        };
        this._resetSummary = function(k) {
            if (this._parent) {} else {
                return;
            }
            if (k != null && k.getStatus() == "t") {
                return;
            }
            var o = "";
            if (this._subform.summary && this._subform.summary.exp) {
                o = this._root._expression.evaluate(this._parent, this, this._subform.summary.exp).getValue();
            } else {
                var l = this._records;
                var j = l.length;
                var n = 0;
                for (var m = 0; m < j; m++) {
                    if (l[m].getStatus() != "t") {
                        n++;
                    }
                }
                o = n;
            }
            this._summary = o;
            this._events.dispatchEvent(this, {
                type: "summary",
                record: this._parent,
                recordSet: this,
                value: this._summary
            });
            if (this._parent) {
                this._sendTopEvent({
                    type: "fieldSummary",
                    record: this._parent,
                    field: this,
                    value: this._summary
                });
            }
        };
        this._onRecordUpdate = function(i, j, l, k) {
            this._hasCheck = false;
            if (j) {
                this._resetSummary(i);
                this._setModified();
            }
            if (this._parent) {} else {
                return;
            }
            this._parent._onFieldUpdate(this.getName(), this, j, this.getName() + "." + l, k, false);
        };
        this._onDependUpdate = function(j, k, i) {
            var l = this._subform._dependItems;
            if (l.minoccurs[j] || l.maxoccurs[j]) {
                this._reevalMinMax();
            }
            this._reevalUpdatable();
        };
        this._onRecordInvalid = function(i) {
            this._hasCheck = false;
            if (this._parent) {
                this._parent._onFieldInvalid(this);
            }
        };
        this._onFieldLastValue = function(i, j) {
            this._fieldLastValue[i] = j;
        };
        this._updateRefEnv = function(l, u, t) {
            var w = null;
            for (var n = 0; n < l.length; n++) {
                var q = l[n];
                if (w == null) {
                    if (q._config.form._dependEnv) {
                        w = q._config.form._dependEnv;
                    } else {
                        w = [];
                    }
                }
                if (w.length > 0) {
                    for (var v = 0; v < w.length; v++) {
                        var k = q.getField(w[v]);
                        if (k) {
                            k._onDependUpdate(t.getName(), t, u);
                        }
                    }
                }
                for (var p = 0; p < q._fields.length; p++) {
                    var s = q._fields[p];
                    if (s.getModelType() == "recordset") {
                        var o = s.getRecords();
                        for (var j = 0; j < o.length; j++) {
                            this._updateRefEnv(o[j], u, t);
                        }
                    }
                }
            }
        };
        this.addListener = function(i, j) {
            return this._events.addListener(i, j);
        };
        this.removeListener = function(j, i) {
            this._events.removeListener(j, i);
        };
        this._addExpression = function(p) {
            var m = this._root._config.xmlform.expressions;
            if (!m[p.expression]) {
                if (!p.ast) {
                    throw new Error("Must provide ast");
                }
                m[p.expression] = p.ast;
            }
            var j = p.form;
            if (!j) {
                j = this._root._config.xmlform.name;
            }
            var l = this._getForm(j);
            var n = l._dependItems.watchexpr;
            var q = this._root._expression.getDepends(p.expression, "field");
            for (var i = 0; i < q.length; i++) {
                var o = q[i];
                if (!n[o]) {
                    n[o] = {};
                }
                n[o][p.expression] = true;
            }
            return "NotUse";
        };
        this.getConfig = function() {
            return this._form;
        };
        this.isModified = function() {
            return this._root._isModified;
        };
        this.isValid = function() {
            return this._checkValue();
        };
        this.isReadonly = function() {
            var i = this._root._config;
            var k = g.attrValue(i, "insertable", true);
            var j = g.attrValue(i, "modifiable", g.attrValue(i, "updatable", true));
            var l = g.attrValue(i, "removable", g.attrValue(i, "deletable", true));
            return k == false && j == false && l == false;
        };
        this._checkValue = function() {
            if (this._hasCheck) {
                return this._checkResult;
            }
            this._hasCheck = true;
            e.Validator.checkSubform(this);
            if (this._errorText != null) {
                this._checkResult = false;
                return false;
            }
            var l = true;
            for (var k = 0; k < this._records.length; k++) {
                var j = this._records[k];
                if (j.getStatus() != "t" && j._checkValue() == false) {
                    l = false;
                }
            }
            this._checkResult = l;
            return l;
        };
        this._getForm = function(i) {
            var j = this._root;
            if (j._xmlform.forms[i]) {
                if (j._xmlform.forms[i]["_affectItems"]) {} else {
                    j._initFormField(j._xmlform.forms[i]);
                }
                return j._xmlform.forms[i];
            }
            throw new Error("Not found form definition for : " + i);
        };
        this._initFormField = function(l) {
            var C = {},
            j = {};
            l._dependItems = {
                severity: C,
                removable: j,
                watchexpr: {}
            };
            l._dependEnv = {};
            l._dependRoot = {};
            l._dependParent = {};
            l._affectItems = {};
            var q = {
                env: true,
                root: true,
                parent: true
            },
            M = {
                env: false,
                root: false,
                parent: false
            };
            if (l.severity) {
                var n = this._root._expression.getDepends(l.severity.exp, "field");
                for (var B = 0; B < n.length; B++) {
                    C[n[B]] = "field";
                }
            }
            if (l.removable) {
                var m = this._root._expression.getDepends(l.removable, "field");
                for (var u = 0; u < m.length; u++) {
                    j[m[u]] = "field";
                }
            }
            var y = l.fields;
            for (var w in y) {
                y[w]["_dependItems"] = {
                    "default": {},
                    reference: {},
                    check: {},
                    readonly: {},
                    required: {}
                };
            }
            y = l.subforms;
            for (var J in y) {
                y[J]["_dependItems"] = {
                    insertable: {},
                    minoccurs: {},
                    maxoccurs: {}
                };
            }
            if (this.isReadonly() == true) {
                return;
            }
            y = l.fields;
            for (var s in y) {
                var I = y[s];
                if (I["default"]) {
                    this._createDepends(l, I, "default", I["default"]["value"], M);
                }
                if (I.reference && I.reference["arguments"]) {
                    var E = I.reference["arguments"];
                    for (var x in E) {
                        if (E[x]["field"]) {
                            this._createDepend(l, I, "reference", [E[x]["field"]], q);
                        }
                    }
                }
                if (I.checks) {
                    var t = I.checks;
                    for (var D = 0; D < t.length; D++) {
                        this._createDepends(l, I, "check", t[D]["exp"], M);
                    }
                }
                this._createDepends(l, I, "readonly", I.readonly, M);
                this._createDepends(l, I, "required", I.required, M);
            }
            y = l.subforms;
            for (var p in y) {
                var I = y[p];
                this._createDepends(l, I, "insertable", I.insertable, M);
                this._createDepends(l, I, "minoccurs", I.minoccurs, M);
                this._createDepends(l, I, "maxoccurs", I.maxoccurs, M);
            }
            var K = [];
            for (var H in l._dependEnv) {
                K.push(H);
            }
            if (K.length == 0) {
                delete l._dependEnv;
            } else {
                l._dependEnv = K;
            }
            var z = [];
            for (var G in l._dependRoot) {
                z.push(G);
            }
            if (z.length == 0) {
                delete l._dependRoot;
            } else {
                l._dependRoot = z;
            }
            var A = [];
            for (var F in l._dependParent) {
                A.push(F);
            }
            if (A.length == 0) {
                delete l._dependParent;
            } else {
                l._dependParent = A;
            }
            var L = l._affectItems;
            for (var v in L) {
                var o = [];
                for (var u in L[v]) {
                    o.push(u);
                }
                L[v] = o;
            }
        };
        this._createDepends = function(l, k, j, i, m) {
            if (!i) {
                return;
            }
            var n = this._root._expression.getDepends(i, "field");
            this._createDepend(l, k, j, n, m);
        };
        this._createDepend = function(m, l, j, q, p) {
            for (var i = 0; i < q.length; i++) {
                var o = q[i];
                l._dependItems[j][o] = "field";
                if (p.env && o.indexOf("$env.") == 0) {
                    m._dependEnv[l.name] = "field";
                    continue;
                }
                if (p.root && o.indexOf("$root.") == 0) {
                    m._dependRoot[l.name] = "field";
                    continue;
                }
                if (p.parent && o.indexOf("$parent.") == 0) {
                    m._dependParent[l.name] = "field";
                    continue;
                }
                if (d.isDebug()) {
                    var n = this._createDependCheckField(m, o.split("."), 0);
                    if (n == null) {
                        throw new Error("Not found field " + o + " in form " + m.name);
                    }
                }
                if (!m._affectItems[o]) {
                    m._affectItems[o] = {};
                }
                m._affectItems[o][l.name] = "field";
            }
        };
        this._createDependCheckField = function(k, l, i) {
            if (i == l.length - 1) {
                return this._getField(k, l[i]);
            }
            var j = this._getSubform(k, l[i]);
            if (j == null) {
                return null;
            }
            return this._createDependCheckField(this._getForm(j.form), l, i + 1);
        };
        this._getDependItems = function(j, k) {
            var i = this._getField(j, k);
            if (i == null) {
                i = this._getSubform(j, k);
            }
            return i._dependItems;
        };
        this._getAffectItems = function(i, j) {
            if (i._affectItems[j]) {
                return i._affectItems[j];
            }
            return [];
        };
        this._doOffline = function() {
            for (var j = 0; j < this._records.length; j++) {
                this._records[j]._doOffline();
            }
            this._events.clear();
        };
        this._reevalMinMax = function() {
            if (this.getParent() == null) {
                var i = this._root._config;
                this._min = g.attrValue(i, "min", 0);
                this._max = g.attrValue(i, "max", 2147483647);
            } else {
                this._min = parseInt(this._root._expression.evaluate(this._parent, this, this._subform.minoccurs).getValue(), 10);
                this._max = parseInt(this._root._expression.evaluate(this._parent, this, this._subform.maxoccurs).getValue(), 10);
            }
        };
        this._reevalUpdatable = function() {
            if (this.getParent() == null) {
                return;
            }
            var i = this._isInsertable,
            j = this._isUpdatable;
            this._isInsertable = this._root._expression.evaluate(this._parent, this, this._subform.insertable).getValue() == 1 ? true: false;
        };
        this._onRecordStatus = function(j, i, k) {
            if (this._hasTransient() == false && i == "t" && k == "n" && this.isInsertable()) {
                this._insertRecord({
                    siblingid: "-"
                });
                this._setModified();
            }
            if (i == "p" && k == "m") {
                this._setModified();
            }
        };
        this._setModified = function() {
            this._doModified(true);
        };
        this._doModified = function(j) {
            var i = this._root._isModified;
            this._root._isModified = j;
            if (this._root == this) {
                this._events.dispatchEvent(this, {
                    type: "recordSetModified",
                    recordSet: this,
                    oldValue: i,
                    newValue: j
                });
            }
        };
        this._getField = function(i, j) {
            if (i.fields[j]) {
                return i.fields[j];
            }
            return null;
        };
        this._getSubform = function(i, j) {
            if (i.subforms[j]) {
                return i.subforms[j];
            }
            return null;
        };
        this.destroy = function() {
            this._removeAllRs();
            this._cleanRemovedRecords();
            this._events.clear();
            this._events = null;
            this._records = [];
            this._recordMap = {};
            this._removedRecords = {};
            this._selectedRecords = [];
            this._config = null;
            this._root = null;
        };
        this._initFieldNames = function() {
            this._fieldNames = ["@id", "@status"];
            var i = this._form.fields;
            for (var j in i) {
                this._fieldNames.push(i[j].name);
            }
            i = this._form.subforms;
            for (var j in i) {
                this._fieldNames.push(i[j].name);
            }
        };
        this._setRootForm = function(i) {
            this._expression = new f.Expression(i.expressions);
            this._xmlform = i;
            this._form = this._getForm(this._xmlform.name);
            this._config.xmlform = i;
        };
        this._calSingle = function() {
            if (this._level > 0) {
                return;
            }
            var i = this._root._config;
            if (g.hasAttr(i, "min") && g.hasAttr(i, "max") && i.min == 1 && i.max == 1) {
                this._isSingle = true;
            }
        };
        this._init = function(i) {
            if (i) {} else {
                throw new Error("Not provide parameter for XmlformRecordSet");
            }
            this._errorText = null;
            if (i.__inner__) {
                this._subform = i.subform;
                this._root = i.root;
                this._parent = i.parent;
                this._level = i.level;
                this._form = i.form;
                this._initFieldNames();
                this._calSingle();
                if (g.hasAttr(i, "value")) {
                    var j = {
                        value: i.value.value,
                        forms: null,
                        dataopts: {}
                    };
                    if (i.value.forms) {
                        j.forms = i.value.forms;
                    }
                    if (i.dataopts) {
                        j.dataopts = i.dataopts;
                    }
                    this._setValue(j);
                    delete i.value;
                }
                this._reevalUpdatable();
            } else {
                if (i.xmlform) {} else {
                    throw new Error("Not found parameter xmlformForm");
                }
                this._config = i;
                this._root = this;
                this._level = 0;
                this._isModified = false;
                this._isInsertable = g.attrValue(i, "insertable", true);
                this._isUpdatable = g.attrValue(i, "updatable", true);
                this._calSingle();
                this._setRootForm(i.xmlform);
                this._initFieldNames();
            }
            this._reevalMinMax();
        };
        this._init(h);
    };
    d.XmlformRecord = function(h) {
        this._config = h;
        this._fields = [];
        this._fieldMap = {};
        this._id = "";
        this._status = "t";
        this._selected = false;
        this._hasCheck = false;
        this._checkResult = true;
        this._severity = [null, null];
        this._events = new EventSupport();
        this.getId = function() {
            return this._id;
        };
        this.getValue = function() {
            var l = {
                "@id": this._id,
                "@status": this._status
            };
            var j = this._fields;
            for (var k = 0; k < j.length; k++) {
                l[j[k].getName()] = j[k].getValue(true);
            }
            return l;
        };
        this._getData = function(k, j) {
            var o = {};
            if (j) {
                for (var m = 0; m < j.length; m++) {
                    var l = j[m];
                    if (l == "@id") {
                        o[l] = this._id;
                    } else {
                        if (l == "@status") {
                            o[l] = this._status;
                        } else {
                            if (this._fieldMap[l]) {
                                o[l] = this._fieldMap[l]._getData(k);
                            } else {
                                if (d.isDebug()) {
                                    throw new Error('Not found field "' + j[m] + '" in ' + this._config.form.name);
                                }
                            }
                        }
                    }
                }
            } else {
                o["@id"] = this._id;
                o["@status"] = this._status;
                for (var m = 0; m < this._fields.length; m++) {
                    var n = this._fields[m];
                    o[n.getName()] = n._getData(k);
                }
            }
            return o;
        };
        this.setValue = function(m) {
            var k = this._status;
            var j = this._fields;
            if (m["@status"]) {
                k = m["@status"];
            }
            for (var l = 0; l < j.length; l++) {
                if (m[j[l].getName()]) {
                    j[l].setValue(m[j[l].getName()]);
                }
            }
            this._doSetStatus(k);
        };
        this._checkValue = function() {
            if (this._hasCheck) {
                return this._checkResult;
            }
            var k = true;
            for (var j = 0; j < this._fields.length; j++) {
                if (this._fields[j]._checkValue() == false) {
                    k = false;
                }
            }
            this._hasCheck = true;
            this._checkResult = k;
            return k;
        };
        this.getStatus = function() {
            return this._status;
        };
        this.getFields = function() {
            return this._fields;
        };
        this.getField = function(i) {
            return this._fieldMap[i];
        };
        this.getModelType = function() {
            return "record";
        };
        this.getIndex = function() {
            return this._recordSet._getRecordIndex(this);
        };
        this.getSeverity = function() {
            return [this._severity[0], this._severity[1]];
        };
        this.isSelected = function() {
            return this._selected;
        };
        this.setSelected = function(m) {
            if (this._selected == m) {
                return;
            }
            var k = this._recordSet._selectedRecords;
            var j = -1;
            for (var l = 0; l < k.length; l++) {
                if (this == k[l]) {
                    j = l;
                    break;
                }
            }
            if (m == true && j == -1) {
                k.push(this);
            } else {
                if (m == false && j >= 0) {
                    k.splice(j, 1);
                }
            }
            this._selected = m;
            this._events.dispatchEvent(this, {
                type: "select",
                record: this,
                select: m
            },
            "recordSelect");
            this._recordSet._events.dispatchEvent(this, {
                type: "select",
                recordSet: this._recordSet,
                record: this,
                select: m
            });
        };
        this.getParent = function() {
            return this._config.parent;
        };
        this.remove = function(j) {
            this.setSelected(false);
            var i = this._status;
            if (this._status == "p" || this._status == "m") {
                i = "r";
            }
            this._status = i;
            this._events.dispatchEvent(this, {
                type: "remove",
                record: this
            },
            "recordRemove");
            this._doOffline();
            this._recordSet._setModified();
            this._recordSet._onRemoveRecord(this, j);
        };
        this._doOffline = function() {
            for (var j = 0; j < this._fields.length; j++) {
                this._fields[j]._doOffline();
            }
            this._events.clear();
        };
        this._sendTopEvent = function(i) {
            i.path.unshift(this);
            this.getParent()._sendTopEvent(i);
        };
        this._onFieldInvalid = function(i) {
            this._hasCheck = false;
            this._config.parent._onRecordInvalid(this);
        };
        this._onFieldSetedValue = function(j, i) {
            if (this._status == "t") {
                this._doSetStatus("n");
                this._config.parent._onRecordStatus(this, "t", "n");
            } else {
                if (this._status == "p") {
                    this._doSetStatus("m");
                    this._config.parent._onRecordStatus(this, "p", "m");
                }
            }
        };
        this._onFieldUpdate = function(s, q, l, n, j, p) {
            this._hasCheck = false;
            if (l) {
                this._updateAffectFields(s, q, p);
                if (q != j) {
                    this._updateAffectFields(n, j, p);
                }
                this._updateRefParent(s, q, p);
                if (this._config.form._dependItems.severity[s]) {
                    this._evalSeverity();
                }
                if (this._config.form._dependItems.removable[s]) {
                    this._evalRemovable();
                }
                var k = this._config.form._dependItems.watchexpr;
                if (k[s]) {
                    var r = k[s];
                    for (var o in r) {
                        var i = this._evalExpression(o, null).getValue();
                        this._events.dispatchEvent(this, {
                            type: "expression",
                            record: this,
                            expression: o,
                            value: i
                        },
                        "recordExpression");
                    }
                }
                var m = q.getConfig();
                if (m.reserved && m.reserved == "1") {
                    this._config.parent._onFieldLastValue(s, q.getValue(true));
                }
            }
            this._config.parent._onRecordUpdate(this, l, n, j);
        };
        this._updateAffectFields = function(o, n, k) {
            var m = this._root._getAffectItems(this.getParent()._form, o);
            if (m) {
                for (var l = 0; l < m.length; l++) {
                    var j = this.getField(m[l]);
                    j._onDependUpdate(o, n, k);
                }
            }
        };
        this._updateRefParent = function(q, p, k) {
            var n = null;
            if (this.getParent().getParent() == null) {
                n = "$root." + q;
            }
            for (var l = 0; l < this._fields.length; l++) {
                var o = this._fields[l];
                if (o.getModelType() == "recordset") {
                    var j = o.getRecords();
                    for (var m = 0; m < j.length; m++) {
                        this._updateRefParent2(n, "$parent." + q, j[m], p, k);
                    }
                }
            }
        };
        this._updateRefParent2 = function(n, u, o, v, q) {
            if (n != null && o._config.form._dependRoot) {
                var k = o._config.form._dependRoot;
                for (var s = 0; s < k.length; s++) {
                    var t = o.getField(k[s]);
                    if (t) {
                        t._onDependUpdate(u, v, q);
                    }
                }
            }
            if (o._config.form._dependParent) {
                var k = o._config.form._dependParent;
                for (var s = 0; s < k.length; s++) {
                    var t = o.getField(k[s]);
                    if (t) {
                        t._onDependUpdate(u, v, q);
                    }
                }
            }
            for (var m = 0; m < o._fields.length; m++) {
                var p = o._fields[m];
                if (p.getModelType() == "recordset") {
                    var l = p.getRecords();
                    for (var j = 0; j < l.length; j++) {
                        this._updateRefParent2(n, "$parent." + u, l[j], v, q);
                    }
                }
            }
        };
        this._evalSeverity = function() {
            var j = this._config.form;
            if (j.severity) {
                var l = this._severity[0];
                var i = j.severity;
                var k = "" + this._evalExpression(i.exp, null).getValue();
                this._severity = [k, null];
                if (i.levels && i.levels[k]) {
                    this._severity = [i.levels[k].value, i.levels[k].text];
                }
                if (l != this._severity[0]) {
                    this._events.dispatchEvent(this, {
                        type: "severity",
                        record: this,
                        oldValue: l,
                        newValue: k,
                        newText: this._severity[1]
                    },
                    "recordSeverity");
                }
            }
        };
        this._evalRemovable = function() {
            var k = this._removable;
            var j = this._config.form;
            if (j.removable) {
                this._removable = this._evalExpression(j.removable, null).getValue() == 1 ? true: false;
            } else {
                var i = this._root._config;
                if (this._level == 0) {
                    this._removable = g.attrValue(i, "removable", g.attrValue(i, "deletable", true));
                } else {
                    this._removable = g.attrValue(i, "modifiable", g.attrValue(i, "updatable", true));
                }
            }
        };
        this._doSetStatus = function(j) {
            if (this._status == j) {
                return;
            }
            var i = this._status;
            this._status = j;
            this._events.dispatchEvent(this, {
                type: "status",
                record: this,
                oldStatus: i,
                newStatus: j
            },
            "recordStatus");
        };
        this._setError = function(j) {
            var m = null;
            for (var i in j) {
                if (i == "@id") {
                    continue;
                }
                var l = this.getField(i);
                if (l) {
                    l._setError(j[i]);
                    if (m == null) {
                        m = l;
                    }
                }
            }
            if (m) {
                this._onFieldInvalid(m);
            }
        };
        this._evalExpression = function(j, i) {
            return this._root._expression.evaluate(this, i, j);
        };
        this._addExpression = function(i) {
            i.form = this._config.form.name;
            return this._root._addExpression(i);
        };
        this.isRemovable = function() {
            return this._removable;
        };
        this.addListener = function(i, j) {
            return this._events.addListener(i, j);
        };
        this.removeListener = function(j, i) {
            this._events.removeListener(j, i);
        };
        this.getConfig = function() {
            return this._config.parent._form;
        };
        this.isValid = function() {
            return this._checkValue();
        };
        this.destroy = function() {
            this._events.clear();
            for (var j = 0; j < this._fields.length; j++) {
                this._fields[j].destroy();
            }
            this._config = {};
            this._fields = [];
            this._fieldMap = {};
            this._events = null;
            this._recordSet = null;
            this._root = null;
        };
        this._init = function() {
            this._root = this._config.root;
            this._id = g._nextRecordId();
            this._status = "t";
            this._recordSet = this._config.parent;
            var t = this._config.parent;
            var q = t._fieldNames;
            var s = {};
            var k = {
                values: {}
            };
            if (this._config.value) {
                k = this._config.value;
                delete this._config.value;
            }
            if (this._config.dataopts) {
                s = this._config.dataopts;
                delete this._config.dataopts;
            }
            var m = false;
            var u = {};
            for (var n = 0; n < q.length; n++) {
                var j = null;
                if (k.values[q[n]]) {
                    j = k.values[q[n]];
                }
                if (q[n] == "@id") {
                    if (j) {
                        this._id = j;
                    }
                    continue;
                } else {
                    if (q[n] == "@status") {
                        if (j) {
                            m = true;
                            this._status = j;
                        }
                        continue;
                    }
                }
                var r = t._getField(t.getConfig(), q[n]);
                var o = t._getSubform(t.getConfig(), q[n]);
                var p;
                if (r != null) {
                    p = new d.XmlformField({
                        root: this._root,
                        parent: this,
                        field: r,
                        value: j
                    });
                    if (j == null) {
                        u[p.getName()] = true;
                    }
                } else {
                    if (o != null) {
                        p = new d.XmlformRecordSet({
                            __inner__: "true",
                            root: this._root,
                            parent: this,
                            subform: o,
                            form: this._root._getForm(o.form),
                            level: t._level + 1,
                            dataopts: s,
                            value: {
                                forms: k.forms,
                                value: j
                            }
                        });
                    } else {
                        continue;
                    }
                }
                this._fields.push(p);
                this._fieldMap[q[n]] = p;
            }
            if (m == false && s.defaultStatus) {
                this._status = s.defaultStatus;
            }
            if (k.forms) {
                var l = this._root.isReadonly();
                for (var n = 0; n < this._fields.length; n++) {
                    var r = this._fields[n];
                    if (r.getModelType() == "field") {
                        r._evalRequired();
                        if (l) {
                            r._readonly = 1;
                        }
                    }
                }
            } else {
                for (var n = 0; n < this._fields.length; n++) {
                    var r = this._fields[n];
                    if (r.getModelType() == "field") {
                        if (u[r.getName()]) {
                            r._initDefault();
                        }
                        r._evalRequired();
                        this._updateAffectFields(r.getName(), r, true);
                        r._errorText = null;
                    }
                }
            }
            this._evalSeverity();
            this._evalRemovable();
        };
        this._init();
    };
    d.XmlformField = function(h) {
        this._config = h;
        this._value = "";
        this._errorText = null;
        this._inSetValue = false;
        this._inReadonly = false;
        this._inRequired = false;
        this._readonly = 0;
        this._required = false;
        this._severity = [null, null];
        this._always = false;
        this._events = new EventSupport();
        this.getConfig = function() {
            return this._config.field;
        };
        this.getParent = function() {
            return this._config.parent;
        };
        this.getType = function() {
            return this._config.field["type"];
        };
        this.getReferenceArguments = function() {
            var j = this.getConfig(),
            k = {};
            if (j.reference && j.reference["arguments"]) {
                var n = j.reference["arguments"],
                i;
                for (var l in n) {
                    i = n[l];
                    if (i.field) {
                        var m = this._getDependField(this.getParent(), i.field.split("."), 0);
                        if (m) {
                            k[i.name] = m.getValue();
                        }
                    } else {
                        k[i.name] = i.value;
                    }
                }
            }
            return k;
        };
        this._getDependField = function(l, q, j) {
            if (j == q.length - 1) {
                return l.getField(q[j]);
            }
            if (q.length == 2 && q[0] == "$root") {
                var k = l;
                while (k.getParent().getParent() != null) {
                    k = k.getParent().getParent();
                }
                return k.getField(q[1]);
            }
            if (q.length == 2 && q[0] == "$env") {
                var p = l._root._envs;
                if (g.hasAttr(p, q[1])) {
                    return p[q[1]];
                }
                return "";
            }
            if (q[0] == "$parent") {
                var o = l;
                var m = j;
                for (var n = j + 1; n < q.length; n++) {
                    o = o.getParent().getParent();
                }
                return o.getField(q[q.length - 1]);
            }
            return null;
        };
        this.isModifiable = function() {
            var i = this._config.parent.isModifiable();
            if (i == false) {
                return false;
            }
            return i;
        };
        this.setInitialValue = function(j) {
            var k = this._config.parent;
            var i = k.getStatus();
            if (i == "t" || (i == "n" && k.getParent()._isSingleRecord() == true)) {
                this._setValue(true, j);
            }
        };
        this.setValue = function(j) {
            var i = this._onlyGetValue(this._value);
            this._setValue(false, j);
            if (i != this._onlyGetValue(this._value)) {
                this._config.parent._onFieldSetedValue(this, this.isValid());
            }
        };
        this._setValue = function(j, k) {
            if (this._inSetValue == true || this._config == null) {
                return;
            }
            k = this._parseValue(k);
            if (this._onlyGetValue(this._value) === this._onlyGetValue(k)) {
                var l = this._onlyGetText(this._value);
                if (l == null || l == "") {
                    this._value = k;
                }
                return;
            }
            this._inSetValue = true;
            var i = this._onlyGetValue(this._value);
            this._value = k;
            this._checkValue();
            this._events.dispatchEvent(this, {
                type: "update",
                field: this,
                valid: this._errorText == null,
                oldValue: i,
                newValue: this._onlyGetValue(this._value)
            },
            "fieldUpdate");
            this._config.parent._onFieldUpdate(this.getName(), this, this.isValid(), this.getName(), this, j);
            this._inSetValue = false;
        };
        this._parseValue = function(i) {
            if (typeof(i) === "undefined" || i === null) {
                i = "";
            }
            if (g.isVt(i)) {
                if (g.hasAttr(i, "v")) {
                    i.v = g.trimStr(i.v);
                }
            } else {
                i = g.trimStr(i);
            }
            return i;
        };
        this._onlyGetValue = function(i) {
            if (g.isVt(i)) {
                return i.v;
            }
            return i;
        };
        this._onlyGetText = function(i) {
            if (g.isVt(i)) {
                return i.t;
            }
            return i;
        };
        this._onDependUpdate = function(m, n, l) {
            var q = this.getConfig()["_dependItems"];
            if (q.readonly[m] || q.required[m]) {
                this._reevalRequired();
            }
            if (q.check[m]) {
                this._evalCheckes();
            }
            if (q["default"][m]) {
                var u = this._config.parent.getStatus();
                var o = this._onlyGetValue(this._value);
                var j = (o == "" || o == null);
                if ((this._always == "0" && j) || (this._always == "1") || (this._always == "2" && (u == "t" || u == "n") || (this._always == "3" && this._defVal == o))) {
                    this._setValue(l, this._evalDefault());
                    if (this._always == "3") {
                        this._defVal = o;
                    }
                }
            }
            if (q.reference[m]) {
                var k = this.getConfig(),
                p = {};
                var t = k.reference["arguments"],
                s;
                for (var i in t) {
                    s = t[i];
                    if (s.field && s.field == m) {
                        p[s.name] = n.getValue();
                    }
                }
                this._events.dispatchEvent(this, {
                    type: "depend",
                    field: this,
                    dependName: m,
                    dependValues: p,
                    initial: l
                },
                "fieldDepend");
            }
        };
        this._initDefault = function() {
            if (this._config.field["default"]) {
                this._value = this._parseValue(this._evalDefault());
                if (this._always == "3") {
                    this._defVal = this._onlyGetValue(this._value);
                }
            }
        };
        this._evalDefault = function() {
            if (this._config.field["default"]) {} else {
                return this._value;
            }
            var i = this._config.field["default"];
            if (i.text) {
                return {
                    "@type": "vt",
                    v: this._config.parent._evalExpression(i.value, this).toString(),
                    t: this._config.parent._evalExpression(i.text, this).toString()
                };
            }
            return this._config.parent._evalExpression(i.value, this).toString();
        };
        this._reevalRequired = function() {
            var j = this._readonly;
            var i = this._required;
            var k = this._severity[0];
            this._evalRequired();
            if (j != this._readonly) {
                if (this._inReadonly == true) {
                    return;
                }
                this._inReadonly = true;
                this._events.dispatchEvent(this, {
                    type: "readonly",
                    field: this,
                    oldValue: j != 0,
                    newValue: this._readonly != 0
                },
                "fieldReadonly");
                this._inReadonly = false;
            }
            if (i != this._required) {
                if (this._inRequired == true) {
                    return;
                }
                this._inRequired = true;
                this._events.dispatchEvent(this, {
                    type: "required",
                    field: this,
                    oldValue: i,
                    newValue: this._required
                },
                "fieldRequired");
                this._inRequired = false;
            }
            if (k != this._severity[0]) {
                this._events.dispatchEvent(this, {
                    type: "severity",
                    field: this,
                    oldValue: k,
                    newValue: this._severity[0],
                    newText: this._severity[1]
                },
                "fieldSeverity");
            }
        };
        this._evalRequired = function() {
            if (this._config.field["readonly"]) {
                this._readonly = this._config.parent._evalExpression(this._config.field["readonly"], this).getValue();
            }
            if (this._config.field["required"]) {
                this._required = this._config.parent._evalExpression(this._config.field["required"], this).getValue() == 1 ? true: false;
            }
            if (this._config.field["severity"]) {
                var j = this._config.field["severity"];
                var l = "" + this._config.parent._evalExpression(j.exp, this).getValue();
                this._severity = [l, null];
                if (j.levels && j.levels[l]) {
                    this._severity = [j.levels[l].value, j.levels[l].text];
                }
            }
            var i = "0";
            if (this._config.field["key"]) {
                i = this._config.field["key"];
            }
            if (i == "2") {
                this._readonly = 1;
            }
            var k = this.getParent().getStatus();
            if ((k == "p" || k == "m") && i == "1") {
                this._readonly = 1;
            }
        };
        this._evalCheckes = function() {
            var l = this._onlyGetValue(this._value);
            if (l == "" || l == null) {
                return true;
            }
            if (this._config.field["checks"]) {} else {
                return true;
            }
            var j = this._config.field["checks"];
            for (var k = 0; k < j.length; k++) {
                if (this._config.parent._evalExpression(j[k].exp, this).getValue() == 0) {
                    this._setInvalid(j[k].text);
                    return false;
                }
            }
            this._setInvalid(null);
            return true;
        };
        this.getValue = function(i) {
            if (i) {
                return this._getData(true);
            }
            return this._getData(false);
        };
        this._getData = function(i) {
            if (i == true) {
                return this._value;
            } else {
                return this._onlyGetValue(this._value);
            }
        };
        this.hasText = function() {
            if (g.isVt(this._value)) {
                return true;
            }
            return this._config.field["hastext"] == "1";
        };
        this.getText = function() {
            if (this.hasText()) {
                return this._onlyGetText(this._value);
            }
            var i = this._onlyGetValue(this._value);
            if (this._config.field["format"]) {
                return c.formatFieldValue(this, i);
            } else {
                return i;
            }
        };
        this.getModelType = function() {
            return "field";
        };
        this.getName = function() {
            return this._config.field["name"];
        };
        this.getLabel = function() {
            if (this._config.field["label"]) {
                return this._config.field["label"];
            } else {
                return this.getName();
            }
        };
        this.isReadonly = function() {
            return this._readonly != 0;
        };
        this.isRequired = function() {
            return this._required;
        };
        this.getSeverity = function() {
            return [this._severity[0], this._severity[1]];
        };
        this._checkValue = function() {
            this._errorText = null;
            this._reevalRequired();
            if (this._errorText == null) {
                e.Validator.checkField(this);
            }
            if (this._errorText == null) {
                this._evalCheckes();
            }
            return this.isValid();
        };
        this._setInvalid = function(j) {
            var i = this._errorText;
            this._errorText = j;
            this._events.dispatchEvent(this, {
                type: "valid",
                field: this,
                oldValue: i == null,
                newValue: this._errorText == null
            },
            "fieldValid");
        };
        this._setError = function(i) {
            this._setInvalid(i);
        };
        this.isValid = function() {
            return this._errorText == null;
        };
        this.getInvalidText = function() {
            return this._errorText;
        };
        this._doOffline = function() {
            this._events.clear();
        };
        this.addListener = function(i, j) {
            return this._events.addListener(i, j);
        };
        this.removeListener = function(j, i) {
            this._events.removeListener(j, i);
        };
        this._sendTopEvent = function(i) {
            i.path.unshift(this);
            this.getParent()._sendTopEvent(i);
        };
        this._getRoot = function() {
            return this._record._recordSet._getRoot();
        };
        this.destroy = function() {
            this._events.clear();
            this._events = null;
            this._config = null;
            this._root = null;
        };
        this._init = function() {
            if (this._config.field["default"]) {
                var i = this._config.field["default"];
                if (i.always) {
                    this._always = i.always;
                }
            }
            if (this._config.value) {
                this._value = this._parseValue(this._config.value);
                delete this._config.value;
            }
        };
        this._init();
    };
    var a = 0;
    EventSupport = function() {
        this._pause = false;
        this._listeners = [];
        this.setPause = function(h) {
            this._pause = h;
        };
        this.addListener = function(h, i) {
            this.removeListener(i, h);
            var j = a++;
            this._listeners.push({
                scope: h,
                listener: i,
                id: j
            });
            return j;
        };
        this.removeListener = function(m, l) {
            if (typeof(m) == "number") {
                var j = [];
                for (var h = 0; h < this._listeners.length; h++) {
                    if (m != this._listeners[h].id) {
                        j.push(this._listeners[h]);
                    }
                }
                this._listeners = j;
                return;
            }
            var k = false;
            if (l) {
                k = true;
            }
            var j = [];
            for (var h = 0; h < this._listeners.length; h++) {
                if ((k == false && this._listeners[h].listener != m) || (k == true && (this._listeners[h].scope != l || this._listeners[h].listener != m))) {
                    j.push(this._listeners[h]);
                }
            }
            this._listeners = j;
        };
        this.dispatchEvent = function(i, m, j) {
            this._doDispatchEvent(i, m);
            if (j) {
                var l = {};
                for (var h in m) {
                    l[h] = m[h];
                }
                l.type = j;
                l.path = [];
                i._sendTopEvent(l);
            }
        };
        this._doDispatchEvent = function(j, n) {
            if (this._pause == true) {
                return;
            }
            var l = j.getParent();
            while (l != null) {
                if (l._events._pause == true) {
                    return;
                }
                l = l.getParent();
            }
            n = this._createReadObj(n);
            var m = this._listeners;
            for (var k = 0; k < m.length; k++) {
                var h = n;
                m[k].listener.call(m[k].scope, h);
            }
        };
        this._createReadObj = function(i) {
            if (Object.create) {
                var j = {};
                for (var h in i) {
                    j[h] = {
                        writable: false,
                        value: i[h]
                    };
                }
                return Object.create(null, j);
            } else {
                return i;
            }
        };
        this.clear = function() {
            this._listeners.splice(0);
        };
    };
    return d;
});
