/*
 * Decompiled with CFR 0.152.
 */
package net.sf.xmlform.web;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.io.IOException;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import net.sf.xmlform.util.MapMessageParameters;
import net.sf.xmlform.util.MessageParameters;
import net.sf.xmlform.util.MessageUtil;
import net.sf.xmlform.web.ResourceUtil;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class BatchResourceServlet
extends HttpServlet {
    private static Logger _log = LoggerFactory.getLogger(BatchResourceServlet.class);
    public static final String KEY_MESSAGE_PARAMETERS = MapMessageParameters.class.getName();
    public static final String JS_FILE = "file";
    public static final String JS_CLASS = "class";
    public static final String JS_INCLUDE = "include";
    public static final String JS_INLINE = "inline";
    public static final String JS_RESOURCE = "resource";
    public static final String JS_HEADER = "header";
    private static String JS_FILE_PREFIX = "file=";
    private static String JS_INCLUDE_PREFIX = "include=";
    private static String JS_CLASS_PREFIX = "class=";
    private static String JS_INLINE_PREFIX = "inline=";
    private static String JS_HEADER_PREFIX = "header=";
    private static String JS_RESOURCE_PREFIX = "resource=";
    private static String SEP = "=";

    protected void doGet(HttpServletRequest req, HttpServletResponse resp) throws ServletException, IOException {
        BatchResourceServlet.process(req, resp);
    }

    public static void process(HttpServletRequest req, HttpServletResponse resp) {
        Object params = (MessageParameters)req.getServletContext().getAttribute(KEY_MESSAGE_PARAMETERS);
        if (params == null) {
            params = (MessageParameters)req.getAttribute(KEY_MESSAGE_PARAMETERS);
        }
        if (params == null) {
            params = ResourceUtil.getCommonParameters(req.getServletContext(), req);
        }
        BatchResourceServlet.process(req, resp, params);
    }

    public static void process(HttpServletRequest req, HttpServletResponse resp, MessageParameters params) {
        String path = req.getRequestURI();
        if (!"/".equals(req.getContextPath()) && req.getContextPath().length() > 0) {
            path = path.substring(req.getContextPath().length());
        }
        path = BatchResourceServlet.convertPath(req.getServletContext().getRealPath(path));
        path = path.substring(0, path.lastIndexOf("/") + 1);
        String file = BatchResourceServlet.convertPath(req.getRequestURI());
        file = file.substring(file.lastIndexOf("/") + 1);
        BatchResourceServlet.readJs(params, req, resp, path, file, true);
    }

    private static void readJs(MessageParameters map, HttpServletRequest req, HttpServletResponse resp, String path, String jsFile, boolean isFirst) {
        try {
            BufferedReader br = new BufferedReader(new FileReader(BatchResourceServlet.convertPath(path + jsFile)));
            String js = br.readLine();
            while (js != null) {
                if (isFirst && js.startsWith(JS_HEADER_PREFIX)) {
                    String head = BatchResourceServlet.getParamString(js);
                    resp.addHeader(head.substring(0, head.indexOf(SEP)), BatchResourceServlet.getParamString(head));
                } else {
                    BatchResourceServlet.parseLine(map, jsFile, req, resp, path, MessageUtil.formatMessage((String)js, (MessageParameters)map));
                }
                js = br.readLine();
            }
            br.close();
        }
        catch (Exception e) {
            _log.error("Read javascript config file: " + path + jsFile, (Throwable)e);
        }
    }

    private static void parseLine(MessageParameters map, String jsFile, HttpServletRequest req, HttpServletResponse resp, String path, String line) {
        try {
            if (line.startsWith(JS_RESOURCE_PREFIX)) {
                ResourceUtil.outputResource(resp, BatchResourceServlet.getParamString(line));
            } else if (line.startsWith(JS_INLINE_PREFIX)) {
                ResourceUtil.outputInline(resp, BatchResourceServlet.getParamString(line));
            } else if (line.startsWith(JS_FILE_PREFIX)) {
                ResourceUtil.outputFile(resp, BatchResourceServlet.convertPath(path + BatchResourceServlet.getParamString(line)));
            } else if (line.startsWith(JS_CLASS_PREFIX)) {
                ResourceUtil.outputClass(req.getServletContext(), req, resp, BatchResourceServlet.getParamString(line));
            } else if (line.startsWith(JS_INCLUDE_PREFIX)) {
                String[] jsFiles = BatchResourceServlet.getParamString(line).split(",");
                for (int i = 0; i < jsFiles.length; ++i) {
                    String p;
                    String f = p = BatchResourceServlet.convertPath(jsFiles[i]);
                    if (p.indexOf("/") >= 0) {
                        f = p.substring(p.lastIndexOf("/") + 1);
                        p = p.substring(0, p.lastIndexOf("/") + 1);
                    } else {
                        p = "";
                    }
                    String fileName = BatchResourceServlet.convertPath(path + p) + f;
                    File file = new File(fileName);
                    if (!file.exists()) {
                        _log.info("Resource file not found: " + fileName);
                        continue;
                    }
                    BatchResourceServlet.readJs(map, req, resp, BatchResourceServlet.convertPath(path + p), f, false);
                }
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            _log.error("Read javascript config file: " + path + jsFile + " : " + line, (Throwable)e);
        }
    }

    private static String getParamString(String line) {
        return line.substring(line.indexOf(SEP) + 1);
    }

    private static String convertPath(String path) {
        return path.replaceAll("\\\\", "/").replaceAll("//", "/");
    }
}

