/*
 * Decompiled with CFR 0.152.
 */
package net.sf.xmlform.web;

import java.io.UnsupportedEncodingException;
import java.net.URLEncoder;
import java.util.Locale;
import javax.servlet.ServletContext;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import net.sf.xmlform.type.BooleanType;
import net.sf.xmlform.type.ByteType;
import net.sf.xmlform.type.DateTimeType;
import net.sf.xmlform.type.DateType;
import net.sf.xmlform.type.DecimalType;
import net.sf.xmlform.type.DoubleType;
import net.sf.xmlform.type.FloatType;
import net.sf.xmlform.type.IType;
import net.sf.xmlform.type.IntType;
import net.sf.xmlform.type.IntegerType;
import net.sf.xmlform.type.LongType;
import net.sf.xmlform.type.ShortType;
import net.sf.xmlform.type.StringType;
import net.sf.xmlform.type.TimeType;
import net.sf.xmlform.type.YearMonthType;
import net.sf.xmlform.util.FormUtils;
import net.sf.xmlform.util.MessageUtil;
import net.sf.xmlform.web.ClassResource;
import net.sf.xmlform.web.ResourceUtil;

public class LocaleValidatorText
implements ClassResource {
    public void outputResource(ServletContext servletContext, HttpServletRequest req, HttpServletResponse resp, String param) throws Exception {
        Locale local = FormUtils.parseLocale((String)param);
        ResourceUtil.outputString(resp, this.buildAMDValidatorText(local));
    }

    public String buildAMDValidatorText(Locale local) {
        StringBuffer sb = new StringBuffer();
        sb.append("(function(global,factory){");
        sb.append("\tif (typeof module !== 'undefined' && typeof exports === 'object' && define.cmd) {");
        sb.append("\t\t ");
        sb.append("\t\tfactory(validation);");
        sb.append("\t} else if (typeof define === 'function' && define.amd) {");
        sb.append("\t\trequire([\"xmlform/validation\"],factory);");
        sb.append("\t} else {");
        sb.append("\t\tfactory(global.xmlformValidation);");
        sb.append("\t}");
        sb.append("})(typeof window!==\"undefined\" ? window:this,function(val){");
        sb.append("t=").append(this.buildValidatorText(local, true)).append(";");
        sb.append("for(var k in t){val.TypeTextes[k]=t[k];}");
        sb.append("});");
        return sb.toString();
    }

    public String buildValidatorText(Locale local) {
        return this.buildValidatorText(local, false);
    }

    public String buildValidatorText(Locale local, boolean useDecode) {
        StringBuffer sb = new StringBuffer("{");
        this.addText(local, useDecode, sb, "required", MessageUtil.getMessage((Locale)local, IType.class, (String)"field.value.required", (String[])new String[0]));
        this.addText(local, useDecode, sb, "occurs.size", MessageUtil.getMessage((Locale)local, IType.class, (String)"field.value.occurs.size", (String[])new String[]{"{0}"}));
        this.addText(local, useDecode, sb, "occurs.range", MessageUtil.getMessage((Locale)local, IType.class, (String)"field.value.occurs.range", (String[])new String[]{"{0}", "{1}"}));
        this.addText(local, useDecode, sb, "occurs.min", MessageUtil.getMessage((Locale)local, IType.class, (String)"field.value.occurs.min", (String[])new String[]{"{0}"}));
        this.addText(local, useDecode, sb, "occurs.max", MessageUtil.getMessage((Locale)local, IType.class, (String)"field.value.occurs.max", (String[])new String[]{"{0}"}));
        this.addText(local, useDecode, sb, "unique", MessageUtil.getMessage((Locale)local, IType.class, (String)"field.value.unique", (String[])new String[]{"{0}"}));
        this.addText(local, useDecode, sb, BooleanType.NAME, MessageUtil.getMessage((Locale)local, IType.class, (String)"field.value.enum", (String[])new String[]{"true,false"}));
        this.addText(local, useDecode, sb, ByteType.NAME, MessageUtil.getMessage((Locale)local, IType.class, (String)"field.value.integer", (String[])new String[0]));
        this.addText(local, useDecode, sb, DateTimeType.NAME, MessageUtil.getMessage((Locale)local, IType.class, (String)"field.value.datetime", (String[])new String[0]));
        this.addText(local, useDecode, sb, DateType.NAME, MessageUtil.getMessage((Locale)local, IType.class, (String)"field.value.date", (String[])new String[0]));
        this.addText(local, useDecode, sb, DecimalType.NAME, MessageUtil.getMessage((Locale)local, IType.class, (String)"field.value.decimal", (String[])new String[0]));
        this.addText(local, useDecode, sb, DoubleType.NAME, MessageUtil.getMessage((Locale)local, IType.class, (String)"field.value.decimal", (String[])new String[0]));
        this.addText(local, useDecode, sb, FloatType.NAME, MessageUtil.getMessage((Locale)local, IType.class, (String)"field.value.decimal", (String[])new String[0]));
        this.addText(local, useDecode, sb, IntegerType.NAME, MessageUtil.getMessage((Locale)local, IType.class, (String)"field.value.integer", (String[])new String[0]));
        this.addText(local, useDecode, sb, IntType.NAME, MessageUtil.getMessage((Locale)local, IType.class, (String)"field.value.integer", (String[])new String[0]));
        this.addText(local, useDecode, sb, LongType.NAME, MessageUtil.getMessage((Locale)local, IType.class, (String)"field.value.integer", (String[])new String[0]));
        this.addText(local, useDecode, sb, ShortType.NAME, MessageUtil.getMessage((Locale)local, IType.class, (String)"field.value.integer", (String[])new String[0]));
        this.addText(local, useDecode, sb, StringType.NAME, "");
        this.addText(local, useDecode, sb, TimeType.NAME, MessageUtil.getMessage((Locale)local, IType.class, (String)"field.value.time", (String[])new String[0]));
        this.addText(local, useDecode, sb, YearMonthType.NAME, MessageUtil.getMessage((Locale)local, IType.class, (String)"field.value.yearmonth", (String[])new String[0]));
        sb.append("\"author\":\"Liu Zhikun\"}");
        return sb.toString();
    }

    private void addText(Locale local, boolean useDe, StringBuffer sb, String name, String text) {
        if (useDe) {
            sb.append("\"").append(name).append("\":").append(this.encodeText(text)).append(",");
        } else {
            sb.append("\"").append(name).append("\":\"").append(text.replace("\"", "\\\"")).append("\",");
        }
    }

    protected String encodeText(String text) {
        try {
            return "decodeURIComponent(\"" + URLEncoder.encode(text, "UTF-8") + "\").replace(/\\+/g,\" \")";
        }
        catch (UnsupportedEncodingException e) {
            e.printStackTrace();
            return "\"" + e.getMessage() + "\"";
        }
    }
}

