/*
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package net.sourceforge.basher;

/**
 * @author Johan Lindquist
 * @version 1.0
 */
public class BasherException extends RuntimeException
{
    /** Creates a new <code>BasherException</code> instance.
     *
     * @param reason The message describing the reason for the failure.
     * @param cause The actual exception which caused the failure.
     */
    public BasherException(final String reason, Throwable cause)
    {
        super(reason, cause);
    }

    /** {@inheritDoc} */
    public boolean equals(final Object object)
    {
        if (this == object)
        {
            return true;
        }
        if (object == null || getClass() != object.getClass())
        {
            return false;
        }

        return (super.getCause() == ((Exception) object).getCause()) && (super.getMessage() == ((Exception) object).getMessage());
    }

}
