package net.sourceforge.basher.events;

import java.util.EventObject;

/**
 * @author Johan Lindquist
 * @version $Revision$
 */
public abstract class BasherEvent extends EventObject
{
    private long _creationTime;

    public BasherEvent()
    {
        super("<none>");
        _creationTime = System.currentTimeMillis();
    }

    /** Retrieves the creation time of this event instance.
     *
     * @return  The creation time
     */
    public long getCreationTime()
    {
        return _creationTime;
    }

    /** Sets the creation time of this event instance.
     *
     * @param creationTime The creation time to set
     */
    void setCreationTime( final long creationTime )
    {
        _creationTime = creationTime;
    }

    /**
     * Constructs a prototypical Event.
     *
     * @param source The object on which the Event initially occurred.
     * @throws IllegalArgumentException if source is null.
     */
    public BasherEvent(Object source)
    {
        super(source);
        _creationTime = System.currentTimeMillis();
    }



    @Override
    public String toString()
    {
        return "BasherEvent{" +
                "_creationTime=" + _creationTime +
                '}';
    }

    @Override
    public boolean equals( final Object o )
    {
        if ( this == o )
        {
            return true;
        }
        if ( o == null || getClass() != o.getClass() )
        {
            return false;
        }

        final BasherEvent that = ( BasherEvent ) o;

        if ( _creationTime != that._creationTime )
        {
            return false;
        }

        return true;
    }

    @Override
    public int hashCode()
    {
        return ( int ) ( _creationTime ^ ( _creationTime >>> 32 ) );
    }
}
