package net.sourceforge.basher.events;

import net.sourceforge.basher.BasherContext;
import net.sourceforge.basher.Phase;

/**
 * @author Johan Lindquist
 * @version $Revision$
 */
public class PhaseTransitionEvent extends BasherEvent
{
    private BasherContext _basherContext;
    private Phase _oldPhase;
    private Phase _newPhase;

    public PhaseTransitionEvent(final BasherContext basherContext, final Phase oldPhase, final Phase newPhase)
    {
        _basherContext = basherContext;
        _oldPhase = oldPhase;
        _newPhase = newPhase;
    }

    public BasherContext getBasherContext()
    {
        return _basherContext;
    }

    public Phase getOldPhase()
    {
        return _oldPhase;
    }

    public Phase getNewPhase()
    {
        return _newPhase;
    }

    public boolean equals(final Object o)
    {
        if (this == o)
        {
            return true;
        }
        if (o == null || getClass() != o.getClass())
        {
            return false;
        }

        final PhaseTransitionEvent event = (PhaseTransitionEvent) o;

        if (_basherContext != null ? !_basherContext.equals(event._basherContext) : event._basherContext != null)
        {
            return false;
        }
        if (_newPhase != event._newPhase)
        {
            return false;
        }
        if (_oldPhase != event._oldPhase)
        {
            return false;
        }

        return true;
    }

    public int hashCode()
    {
        int result;
        result = (_basherContext != null ? _basherContext.hashCode() : 0);
        result = 31 * result + (_oldPhase != null ? _oldPhase.hashCode() : 0);
        result = 31 * result + (_newPhase != null ? _newPhase.hashCode() : 0);
        return result;
    }

    public String toString()
    {
        return "PhaseTransitionEvent{" +
                "_basherContext=" + _basherContext +
                ", _oldPhase=" + _oldPhase +
                ", _newPhase=" + _newPhase +
                '}';
    }
}