package net.sourceforge.basher.events;

/**
 * @author Johan Lindquist
 * @version $Revision$
 */
public class TickEvent extends BasherEvent
{
    private final long _tick;

    public TickEvent(final long tick)
    {
        _tick = tick;
    }

    public long getTick()
    {
        return _tick;
    }


    public String toString()
    {
        return "TickEvent{" +
                "_tick=" + _tick +
                '}';
    }

    public boolean equals(final Object o)
    {
        if (this == o)
        {
            return true;
        }
        if (o == null || getClass() != o.getClass())
        {
            return false;
        }

        final TickEvent event = (TickEvent) o;

        if (_tick != event._tick)
        {
            return false;
        }

        return true;
    }

    public int hashCode()
    {
        return (int) (_tick ^ (_tick >>> 32));
    }
}
