package net.sourceforge.basher.events.impl;

import java.util.ArrayList;
import java.util.List;

import net.sourceforge.basher.events.BasherEvent;
import net.sourceforge.basher.events.BasherEventListener;
import net.sourceforge.basher.events.EventManager;
import org.apache.commons.logging.Log;

/**
 * @author Johan Lindquist
 * @version $Revision$
 */
public class SynchronousEventManager implements EventManager
{
    /**
     * Instance log
     */
    private Log _log;

    private List<BasherEventListener> _basherEventListeners = new ArrayList<BasherEventListener>();

    /** */
    public void setLog(final Log log)
    {
        _log = log;
    }

    public void publish(final BasherEvent basherEvent)
    {
        if (_log.isDebugEnabled())
        {
            _log.debug("Received publish call for event: " + basherEvent);
        }
        final List<BasherEventListener> basherEventListeners = new ArrayList<BasherEventListener>(_basherEventListeners);
        for (final BasherEventListener basherEventListener : basherEventListeners)
        {
            basherEventListener.basherEvent(basherEvent);
        }
    }

    public void addBasherEventListener(final BasherEventListener basherEventListener)
    {
        if (_basherEventListeners.contains(basherEventListener))
        {
            return; // false;
        }

        if (_log.isDebugEnabled())
        {
            _log.debug("Adding basher event listener: " + basherEventListener);
        }
        // return
        _basherEventListeners.add(basherEventListener);
    }

    public void removeBasherEventListener(final BasherEventListener basherEventListener)
    {
        if (!_basherEventListeners.contains(basherEventListener))
        {
            return; // false;
        }
        if (_log.isDebugEnabled())
        {
            _log.info("Removing basher event listener: " + basherEventListener);
        }
        // return
        _basherEventListeners.remove(basherEventListener);
    }

}
