/*
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package net.sourceforge.basher.impl;

import net.sourceforge.basher.Average;
import org.ops4j.gaderian.events.RegistryShutdownListener;

/**
 * @author Johan Lindquist
 * @version 1.0
 */
public class CSVFileCollector extends AbstractFileCollector implements RegistryShutdownListener
{
    protected String formatAverage(final Average average)
    {
        return "" + (_timeSource.getElapsedTime()) + "," + average.getMinTime() + "," + average.getMaxTime() +
                "," + average.getTotalTime() + "," + average.getTotalEntries() + "," + average.getAverage() +
                "," + average.getTPS() + "\n";
    }

    /**
     * Writes the time the specified task took to execute.
     *
     * @param taskName    The name of the task (used for the filename as well)
     * @param elapsedTime Time the task took to execute
     */
    protected String formatExecution(final String taskName, final long elapsedTime)
    {
        return "" + (_timeSource.getElapsedTime()) + "," + taskName + "," + elapsedTime + "\n";
    }

}
