/*
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

/*
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

/*
 *
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 * 	http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package net.sourceforge.basher.impl;

import java.util.*;

import net.sourceforge.basher.EntityRegistry;
import net.sourceforge.basher.internal.Randomizer;
import org.apache.commons.logging.Log;

/**
 * @author Johan Lindquist
 * @version 1.0
 */
public class InMemoryEntityRegistry implements EntityRegistry
{
    private Log _logger;
    private Map _registry = new HashMap();
    private Randomizer _randomizer;

    public void setLog(final Log logger)
    {
        _logger = logger;
    }

    public void setRandomizer(final Randomizer randomizer)
    {
        _randomizer = randomizer;
    }


    public void unregister(final String entityIdentifier, final Object entity)
    {
        if (entityIdentifier == null)
        {
            throw new NullPointerException("entityIdentifier");
        }
        if (entity == null)
        {
            throw new NullPointerException("entityID");
        }

        synchronized (_registry)
        {
            final List list = (List) _registry.get(entityIdentifier);
            if (list == null || !list.contains(entity))
            {
                _logger.warn("Warning, entity identifier " + entity + " does not exists for type " + entityIdentifier);
                return;
            }
            list.remove(entity);
        }
    }

    public void register(final String entityIdentifier, final Object entity)
    {
        if (entityIdentifier == null)
        {
            throw new NullPointerException("entityIdentifier");
        }
        if (entity == null)
        {
            throw new NullPointerException("entityID");
        }

        synchronized (_registry)
        {
            List list = (List) _registry.get(entityIdentifier);
            if (list == null)
            {
                list = new ArrayList();
                _registry.put(entityIdentifier, list);
            }
            list.add(entity);
        }
    }

    public Collection getAllRegistered(final String entityIdentifier)
    {
        if (entityIdentifier == null)
        {
            throw new NullPointerException("entityIdentifier");
        }
        return (Collection) _registry.get(entityIdentifier);
    }

    public long getNumRegistered(final String entityIdentifier)
    {
        if (entityIdentifier == null)
        {
            throw new NullPointerException("entityIdentifier");
        }
        final List list = (List) _registry.get(entityIdentifier);
        return (list == null ? 0 : list.size());
    }

    public Collection getRandomSelection(final String entityIdentifier, final int size)
    {
        // TODO: Must fix this synchronization
        synchronized (_registry)
        {
            if (entityIdentifier == null)
            {
                throw new NullPointerException("entityIdentifier");
            }
            if (size <= 0)
            {
                throw new IllegalArgumentException("size <= 0");
            }


            final List list = (List) _registry.get(entityIdentifier);

            if (list == null || list.isEmpty())
            {
                return Collections.EMPTY_LIST;
            }

            // It may be that the list is smaller than
            int realNumberToSelect = size;

            if (list.size() < size)
            {
                realNumberToSelect = list.size();
            }

            final List selection = new ArrayList();

            for (int i = 0; i < realNumberToSelect; i++)
            {
                final int nextIDSlot = _randomizer.getRandomInt(list.size());
                final Object nextID = list.get(nextIDSlot);
                selection.add(nextID);
            }
            return selection;
        }
    }

    public Object getRandom(final String entityIdentifier)
    {
        List list = (List) getRandomSelection(entityIdentifier, 1);
        if (list.isEmpty())
        {
            return null;
        }
        return list.get(0);
    }

}
