/*
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package net.sourceforge.basher.impl;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;

import net.sourceforge.basher.Task;

/**
 * @author Johan Lindquist
 * @version 1.0
 */
public class TaskInfo
{
    private Task _task;

    private List<Task> _followers = new ArrayList<Task>();

    public Task getTask()
    {
        return _task;
    }

    public void setTask(final Task task)
    {
        _task = task;
    }

    public void addFollower(final Task task)
    {
        _followers.add(task);
    }

    public List<Task> getFollowers()
    {
        return Collections.unmodifiableList(_followers);
    }

    public void setFollowers(final List<Task> followers)
    {
        _followers = followers;
    }

    public boolean equals(final Object o)
    {
        if (this == o)
        {
            return true;
        }
        if (o == null || getClass() != o.getClass())
        {
            return false;
        }

        final TaskInfo taskInfo = (TaskInfo) o;

        if (!_followers.equals(taskInfo._followers))
        {
            return false;
        }
        if (!_task.equals(taskInfo._task))
        {
            return false;
        }

        return true;
    }

    public int hashCode()
    {
        int result;
        result = _task.hashCode();
        result = 29 * result + _followers.hashCode();
        return result;
    }

}
