/*
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package net.sourceforge.basher.impl;

import java.util.TimerTask;

import net.sourceforge.basher.events.EventManager;
import net.sourceforge.basher.events.TickEvent;

/**
 * @author Johan Lindquist
 * @version 1.0
 */
public class TickTimerTask extends TimerTask
{
    private long _tick;
    private EventManager _eventManager;

    public TickTimerTask(final EventManager eventManager)
    {
        _eventManager = eventManager;
    }

    public void run()
    {
        _eventManager.publish(new TickEvent(_tick++));
    }

    public boolean equals(final Object o)
    {
        if (this == o)
        {
            return true;
        }
        if (o == null || getClass() != o.getClass())
        {
            return false;
        }

        final TickTimerTask that = (TickTimerTask) o;

        if (_tick != that._tick)
        {
            return false;
        }
        if (_eventManager != null ? !_eventManager.equals(that._eventManager) : that._eventManager != null)
        {
            return false;
        }

        return true;
    }

    public int hashCode()
    {
        int result;
        result = (int) (_tick ^ (_tick >>> 32));
        result = 31 * result + (_eventManager != null ? _eventManager.hashCode() : 0);
        return result;
    }
}