package net.sourceforge.basher.impl;

import java.util.Formatter;

import net.sourceforge.basher.Average;
import net.sourceforge.basher.events.BasherEventListener;
import net.sourceforge.basher.events.BasherEvent;

/**
 * @author Johan Lindquist
 * @version 1.0
 */
public class XMLFileCollector extends AbstractFileCollector implements BasherEventListener
{
    final String EXECUTION_TEMPLATE = "<execution mark=\"%d\" time=\"%d\"/>\n";

    final String AVERAGE_TEMPLATE = "<average mark=\"%d\" min=\"%d\" max=\"%d\" totaltime=\"%d\" totalentries=\"%d\" average=\"%d\" tps=\"%f\" threads=\"%d\"/>\n";

    public void initializeService() throws Exception
    {
        super.initializeService();
        setAverageHeader("<averages>\n");
        setAverageFooter("</averages>");
        setExecutionHeader("<executions taskname=\"%s\">\n");
        setExecutionFooter("</executions>");
    }

    /**
     * Writes the specified <code>Average</code> to the averag file.
     *
     * @param average The average to write to disk
     */
    protected String formatAverage(final Average average)
    {
        final StringBuffer sb = new StringBuffer();
        final Formatter formatter = new Formatter(sb);
        formatter.format(AVERAGE_TEMPLATE, _timeSource.getElapsedTime(), average.getMinTime(), average.getMaxTime(), average.getTotalTime(), average.getTotalEntries(), average.getAverage(), average.getTPS(),average.getNumThreads());
        return sb.toString();
    }

    /**
     * Writes the time the specified task took to execute.
     *
     * @param taskName    The name of the task (used for the filename as well)
     * @param elapsedTime Time the task took to execute
     */
    protected String formatExecution(final String taskName, final long elapsedTime)
    {
        // Format
        // <execution start="12312455" time="100"/>
        // Format

        final StringBuffer sb = new StringBuffer();
        final Formatter formatter = new Formatter(sb);
        formatter.format(EXECUTION_TEMPLATE, _timeSource.getElapsedTime(), elapsedTime);

        return sb.toString();

    }

    @Override
    public void basherEvent(final BasherEvent basherEvent)
    {
        super.basherEvent(basherEvent);
    }
}
