package net.sourceforge.basher.internal.impl;

import java.util.Properties;
import java.util.List;
import java.util.ArrayList;
import java.util.concurrent.CountDownLatch;
import java.beans.XMLDecoder;
import java.io.ByteArrayInputStream;

import net.sourceforge.basher.*;
import net.sourceforge.basher.events.*;
import org.ops4j.gaderian.Registry;
import org.ops4j.gaderian.impl.RegistryBuilder;

/**
 * @author Johan Lindquist
 * @version $Revision$
 */
public class BasherBootHelper implements BasherEventListener
{
    private Registry _registry;
    private CountDownLatch countDownLatch = new CountDownLatch(1);


    public int run(final String activeBasherContext,final Properties properties, final Boolean failIfNoTasks)
   {
       // Construct the registry
       _registry = RegistryBuilder.constructDefaultRegistry();

       // Handle initialisation of Basher contexts provided from the plugins
       // This will also ensure that the selected contexts reporting directory
       // is correctly setup with the directory specified by the plugins
       final BasherContext basherContext = initializeBasherContexts(activeBasherContext, properties);

       // Lookup the event manager and register for events
       EventManager eventManager = (EventManager)_registry.getService(EventManager.class);
       eventManager.addBasherEventListener(this);

       if (basherContext.isAwaitStartSignal())
       {
           // Seems run should wait for external start signal
           final ContextManager contextManager = (ContextManager)_registry.getService( ContextManager.class );
           contextManager.addBasherContext( basherContext );
       }
       else
       {
           // Find the scheduler and start the run
           final Scheduler scheduler = (Scheduler)_registry.getService(Scheduler.class);
           scheduler.start(basherContext);
       }

       // Now, wait for the complete call back
       try
       {
           countDownLatch.await();
       }
       catch (InterruptedException e)
       {
           return 1;
       }

       // Ok, we have now received an end event - it is safe to shutdown the registry and exit

       // For safety, we sleep for just a bit
       try
       {
           Thread.sleep(3000);
       }
       catch (InterruptedException e)
       {
           e.printStackTrace();
       }

       // FIXME: This should process the results to check whether
       // - any tasks failed
       // - any tasks ran for too long
       // 

       _registry.shutdown();



       return 0;
   }

    private BasherContext initializeBasherContexts(final String activeBasherContext, final Properties properties)
    {
        // First deserialize the basher contexts provided to use from plugins
        final List<BasherContext> basherContexts = deserializeBasherContexts(properties);

        // Find the context manager and add all provided contexts
        final ContextManager contextManager = (ContextManager)_registry.getService(ContextManager.class);
        for (final BasherContext basherContext : basherContexts)
        {
            contextManager.addBasherContext(basherContext);
        }

        final BasherContext context = contextManager.getBasherContext(activeBasherContext);
        setupReportsDirecotory(context,properties);
                 return context;
    }

    private void setupReportsDirecotory(final BasherContext basherContext,Properties properties)
    {
        basherContext.setReportDirectory(properties.getProperty("reportingDirectory", "target/basher-reports"));
    }

    private List<BasherContext> deserializeBasherContexts(final Properties properties)
    {
        List<BasherContext> basherContexts = new ArrayList<BasherContext>();
        for (Object o : properties.keySet())
        {
            String key = (String) o;
            if (key.startsWith("basherContext."))
            {
                XMLDecoder xmlDecoder = new XMLDecoder(new ByteArrayInputStream(properties.getProperty(key).getBytes()));
                final BasherContext basherContext = (BasherContext) xmlDecoder.readObject();
                basherContexts.add(basherContext);
            }
        }

        return basherContexts;

    }

    public void basherEvent(final BasherEvent basherEvent)
    {
        if (basherEvent instanceof PhaseTransitionEvent)
        {
            if (((PhaseTransitionEvent)basherEvent).getNewPhase() == Phase.END)
            {
               countDownLatch.countDown();
            }
        }
//        else if (basherEvent instanceof AverageCollectedEvent )
//        {
//            Average average = ((AverageCollectedEvent)basherEvent).getAverage();
//            // FIXME: Collect the averages for later check
//        }
    }
}
