package net.sourceforge.basher.internal.impl;

import java.util.List;
import java.util.ArrayList;

import net.sourceforge.basher.tasks.AbstractTask;
import net.sourceforge.basher.Phase;

/** Empty task extending the <code>AbstractTask</code> class.  This class is used if the <code>TaskManager</code> receives
 * a class (as a task) which neither extends <code>AbstractTask</code> nor implements <code>Task</code> and is declared
 * final.  The task will be wrapped by this class and calls to the task are proxied.
 *
 * @author Johan Lindquist
 * @version $Revision$
 */
public abstract class DecoratedTask extends AbstractTask
{
    private String _name = this.getClass().getName();
    private List<Phase> _applicablePhases = new ArrayList<Phase>();

    public String getName()
    {
        return _name;
    }

    public void setName(final String name)
    {
        _name = name;
    }

    @Override
    public List<Phase> applicablePhases()
    {
        return _applicablePhases;
    }

    public void addPhase(final Phase phase)
    {
        if (!_applicablePhases.contains(phase))
        {
            _applicablePhases.add(phase);
        }
    }

    public void removePhase(final Phase phase)
    {
        _applicablePhases.remove(phase);
    }

}
