/*
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package net.sourceforge.basher.internal.impl;

import java.io.File;
import java.util.Comparator;

import org.apache.commons.logging.Log;

/**
 * @author Johan Lindquist
 * @version 1.0
 */
public class DefaultBeanShellFilenameComparator implements Comparator<File>
{
    private Log _logger;

    public void setLog(final Log logger)
    {
        _logger = logger;
    }

    public int compare(final File file1, final File file2)
    {
        final int comparison = file1.compareTo(file2);
        if (_logger.isDebugEnabled())
        {
            _logger.debug(file1 + " vs  " + file2 +": " + comparison);
        }
        return comparison;
    }
}
