/*
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package net.sourceforge.basher.internal.impl;

import java.io.File;
import java.io.FilenameFilter;
import java.util.regex.Pattern;

import org.apache.commons.logging.Log;

/**
 * @author Johan Lindquist
 */
public class DefaultBeanShellFilenameFilter implements FilenameFilter
{
    Log _logger;
    Pattern _fileMask;

    public void setLog(final Log logger)
    {
        _logger = logger;
    }

    public void setFileMask(final Pattern fileMask)
    {
        _fileMask = fileMask;
    }

    public boolean accept(File dir, String name)
    {
        boolean accepts = _fileMask.matcher(name).matches();
        _logger.debug("File " + name + " - " + (accepts ? "accepted" : "not accepted"));
        return accepts;
    }
}
