package net.sourceforge.basher.internal.impl;

import java.lang.reflect.Constructor;

import net.sourceforge.basher.internal.TaskCreator;
import net.sourceforge.basher.internal.TaskDecorator;
import net.sourceforge.basher.Task;
import net.sourceforge.basher.BasherException;

/**
 * @author Johan Lindquist
 * @version $Revision$
 */
public class TaskCreatorImpl implements TaskCreator
{
    private TaskDecorator _taskDecorator;

    public void setTaskDecorator(final TaskDecorator taskDecorator)
    {
        _taskDecorator = taskDecorator;
    }

    public Task createTask(final Class taskClassName)
    {
        try
        {
            final Constructor constructor = taskClassName.getConstructor();
            return _taskDecorator.decorateInstance(constructor.newInstance());
        }
        catch (Exception e)
        {
            throw new BasherException(e.getMessage(),e);
        }
    }
}
