/*
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package net.sourceforge.basher.internal.impl;

import net.sourceforge.basher.internal.TimeSource;
import net.sourceforge.basher.events.BasherEventListener;
import net.sourceforge.basher.events.BasherEvent;
import net.sourceforge.basher.events.PhaseTransitionEvent;

/**
 * @author Johan Lindquist
 */
public class TimeSourceImpl implements TimeSource, BasherEventListener

{
    private long _startTime = System.currentTimeMillis();

    public long getElapsedTime()
    {
        return System.currentTimeMillis() - _startTime;
    }

    public long getStartTime()
    {
        return _startTime;
    }

    public long getCurrentTime()
    {
        return System.currentTimeMillis();
    }

    public synchronized void reset()
    {
        _startTime = System.currentTimeMillis();
    }

    public void basherEvent(final BasherEvent basherEvent)
    {
        if (basherEvent instanceof PhaseTransitionEvent)
        {
            reset();
        }
    }

}
