/*
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package net.sourceforge.basher.internal.tasks;

import net.sourceforge.basher.Scheduler;
import net.sourceforge.basher.tasks.AbstractTask;

/**
 * @author Johan Lindquist
 * @version 1.0
 */
public class ThreadIncrementTask extends AbstractTask
{
    private Scheduler _scheduler;
    private int _threadIncrementCount = 0;

    public void setScheduler(final Scheduler scheduler)
    {
        _scheduler = scheduler;
    }

    public void setThreadIncrementCount(final int threadIncrementCount)
    {
        _threadIncrementCount = threadIncrementCount;
    }

    public void doExecuteTask() throws Throwable
    {
        if (_threadIncrementCount == 0)
        {
            return;
        }
        _log.info("Thread increment of '" + _threadIncrementCount + "' thread(s)");
        try
        {
            _log.debug("Incrementing thread count by '" + _threadIncrementCount + "'");
            _scheduler.addThreads(_threadIncrementCount);
        }
        catch (Throwable e)
        {
            _log.error(e.getMessage(), e);
        }
    }

    public int getMaxTime()
    {
        return 0;
    }
}
