#!/bin/sh

for JAR in `ls lib` ; do
    CP=$CP:./lib/$JAR
done

for JAR in `ls user-lib` ; do
    CP=$CP:./lib/$JAR
done

export CLASSPATH=$CP
export CLASSPATH=./config:$CLASSPATH


if [ "X$RUNYJPPROFILER" != "X" ] ; then
  echo "Using YJP profiler"
  export PROFILE='-Xrunyjpagent:port=10001'
fi

if [ "X$NOTUNING" = "X" ] ; then
  export TUNING='-XX:NewSize=128m -XX:MaxNewSize=128m -XX:SurvivorRatio=8 -Xmx256M -server'
fi

if [ "X$VERBOSEGC" != "X" ] ; then
  export VERBOSEGC='-verbose:gc -XX:+PrintGCTimeStamps -XX:+PrintGCDetails'
fi

if [ "X$JAVA_HOME" = "X" ] ; then
  echo "JAVA_HOME is not set, please do so"
  exit 1;
fi

$JAVA_HOME/bin/java $VERBOSEGC $PROFILE $TUNING -cp $CLASSPATH net.sourceforge.basher.Basher $*
