/*
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package net.sourceforge.basher;

import junit.framework.TestCase;

/**
 * @author Johan Lindquist
 * @version 1.0
 */
public class TestAverage extends TestCase
{

    public void testAverage()
    {

        Average average = new Average(0, 100, 1100, 1000, 10,100,5,10);

        assertEquals("Bad min", 0.0F, average.getMinTime(), 0.0F);
        assertEquals("Bad max", 100.0F, average.getMaxTime(), 0.0F);
        assertEquals("Bad total time", 1100.0F, average.getTotalTime(), 0.0F);
        assertEquals("Bad elapsed time", 1000.0F, average.getTimeElapsed(), 0.0F);
        assertEquals("Bad number of entries", 110, average.getTotalEntries());
        assertEquals("Bad number of failed", 100, average.getTotalFailed());
        assertEquals("Bad number of successful", 10, average.getTotalSuccessful());
        assertEquals("Bad number of not run", 5, average.getTotalNotRun());
        assertEquals("Bad TPS", 110.0F, average.getTPS(), 0.0F);
        assertEquals("Bad average", 10.0F, average.getAverage(),0.0F);
        assertNotNull("Null timestamp", average.getTimeStamp());

    }


    public void testAverageAllZero()
    {

        Average average = new Average(0, 0, 0, 0, 0,0,0,10);

        assertEquals("Bad min", 0.0F, 0F, average.getMinTime());
        assertEquals("Bad max", 0.0F, 0F, average.getMaxTime());
        assertEquals("Bad total time", 0.0F, 0F, average.getTotalTime());
        assertEquals("Bad elapsed time", 0.0F, 0F, average.getTimeElapsed());
        assertEquals("Bad number of entries", 0, average.getTotalEntries());
        assertEquals("Bad TPS", 0.0F, 0.0F, average.getTPS());
        assertEquals("Bad average", 0.0F, 0.0F, average.getAverage());
        assertNotNull("Null timestamp", average.getTimeStamp());

    }

    public void testAverageToString()
    {
        Average average1 = new Average(0, 0, 0, 0, 0,0,0,10);

        assertEquals("Bad toString", "elapsed time: 0 min time: 0 max time: 0 total time: 0 invocations: 0 average time: 0 tps: 0.0 num threads: 10", average1.toString());

        Average average2 = new Average(Long.MAX_VALUE, 0, 0, 0, 0,0,0,10);
        assertEquals("Bad toString", "elapsed time: 0 min time: N/A max time: 0 total time: 0 invocations: 0 average time: 0 tps: 0.0 num threads: 10", average2.toString());

    }

}
