/*
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package net.sourceforge.basher;

import junit.framework.TestCase;

/**
 * @author Johan Lindquist
 */
public class TestExceptions extends TestCase
{

    public void testTaskNotRunException()
    {
        TaskNotRunException taskNotRunException1 = new TaskNotRunException("message");
        TaskNotRunException taskNotRunException2 = new TaskNotRunException("message");
        TaskNotRunException taskNotRunException3 = new TaskNotRunException("other-message");
        assertEquals("Bad message", "message", taskNotRunException1.getMessage());
        assertEquals("Bad equals", taskNotRunException1, taskNotRunException1);
        assertEquals("Bad equals", taskNotRunException1, taskNotRunException2);
        assertNotSame("Bad equals", taskNotRunException1, taskNotRunException3);
        assertNotSame("Bad equals", taskNotRunException1, null);
        assertFalse("Bad equals", taskNotRunException1.equals(null));

    }

    public void testBasherException()
    {
        final NullPointerException throwable = new NullPointerException();
        BasherException basherException1 = new BasherException("message", throwable);
        BasherException basherException2 = new BasherException("message", throwable);
        BasherException basherException3 = new BasherException("other-message", new NullPointerException());
        assertEquals("Bad message", "message", basherException1.getMessage());
        assertEquals("Bad equals", basherException1, basherException1);
        assertEquals("Bad equals", basherException1, basherException2);
        assertNotSame("Bad equals", basherException1, basherException3);
        assertNotSame("Bad equals", basherException1, null);
        assertFalse("Bad equals", basherException1.equals(null));
    }

    public void testBasherExceptionNullCause()
    {
        BasherException basherException1 = new BasherException("message", null);
        BasherException basherException2 = new BasherException("message", null);
        BasherException basherException3 = new BasherException("other-message", null);
        assertEquals("Bad message", "message", basherException1.getMessage());
        assertEquals("Bad equals", basherException1, basherException1);
        assertEquals("Bad equals", basherException1, basherException2);
        assertNotSame("Bad equals", basherException1, basherException3);
        assertFalse("Bad equals", basherException1.equals(null));
    }


    public void testTaskFailedException()
    {
        final NullPointerException throwable = new NullPointerException();
        TaskFailedException taskFailedException1 = new TaskFailedException("message", throwable);
        TaskFailedException taskFailedException2 = new TaskFailedException("message", throwable);
        TaskFailedException taskFailedException3 = new TaskFailedException("other-message", new NullPointerException());

        assertEquals("Bad message", "message", taskFailedException1.getMessage());
        assertEquals("Bad equals", taskFailedException1, taskFailedException1);
        assertEquals("Bad equals", taskFailedException1, taskFailedException2);
        assertNotSame("Bad equals", taskFailedException1, taskFailedException3);
        assertNotSame("Bad equals", taskFailedException1, null);
        assertFalse("Bad equals", taskFailedException1.equals(null));
    }

    public void testTaskFailedExceptionWithNullCause()
    {
        final NullPointerException throwable = new NullPointerException();
        TaskFailedException taskFailedException1 = new TaskFailedException("message", null);
        TaskFailedException taskFailedException2 = new TaskFailedException("message", null);
        TaskFailedException taskFailedException3 = new TaskFailedException("other-message", null);

        assertEquals("Bad message", "message", taskFailedException1.getMessage());
        assertEquals("Bad equals", taskFailedException1, taskFailedException1);
        assertEquals("Bad equals", taskFailedException1, taskFailedException2);
        assertNotSame("Bad equals", taskFailedException1, taskFailedException3);
        assertFalse("Bad equals", taskFailedException1.equals(null));
    }


}
