package net.sourceforge.basher.events;

import java.util.concurrent.atomic.AtomicLong;

import junitx.extensions.EqualsHashCodeTestCase;

/**
 * @author Johan Lindquist
 * @version $Revision$
 */
public class TestCollectionStartedEvent extends EqualsHashCodeTestCase
{
    public TestCollectionStartedEvent( String name )
    {
        super( name );
    }

    public void testEqualsHashCode()
    {
        CollectionStartedEvent collectionStartedEvent1 = new CollectionStartedEvent();
        CollectionStartedEvent collectionStartedEvent2 = new CollectionStartedEvent();
        
        assertEquals("bad equals", collectionStartedEvent1, collectionStartedEvent1);
        assertEquals("bad hashcode", collectionStartedEvent1.hashCode(), collectionStartedEvent1.hashCode());
        assertNotSame("bad equals", collectionStartedEvent1, collectionStartedEvent2);
        assertNotSame("bad hashcode", collectionStartedEvent2.hashCode(), collectionStartedEvent2.hashCode());

    }


    @Override
    protected Object createInstance() throws Exception
    {
        CollectionStartedEvent collectionStartedEvent = new CollectionStartedEvent();
        collectionStartedEvent.setCreationTime( 1 );
        return collectionStartedEvent;
    }

    @Override
    protected Object createNotEqualInstance() throws Exception
    {
        CollectionStartedEvent collectionStartedEvent = new CollectionStartedEvent();
        collectionStartedEvent.setCreationTime( 2 );
        return collectionStartedEvent;
    }
}
