package net.sourceforge.basher.events;

import junitx.extensions.EqualsHashCodeTestCase;

/**
 * @author Johan Lindquist
 * @version $Revision$
 */
public class TestCollectionStoppedEvent extends EqualsHashCodeTestCase
{
    public TestCollectionStoppedEvent( String name )
    {
        super( name );
    }

    public void testEqualsHashCode()
    {
        CollectionStoppedEvent collectionStoppedEvent1  = new CollectionStoppedEvent();
        CollectionStoppedEvent collectionStoppedEvent2 = new CollectionStoppedEvent();

        assertEquals("bad equals", collectionStoppedEvent1, collectionStoppedEvent1);
        assertEquals("bad hashcode", collectionStoppedEvent1.hashCode(), collectionStoppedEvent1.hashCode());
        assertNotSame("bad equals", collectionStoppedEvent1, collectionStoppedEvent2);
        assertNotSame("bad hashcode", collectionStoppedEvent2.hashCode(), collectionStoppedEvent2.hashCode());

    }


    @Override
    protected Object createInstance() throws Exception
    {
        CollectionStoppedEvent collectionStoppedEvent = new CollectionStoppedEvent();
        collectionStoppedEvent.setCreationTime( 1 );
        return collectionStoppedEvent;
    }

    @Override
    protected Object createNotEqualInstance() throws Exception
    {
        CollectionStoppedEvent collectionStoppedEvent = new CollectionStoppedEvent();
        collectionStoppedEvent.setCreationTime( 2 );
        return collectionStoppedEvent;
    }
}