package net.sourceforge.basher.events;

import junitx.extensions.EqualsHashCodeTestCase;
import net.sourceforge.basher.BasherContext;
import net.sourceforge.basher.Phase;

/**
 * @author Johan Lindquist
 * @version $Revision$
 */
public class TestPhaseTransitionEvent extends EqualsHashCodeTestCase
{
    final BasherContext context = new BasherContext();

    public TestPhaseTransitionEvent( String name )
    {
        super( name );
    }

    public void testValues()
    {
        final BasherContext context = new BasherContext();
        PhaseTransitionEvent phaseTransitionEvent = new PhaseTransitionEvent(context, Phase.SETUP,Phase.RUN);

        assertEquals("bad context", context, phaseTransitionEvent.getBasherContext());
        assertEquals("bad context", Phase.SETUP, phaseTransitionEvent.getOldPhase());
        assertEquals("bad context", Phase.RUN, phaseTransitionEvent.getNewPhase());

    }


    @Override
    protected Object createInstance() throws Exception
    {
        return new PhaseTransitionEvent(context, Phase.SETUP, Phase.RUN);
    }

    @Override
    protected Object createNotEqualInstance() throws Exception
    {
        return new PhaseTransitionEvent(context, Phase.RUN, Phase.COOLDOWN);
    }
}
