/*
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package net.sourceforge.basher.internal.impl;

import java.io.File;

import junit.framework.TestCase;
import org.apache.commons.logging.Log;
import org.easymock.MockControl;

/**
 * @author Johan Lindquist
 * @version 1.0
 */
public class TestDefaultBeanShellFilenameComparator extends TestCase
{
    DefaultBeanShellFilenameComparator _defaultBeanShellFilenameComparator;

    protected void setUp() throws Exception
    {
        super.setUp();

        MockControl logControl = MockControl.createControl(Log.class);
        Log log = (Log) logControl.getMock();

        _defaultBeanShellFilenameComparator = new DefaultBeanShellFilenameComparator();
        _defaultBeanShellFilenameComparator.setLog(log);

    }

    protected void tearDown() throws Exception
    {
        super.tearDown();    //To change body of overridden methods use File | Settings | File Templates.
    }


    public void testEquals()
    {


        File f1 = new File("S10-test1.bsh");
        File f2 = new File("S10-test1.bsh");

        // Equals check
        int comp = _defaultBeanShellFilenameComparator.compare(f1, f2);
        assertEquals("Invalid sort", 0, comp);

    }

    public void testGreater()
    {
        File f1 = new File("S10-test1.bsh");
        File f2 = new File("S20-test1.bsh");

        // Normal sort
        int comp = _defaultBeanShellFilenameComparator.compare(f1, f2);
        assertEquals("Invalid sort", -1, comp);
    }

    public void testLess()
    {
        File f1 = new File("S10-test1.bsh");
        File f2 = new File("S20-test1.bsh");

        // Reverse sort
        int comp = _defaultBeanShellFilenameComparator.compare(f2, f1);
        assertEquals("Invalid sort", 1, comp);

    }

    public void testEqualRunLevelDifferentName()
    {
        File f1 = new File("S10-test1.bsh");
        File f2 = new File("S10-test2.bsh");

        // Equals runlevel check
        int comp = _defaultBeanShellFilenameComparator.compare(f1, f2);
        assertEquals("Invalid sort", -1, comp);
    }


}
