/*
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package net.sourceforge.basher.internal.impl;

import java.io.File;
import java.util.regex.Pattern;

import junit.framework.TestCase;
import org.apache.commons.logging.Log;
import org.easymock.MockControl;

/**
 * @author Johan Lindquist
 * @version 1.0
 */
public class TestDefaultBeanShellFilenameFilter extends TestCase
{
    private DefaultBeanShellFilenameFilter _defaultBeanShellFilenameFilter;


    protected void setUp() throws Exception
    {
        MockControl logControl = MockControl.createControl(Log.class);
        Log log = (Log) logControl.getMock();


        _defaultBeanShellFilenameFilter = new DefaultBeanShellFilenameFilter();
        _defaultBeanShellFilenameFilter.setLog(log);
    }

    protected void tearDown() throws Exception
    {
        super.tearDown();
    }

    public void testAcceptAll()
    {
        Pattern pattern = Pattern.compile(".*");
        _defaultBeanShellFilenameFilter.setFileMask(pattern);

        File f1 = new File("somename");

        boolean result = _defaultBeanShellFilenameFilter.accept(f1, "test");
        assertTrue("File not accepted", result);


    }

    public void testDefaultPatternAccept()
    {
        Pattern pattern = Pattern.compile("S[0-9][0-9]{0,1}-.*\\.bsh");
        _defaultBeanShellFilenameFilter.setFileMask(pattern);

        File f1 = new File("somename");

        boolean result = _defaultBeanShellFilenameFilter.accept(f1, "S10-beanshell-test.bsh");
        assertTrue("File not accepted", result);

        result = _defaultBeanShellFilenameFilter.accept(f1, "S2-beanshell-test.bsh");
        assertTrue("File not accepted", result);
    }

    public void testDefaultPatternNotAccept()
    {
        Pattern pattern = Pattern.compile("S[0-9][0-9]{0,1}-.*\\.bsh");
        _defaultBeanShellFilenameFilter.setFileMask(pattern);

        File f1 = new File("somename");

        boolean result = _defaultBeanShellFilenameFilter.accept(f1, "S-10-beanshell-test.bsh");
        assertFalse("File accepted", result);

        result = _defaultBeanShellFilenameFilter.accept(f1, "AS2-beanshell-test.bsh");
        assertFalse("File accepted", result);

        result = _defaultBeanShellFilenameFilter.accept(f1, "S2-beanshell-test.bshs");
        assertFalse("File accepted", result);

        result = _defaultBeanShellFilenameFilter.accept(f1, "beanshell-test.bsh");
        assertFalse("File accepted", result);

    }
}
