/*
 * Decompiled with CFR 0.152.
 */
package org.mikha.utils.web;

import java.io.IOException;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import javax.servlet.RequestDispatcher;
import javax.servlet.ServletContext;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.mikha.utils.web.ControllerMethodMapping;
import org.mikha.utils.web.HttpMethod;
import org.mikha.utils.web.HttpParamsRequest;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ControllerDispatcher {
    public static final String VIEW_BASE = "/WEB-INF/view/";
    private final Class<?> controllerClass;
    private final ServletContext servletContext;
    private final Map<HttpMethod, Map<String, MethodInvoker>> mappings = new HashMap<HttpMethod, Map<String, MethodInvoker>>();
    private final ConcurrentHashMap<String, RequestDispatcher> viewDispatchers = new ConcurrentHashMap();

    public ControllerDispatcher(Class<?> controllerClass, ServletContext servletContext, String controllerName) throws ServletException {
        this.controllerClass = controllerClass;
        this.servletContext = servletContext;
        for (Method m : controllerClass.getMethods()) {
            ControllerMethodMapping um = m.getAnnotation(ControllerMethodMapping.class);
            if (um == null) continue;
            MethodInvoker mi = new MethodInvoker(m);
            for (HttpMethod hm : um.methods()) {
                Map<String, MethodInvoker> mm = this.mappings.get((Object)hm);
                if (mm == null) {
                    mm = new HashMap<String, MethodInvoker>();
                    this.mappings.put(hm, mm);
                }
                for (String path : um.paths()) {
                    MethodInvoker old = mm.put(path, mi);
                    if (old == null) continue;
                    throw new ServletException(String.format("Invalid controller class %s: mapping conflicts for HTTP method %s and path %s - %s vs. %s", new Object[]{controllerClass, hm, path, mi, old}));
                }
            }
        }
        if (this.mappings.size() == 0) {
            throw new ServletException("Invalid controller class " + controllerClass + ": no mappings defined");
        }
    }

    public void service(Object ctr, HttpServletRequest req, HttpServletResponse rsp) throws ServletException, IOException {
        if (ctr == null || !this.controllerClass.isAssignableFrom(ctr.getClass())) {
            throw new IllegalArgumentException("Invalid controller instance " + ctr + ": not an instance of " + this.controllerClass.getCanonicalName());
        }
        HttpMethod hm = HttpMethod.valueOf(req.getMethod());
        String path = req.getPathInfo();
        MethodInvoker m = null;
        Map<String, MethodInvoker> mm = this.mappings.get((Object)hm);
        if (mm != null) {
            if (path != null) {
                m = mm.get(path);
            }
            if (m == null) {
                m = mm.get("");
            }
        }
        if (m == null) {
            rsp.sendError(404, "no mapping defined for path \"" + path + "\" and HTTP method " + (Object)((Object)hm));
            return;
        }
        HttpParamsRequest ereq = HttpParamsRequest.wrap((ServletRequest)req);
        String view = m.invoke(ctr, ereq, rsp);
        if (view != null) {
            RequestDispatcher rd = this.viewDispatchers.get(view);
            if (rd == null) {
                rd = this.servletContext.getRequestDispatcher(VIEW_BASE + view);
                if (rd == null) {
                    throw new ServletException("Cannot find view " + view + " for method " + m + " of " + this.controllerClass);
                }
                this.viewDispatchers.put(view, rd);
            }
            rd.forward((ServletRequest)ereq, (ServletResponse)rsp);
        }
    }

    private static class MethodInvoker {
        private static final ParamAdapter REQUEST_ADAPTER = new ParamAdapter(){

            public Object adapt(HttpParamsRequest req, HttpServletResponse rsp) {
                return req;
            }
        };
        private static final ParamAdapter RESPONSE_ADAPTER = new ParamAdapter(){

            public Object adapt(HttpParamsRequest req, HttpServletResponse rsp) {
                return rsp;
            }
        };
        private final Method method;
        private final ParamAdapter[] paramAdapters;

        public MethodInvoker(Method method) throws IllegalArgumentException {
            this.method = method;
            if (method.getReturnType() != Void.TYPE && method.getReturnType() != String.class) {
                throw new IllegalArgumentException("Invalid method " + method + ": only void and String return types are supported");
            }
            Class<?>[] clss = method.getParameterTypes();
            this.paramAdapters = new ParamAdapter[clss.length];
            for (int i = 0; i < clss.length; ++i) {
                try {
                    if (clss[i].isAssignableFrom(HttpParamsRequest.class)) {
                        this.paramAdapters[i] = REQUEST_ADAPTER;
                        continue;
                    }
                    if (clss[i].isAssignableFrom(HttpServletResponse.class)) {
                        this.paramAdapters[i] = RESPONSE_ADAPTER;
                        continue;
                    }
                    throw new IllegalArgumentException("Unsupported parameter type " + clss[i].getCanonicalName());
                }
                catch (Exception ex) {
                    throw new IllegalArgumentException("Invalid method " + method + ": invalid parameter #" + (i + 1), ex);
                }
            }
        }

        public String invoke(Object ctr, HttpParamsRequest req, HttpServletResponse rsp) throws ServletException, IOException {
            try {
                Object[] params = new Object[this.paramAdapters.length];
                for (int i = 0; i < this.paramAdapters.length; ++i) {
                    params[i] = this.paramAdapters[i].adapt(req, rsp);
                }
                return (String)this.method.invoke(ctr, params);
            }
            catch (InvocationTargetException itex) {
                Throwable cause = itex.getCause();
                if (cause instanceof ServletException) {
                    throw (ServletException)cause;
                }
                if (cause instanceof IOException) {
                    throw (IOException)cause;
                }
                throw new ServletException("Unexpected exception in method " + this.method + " of " + ctr.getClass(), cause);
            }
            catch (Exception ex) {
                throw new ServletException("Unexpected exception in method " + this.method + " of " + ctr.getClass(), (Throwable)ex);
            }
        }

        private static interface ParamAdapter {
            public Object adapt(HttpParamsRequest var1, HttpServletResponse var2);
        }
    }
}

