/*
 * Decompiled with CFR 0.152.
 */
package org.mikha.utils.web;

import java.io.IOException;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletRequestWrapper;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.fileupload.FileItem;
import org.mikha.utils.net.UrlAndParams;
import org.mikha.utils.web.multipart.MultipartRequestWrapper;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class HttpParamsRequest
extends HttpServletRequestWrapper {
    public static final Pattern PATTERN_EMAIL = Pattern.compile("[A-Z0-9._%+-]+@[A-Z0-9.-]+\\.[A-Z]{2,4}", 2);
    public static final String ATTR_ERROR_STATES = "_errors";
    public static final String ATTR_ERROR_MESSAGES = "_error_messages";
    public static final String ATTR_MESSAGE_TEXT = "_message";
    public static final String ATTR_MESSAGE_PARAMS = "_message_params";
    public static final String ATTR_MESSAGE_ACTIONS = "_message_actions";
    private static final ParamParser<String> STRING_PARSER = new ParamParser<String>(){

        @Override
        public String parse(HttpParamsRequest req, String name, String value, boolean mandatory, String defValue) {
            if (value == null) {
                if (mandatory) {
                    req.logParameterError(name);
                }
                return defValue;
            }
            if (value.length() == 0) {
                if (mandatory) {
                    req.logParameterError(name);
                }
                return defValue;
            }
            return value;
        }

        public String[] createArray(int length) {
            return new String[length];
        }
    };
    private static final ParamParser<Integer> INTEGER_PARSER = new ParamParser<Integer>(){

        @Override
        public Integer parse(HttpParamsRequest req, String name, String value, boolean mandatory, Integer defValue) {
            if (value == null) {
                if (mandatory) {
                    req.logParameterError(name);
                }
                return defValue;
            }
            if ((value = value.trim()).length() == 0) {
                if (mandatory) {
                    req.logParameterError(name);
                }
                return defValue;
            }
            try {
                return Integer.parseInt(value);
            }
            catch (NumberFormatException nfex) {
                req.logParameterError(name);
                return null;
            }
        }

        public Integer[] createArray(int length) {
            return new Integer[length];
        }
    };
    private static final ParamParser<Double> DOUBLE_PARSER = new ParamParser<Double>(){

        @Override
        public Double parse(HttpParamsRequest req, String name, String value, boolean mandatory, Double defValue) {
            if (value == null) {
                if (mandatory) {
                    req.logParameterError(name);
                }
                return defValue;
            }
            if ((value = value.trim()).length() == 0) {
                if (mandatory) {
                    req.logParameterError(name);
                }
                return defValue;
            }
            try {
                return Double.parseDouble(value);
            }
            catch (NumberFormatException nfex) {
                req.logParameterError(name);
                return null;
            }
        }

        public Double[] createArray(int length) {
            return new Double[length];
        }
    };
    private static final ParamParser<Boolean> BOOLEAN_PARSER = new ParamParser<Boolean>(){

        @Override
        public Boolean parse(HttpParamsRequest req, String name, String value, boolean mandatory, Boolean defValue) {
            return value != null ? Boolean.parseBoolean(value) : Boolean.FALSE;
        }

        public Boolean[] createArray(int length) {
            return new Boolean[length];
        }
    };
    private final Set<String> paramsWithErrors;
    private final Map<String, String> errorMessagesByParam;
    private boolean hasRecentErrors = false;

    public static HttpParamsRequest wrap(ServletRequest request) throws ServletException {
        if (request instanceof HttpParamsRequest) {
            return (HttpParamsRequest)request;
        }
        return new HttpParamsRequest((HttpServletRequest)request);
    }

    private HttpParamsRequest(HttpServletRequest request) {
        super(request);
        HashSet paramsWithErrors = (HashSet)request.getAttribute(ATTR_ERROR_STATES);
        if (paramsWithErrors == null) {
            paramsWithErrors = new HashSet();
            request.setAttribute(ATTR_ERROR_STATES, paramsWithErrors);
        }
        this.paramsWithErrors = paramsWithErrors;
        HashMap errorMessagesByParam = (HashMap)request.getAttribute(ATTR_ERROR_MESSAGES);
        if (errorMessagesByParam == null) {
            errorMessagesByParam = new HashMap();
            request.setAttribute(ATTR_ERROR_MESSAGES, errorMessagesByParam);
        }
        this.errorMessagesByParam = errorMessagesByParam;
    }

    public Map<String, FileItem> getFilesMap() {
        return MultipartRequestWrapper.getFilesMap((HttpServletRequest)this);
    }

    public FileItem getFile(String name) {
        return MultipartRequestWrapper.getFile((HttpServletRequest)this, name);
    }

    public String getString(String name) {
        return STRING_PARSER.parse(this, name, this.getParameter(name), true, null);
    }

    public String getString(String name, String defValue) {
        return STRING_PARSER.parse(this, name, this.getParameter(name), false, defValue);
    }

    public String[] getStringArray(String name, int maxLength) {
        return this.parseArray(STRING_PARSER, name, maxLength, true, null);
    }

    public String[] getStringArray(String name, int maxLength, String defValue) {
        return this.parseArray(STRING_PARSER, name, maxLength, false, defValue);
    }

    public String getEmail(String name) {
        Matcher m;
        String r = STRING_PARSER.parse(this, name, this.getParameter(name), true, null);
        if (r != null && !(m = PATTERN_EMAIL.matcher(r)).matches()) {
            this.logParameterError(name);
            return null;
        }
        return r;
    }

    public String getEmail(String name, String defValue) {
        Matcher m;
        String r = STRING_PARSER.parse(this, name, this.getParameter(name), false, defValue);
        if (r != null && !(m = PATTERN_EMAIL.matcher(r)).matches()) {
            this.logParameterError(name);
            return null;
        }
        return r;
    }

    public Integer getInteger(String name) {
        return INTEGER_PARSER.parse(this, name, this.getParameter(name), true, null);
    }

    public Integer getInteger(String name, Integer defValue) {
        return INTEGER_PARSER.parse(this, name, this.getParameter(name), false, defValue);
    }

    public Integer[] getIntegerArray(String name, int maxLength) {
        return this.parseArray(INTEGER_PARSER, name, maxLength, true, null);
    }

    public Integer[] getIntegerArray(String name, int maxLength, Integer defValue) {
        return this.parseArray(INTEGER_PARSER, name, maxLength, false, defValue);
    }

    public Double getDouble(String name) {
        return DOUBLE_PARSER.parse(this, name, this.getParameter(name), true, null);
    }

    public Double getDouble(String name, Double defValue) {
        return DOUBLE_PARSER.parse(this, name, this.getParameter(name), false, defValue);
    }

    public Double[] getDoubleArray(String name, int maxLength) {
        return this.parseArray(DOUBLE_PARSER, name, maxLength, true, null);
    }

    public Double[] getDoubleArray(String name, int maxLength, Double defValue) {
        return this.parseArray(DOUBLE_PARSER, name, maxLength, false, defValue);
    }

    public boolean getBoolean(String name) {
        return BOOLEAN_PARSER.parse(this, name, this.getParameter(name), false, Boolean.FALSE);
    }

    public Boolean[] getBooleanArray(String name, int maxLength) {
        return this.parseArray(BOOLEAN_PARSER, name, maxLength, false, Boolean.FALSE);
    }

    public <O> O getOption(String name, O[] options) {
        O result = null;
        String[] values = (String[])this.getParameterMap().get(name);
        if (values == null) {
            this.logParameterError(name);
            return null;
        }
        for (String v : values) {
            int i;
            if (result != null) {
                this.logParameterError(name);
                return null;
            }
            try {
                i = Integer.parseInt(v.trim());
            }
            catch (NumberFormatException nfex) {
                this.logParameterError(name);
                return null;
            }
            if (i < 0 || i >= options.length) {
                this.logParameterError(name);
                return null;
            }
            result = options[i];
        }
        if (result == null) {
            this.logParameterError(name);
            return null;
        }
        return result;
    }

    public <O> List<O> getOptions(String name, O[] options) {
        LinkedList<O> result = new LinkedList<O>();
        String[] values = (String[])this.getParameterMap().get(name);
        if (values == null) {
            return result;
        }
        for (String v : values) {
            int i;
            try {
                i = Integer.parseInt(v.trim());
            }
            catch (NumberFormatException nfex) {
                this.logParameterError(name);
                return null;
            }
            if (i < 0 || i >= options.length) {
                this.logParameterError(name);
                return null;
            }
            result.add(options[i]);
        }
        return result;
    }

    @Deprecated
    public void logError(String name) {
        this.logParameterError(name);
    }

    @Deprecated
    public void logError(String name, String error) {
        this.logParameterError(name, error);
    }

    public void logParameterError(String name) {
        this.hasRecentErrors = true;
        this.paramsWithErrors.add(name);
    }

    public void logParameterError(String name, String error) {
        this.logParameterError(name);
        this.errorMessagesByParam.put(name, error);
    }

    public boolean hasRecentErrors() {
        return this.hasRecentErrors;
    }

    public void clearRecentErrors() {
        this.hasRecentErrors = false;
    }

    public boolean hasErrors() {
        return this.paramsWithErrors.size() > 0;
    }

    @Deprecated
    public String getError(String param) {
        return this.getParameterError(param);
    }

    public boolean hasParameterError(String name) {
        return this.paramsWithErrors.contains(name);
    }

    public String getParameterError(String param) {
        return this.errorMessagesByParam.get(param);
    }

    public void setMessage(String msg, Object ... params) {
        this.setAttribute(ATTR_MESSAGE_TEXT, msg);
        this.setAttribute(ATTR_MESSAGE_PARAMS, params);
    }

    public void redirect(HttpServletResponse rsp, String url) throws ServletException {
        if (url.charAt(0) == '/') {
            url = this.getContextPath() + url;
        }
        url = rsp.encodeRedirectURL(url);
        try {
            rsp.sendRedirect(url);
        }
        catch (IOException ex) {
            throw new ServletException(String.format("Failed to redirect to \"%s\"", url), (Throwable)ex);
        }
    }

    public void redirect(HttpServletResponse rsp, UrlAndParams url) throws ServletException {
        this.redirect(rsp, url.toString());
    }

    private <T> T[] parseArray(ParamParser<T> parser, String name, int maxLength, boolean mandatory, T defValue) {
        boolean[] pr = new boolean[maxLength];
        Object[] arr = new Object[maxLength];
        int l = name.length();
        int length = 0;
        for (Map.Entry o : this.getParameterMap().entrySet()) {
            String[] v;
            Map.Entry e = o;
            String n = (String)e.getKey();
            if (!n.startsWith(name) || n.length() < l + 2 || n.charAt(l) != '-') continue;
            int idx = 0;
            try {
                idx = Integer.parseInt(n.substring(l + 1));
            }
            catch (NumberFormatException nfex) {
                continue;
            }
            if (idx >= maxLength) continue;
            if (idx >= length) {
                length = idx + 1;
            }
            if ((v = (String[])e.getValue()).length != 1) continue;
            arr[idx] = parser.parse(this, n, v[0], mandatory, defValue);
            pr[idx] = true;
        }
        for (int idx = 0; idx < length; ++idx) {
            if (pr[idx]) continue;
            String n = name + '-' + idx;
            arr[idx] = parser.parse(this, n, null, mandatory, defValue);
        }
        T[] r = parser.createArray(length);
        System.arraycopy(arr, 0, r, 0, length);
        return r;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static interface ParamParser<T> {
        public T parse(HttpParamsRequest var1, String var2, String var3, boolean var4, T var5);

        public T[] createArray(int var1);
    }
}

